/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import oracle.olapi.log.Log;
import oracle.olapi.log.LogSession;

public class LogLocator {
    public static final String LOG_PROPERTY_KEY = "properties";
    public static final String LOG_HANDLERLIST_KEY = "handlers";
    public static final String LOG_HANDLER_PREFIX = "log.";
    private String tag;
    private LogSession session = null;

    public static LogLocator createInstance(String string, Properties properties) {
        return new LogLocator(string, properties);
    }

    public static LogLocator createInstance(String string) {
        return LogLocator.createInstance(string, System.getProperties());
    }

    private LogLocator(String string, Properties properties) {
        try {
            this.tag = string;
            this.session = Log.getSession(string);
            if (this.session == null) {
                this.session = Log.create(string);
                String string2 = LOG_HANDLER_PREFIX + string + ".";
                String string3 = (String)properties.get(string2 + LOG_PROPERTY_KEY);
                Properties properties2 = this.loadProperties(properties, string2, string3);
                String string4 = (String)properties2.get(LOG_HANDLERLIST_KEY);
                this.session.addHandlers(string4, properties2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroy() {
        this.session.destroy();
        this.session = null;
        this.tag = null;
    }

    public LogSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(Properties properties, String string, String string2) {
        Properties properties2 = new Properties();
        InputStream inputStream = null;
        try {
            if (properties != null) {
                string = string.toLowerCase();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (string.length() != 0 && !string3.toLowerCase().startsWith(string)) continue;
                    properties2.put(string3.substring(string.length()), properties.get(string3));
                }
            }
            if (string2 != null) {
                if (string2.startsWith("file:")) {
                    string2 = string2.substring(string2.indexOf(58) + 1);
                    inputStream = new FileInputStream(string2);
                } else {
                    inputStream = this.getClass().getResourceAsStream(string2);
                }
                properties2.load(inputStream);
            }
        }
        catch (Exception exception) {}
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return properties2;
        }
    }
}

