/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import oracle.olapi.log.LogEndEvent;
import oracle.olapi.log.LogEvent;
import oracle.olapi.log.LogExceptionEvent;
import oracle.olapi.log.LogSessionState;
import oracle.olapi.log.LogSimpleEvent;
import oracle.olapi.log.LogStartEvent;

class LogEventFactory {
    private LogSessionState state = null;

    LogEventFactory(LogSessionState logSessionState) {
        this.state = logSessionState;
    }

    LogEvent createSimpleEvent(int n, String string) {
        return this.state.hasHandlers() ? new LogSimpleEvent(this.state.getNestingLevel(), n, string) : LogSimpleEvent.getPlaceHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogStartEvent createStartEvent(int n, String string) {
        try {
            LogStartEvent logStartEvent = this.state.hasHandlers() ? new LogStartEvent(this.state.getNestingLevel(), n, string) : (LogStartEvent)LogStartEvent.getPlaceHolder();
            return logStartEvent;
        }
        finally {
            this.state.incNestingLevel();
        }
    }

    LogEndEvent createEndEvent(LogStartEvent logStartEvent, String string) {
        this.state.decNestingLevel();
        return this.state.hasHandlers() ? new LogEndEvent(logStartEvent, string) : (LogEndEvent)LogEndEvent.getPlaceHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogEndEvent createElapsedEvent(LogEvent logEvent, String string) {
        try {
            this.state.decNestingLevel();
            LogEndEvent logEndEvent = this.state.hasHandlers() ? new LogEndEvent(logEvent, string) : (LogEndEvent)LogEndEvent.getPlaceHolder();
            return logEndEvent;
        }
        finally {
            this.state.incNestingLevel();
        }
    }

    LogEvent createExceptionEvent(int n, String string, Throwable throwable) {
        return this.state.hasHandlers() ? new LogExceptionEvent(this.state.getNestingLevel(), n, string, throwable) : LogExceptionEvent.getPlaceHolder();
    }
}

