/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.olapi.internal.CopyException;
import oracle.olapi.internal.CopyPolicy;
import oracle.olapi.internal.Copyable;

public class DeepCopyPolicy
implements CopyPolicy {
    private HashMap _copyMap;

    public DeepCopyPolicy() {
        this._copyMap = new HashMap();
    }

    public DeepCopyPolicy(Map map) {
        this._copyMap = new HashMap(map);
    }

    public Object deepCopy(Copyable copyable) throws CopyException {
        return this.copyDownReference(copyable);
    }

    @Override
    public Object copyDownReference(Object object) throws CopyException {
        if (this._copyMap.containsKey(object)) {
            Object v = this._copyMap.get(object);
            if (v != null) {
                return v;
            }
            throw new CopyException("Copy Error: Circular reference to object '" + object.toString() + "'!");
        }
        Object object2 = object;
        if (object instanceof Copyable) {
            this._copyMap.put(object, null);
            object2 = ((Copyable)object).copyLocal(this);
            this._copyMap.put(object, object2);
        }
        return object2;
    }

    @Override
    public Object copyUpReference(Object object) throws CopyException {
        if (this._copyMap.containsKey(object)) {
            Object v = this._copyMap.get(object);
            if (v != null) {
                return v;
            }
            throw new CopyException("Copy Error: Circular reference to object '" + object.toString() + "':\n" + "Trying to copy a reference to an object which is still being copied.\n" + "You must restructure the object's copyLocal() method so that it \n" + "registers the object's copy using CopyPolicy.registerCopy()\n" + "before the nested copy gets this far.");
        }
        return object;
    }

    @Override
    public Object copyExternalReference(Object object) throws CopyException {
        return this.copyUpReference(object);
    }

    @Override
    public Object getCopy(Object object) {
        Object v = this._copyMap.get(object);
        if (v == null) {
            return object;
        }
        return v;
    }

    @Override
    public void registerCopy(Object object, Object object2) {
        this._copyMap.put(object, object2);
    }

    @Override
    public Object copyReference(Object object, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        if (copyReferenceType == UP_REFERENCE_TYPE) {
            return this.copyUpReference(object);
        }
        if (copyReferenceType == DOWN_REFERENCE_TYPE) {
            return this.copyDownReference(object);
        }
        if (copyReferenceType == EXTERNAL_REFERENCE_TYPE) {
            return this.copyExternalReference(object);
        }
        throw new CopyException("Invalid copyMode: " + copyReferenceType.getName());
    }
}

