/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.lang.reflect.Method;
import java.util.Hashtable;

class MethodExecutor {
    private static Hashtable primitives = new Hashtable();
    private static MethodExecutor _instance = new MethodExecutor();

    private MethodExecutor() {
    }

    public static Object invoke(Object object, String string, Object[] objectArray) throws Exception {
        return _instance.execute(object, string, objectArray);
    }

    private Object execute(Object object, String string, Object[] objectArray) throws Exception {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        Method method = this.findMatchingMethod(object.getClass(), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException("Object " + object + " does not have a method " + string);
        }
        return method.invoke(object, objectArray);
    }

    protected Method findMatchingMethod(Class clazz, String string, Class[] classArray) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(string) || !this.matchParameterTypes(method.getParameterTypes(), classArray)) continue;
            return method;
        }
        return null;
    }

    protected boolean matchParameterTypes(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz;
            if (classArray[i] == classArray2[i] || classArray[i].isAssignableFrom(classArray2[i]) || (clazz = this.getPrimitiveType(classArray[i])) != null && clazz.equals(classArray2[i])) continue;
            return false;
        }
        return true;
    }

    public Class getPrimitiveType(Class clazz) {
        return (Class)primitives.get(clazz);
    }

    static {
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
    }
}

