/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import oracle.express.olapi.replay.OutputHandler;

public class FileOutputHandler
implements OutputHandler {
    public static final String FILENAMEPATTERN = "sd-{0,date,yyyyMMdd-HHmmssSSS}.xml";
    private File _directory;
    private static MessageFormat _fileName = new MessageFormat("sd-{0,date,yyyyMMdd-HHmmssSSS}.xml");

    public FileOutputHandler(File file) throws IOException {
        if (!file.isDirectory() || !file.canWrite()) {
            throw new IOException(file + " is not a writable directory.");
        }
        this._directory = file;
    }

    public File getDirectory() {
        return this._directory;
    }

    public FileOutputHandler(String string) throws IOException {
        this(new File(string));
    }

    protected synchronized File createFileName() {
        String string = _fileName.format(new Object[]{new Date()});
        return new File(this._directory, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(String string) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.createFileName()));
            writer.write(string);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

