/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiTracer;
import oracle.express.idl.util.SegmentedByteArrayOutputStream;
import oracle.express.idl.util.SegmentedStringWriter;
import oracle.olapi.UnsupportedOperationException;

public final class XMLWriter {
    private StringBuffer m_StringBuffer = null;
    private int m_IndentLevel = 0;
    private boolean m_CanCompress = false;
    private boolean m_CanSegment = false;
    private boolean m_DoIndent = false;
    private int m_TotalLength = 0;
    private byte[] m_UtfLeftover = new byte[31744];
    private int m_UtfLeftoverCount = 0;
    private XMLWriter m_NextXMLWriter = null;
    private byte[][] m_CompressedBytes = new byte[0][];
    private SegmentedByteArrayOutputStream m_BytesSegments = null;
    private Vector m_BytesSegmentLengths = null;
    private SegmentedStringWriter m_StringSegments = null;
    public static boolean DEBUG_PRINT_XML = false;

    public XMLWriter(InterfaceStub interfaceStub) {
        this(interfaceStub, null);
    }

    public XMLWriter(InterfaceStub interfaceStub, String string) {
        OlapiTracer.enter("XMLWriter.constructor");
        this.m_StringBuffer = new StringBuffer();
        if (interfaceStub.isPostServerVsnnum("10.1.0.3.0") && 2 == interfaceStub.getRpcProperties().getRpcStyle() && 0L < interfaceStub.getRpcProperties().getRpcCompression()) {
            this.m_CanCompress = true;
        }
        if (interfaceStub.isPostServerVsnnum("10.1.0.4.0") && 2 == interfaceStub.getRpcProperties().getRpcStyle()) {
            this.m_CanSegment = true;
        }
        if (!this.m_CanCompress) {
            this.m_StringSegments = new SegmentedStringWriter(true);
        }
        if (null != string) {
            this.append(string);
        }
        OlapiTracer.log("m_CanCompress = " + this.m_CanCompress);
        OlapiTracer.log("m_CanSegment = " + this.m_CanSegment);
        OlapiTracer.leave("XMLWriter.constructor");
    }

    public XMLWriter() {
        this.m_DoIndent = true;
        this.m_CanCompress = false;
        this.m_CanSegment = true;
        this.m_StringSegments = new SegmentedStringWriter(true);
    }

    public void append(String string) {
        if (DEBUG_PRINT_XML) {
            System.out.print(string);
        }
        if (null != string) {
            if (this.m_CanCompress) {
                this.getStringBuffer().append(string);
                if (31744 <= this.getStringBuffer().length()) {
                    this.compress(false);
                }
            } else {
                this.m_StringSegments.write(string);
            }
            this.m_TotalLength += string.length();
        }
    }

    public void append(char c) {
        if (DEBUG_PRINT_XML) {
            System.out.print(c);
        }
        if (this.m_CanCompress) {
            this.getStringBuffer().append(c);
            if (31744 <= this.getStringBuffer().length()) {
                this.compress(false);
            }
        } else {
            this.m_StringSegments.write(c);
        }
        ++this.m_TotalLength;
    }

    public void appendAttribute(String string, String string2, boolean bl) {
        if (null == string2) {
            return;
        }
        this.newLine();
        this.append(string);
        this.append("=");
        this.quote(string2, bl);
    }

    public void appendAttribute(String string, String string2) {
        this.appendAttribute(string, string2, true);
    }

    public void appendAttribute(String string, boolean bl) {
        this.appendAttribute(string, bl ? "True" : "False");
    }

    public void appendAttribute(String string, int n) {
        this.appendAttribute(string, Integer.toString(n));
    }

    public void beginElement(String string) {
        this.newLine();
        this.openTag();
        this.append(string);
        this.incrementIndentLevel();
    }

    public void closeTag() {
        this.append(">");
    }

    private void decrementIndentLevel() {
        --this.m_IndentLevel;
    }

    public void endElement() {
        this.slash();
        this.closeTag();
        this.decrementIndentLevel();
    }

    public void endElement(String string) {
        this.decrementIndentLevel();
        this.newLine();
        this.openTag();
        this.slash();
        this.append(string);
        this.closeTag();
    }

    public void beginDocType(String string, String string2) {
        this.newLine();
        this.openDocTypeTag();
        this.append(string);
        this.append(' ');
        if (null != string2) {
            this.append(string2);
            this.append(' ');
        }
        this.append('[');
        this.incrementIndentLevel();
    }

    public void endDocType() {
        this.newLine();
        this.append("]>");
        this.decrementIndentLevel();
    }

    public void appendParameterEntityDecl(String string, String string2, String string3) {
        this.newLine();
        this.openEntityTag();
        this.append("% ");
        this.append(string);
        if (null == string2) {
            this.append(" SYSTEM \"");
        } else {
            this.append(" PUBLIC \"");
            this.append(string2);
            this.append("\" \"");
        }
        this.append(string3);
        this.append('\"');
        this.closeTag();
    }

    public void appendParameterEntityRef(String string) {
        this.newLine();
        this.append('%');
        this.append(string);
        this.append(';');
    }

    public void appendCData(String string) {
        this.newLine();
        this.openCData();
        this.append(string);
        this.closeCData();
    }

    protected int getIndentLevel() {
        return this.m_IndentLevel;
    }

    private StringBuffer getStringBuffer() {
        return this.m_StringBuffer;
    }

    protected void incrementIndentLevel() {
        ++this.m_IndentLevel;
    }

    public void newLine() {
        this.append("\n");
        if (this.doIndent()) {
            for (int i = 0; i < this.getIndentLevel(); ++i) {
                this.append("  ");
            }
        }
    }

    private void openTag() {
        this.append('<');
    }

    private void openDocTypeTag() {
        this.append("<!DOCTYPE ");
    }

    private void openEntityTag() {
        this.append("<!ENTITY ");
    }

    private void openCData() {
        this.append("<![CDATA[");
    }

    private void closeCData() {
        this.append("]]>");
    }

    public void quote(String string, boolean bl) {
        this.append('\"');
        if (bl) {
            this.append(XMLWriter.escapeString(string));
        } else {
            this.append(string);
        }
        this.append('\"');
    }

    public void quote(String string) {
        this.quote(string, true);
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block10;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block10;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("&#xA;");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("&#x9;");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                    continue block10;
                }
            }
        }
        return stringBuffer.toString();
    }

    private void slash() {
        this.append('/');
    }

    public XMLWriter getNextXMLWriter() {
        return this.m_NextXMLWriter;
    }

    public void setNextXMLWriter(XMLWriter xMLWriter) {
        this.m_NextXMLWriter = xMLWriter;
    }

    public boolean isCompressed() {
        if (this.m_CanSegment) {
            return null != this.m_BytesSegments;
        }
        return 0 != this.m_CompressedBytes.length;
    }

    public void compressLast() {
        if (this.m_CanCompress) {
            this.compress(true);
        }
    }

    public int getStringLength() {
        return this.m_TotalLength;
    }

    public byte[][] getCompressedBytes() {
        if (this.isCompressed()) {
            if (this.m_CanSegment) {
                return this.m_BytesSegments.getBuffers();
            }
            return this.m_CompressedBytes;
        }
        throw new OlapiException("XML_NOTCOMPRESSED", "XML is not compressed");
    }

    public Vector getCompressedBytesSegLengths() {
        if (this.isCompressed()) {
            return this.m_BytesSegmentLengths;
        }
        throw new OlapiException("XML_NOTCOMPRESSED", "XML is not compressed");
    }

    public StringBuffer[] getSegmentedStrings() {
        if (!this.isCompressed()) {
            if (null == this.m_StringSegments) {
                this.m_StringSegments = new SegmentedStringWriter(true);
                this.m_StringSegments.write(this.getStringBuffer().toString());
            }
            return this.m_StringSegments.getBuffers();
        }
        throw new OlapiException("XML_NOTSEGMENTED", "XML is not segmented");
    }

    private void compress(boolean bl) {
        OlapiTracer.enter("XMLWriter.compress");
        OlapiTracer.log("compressLast = " + bl);
        try {
            int n;
            int n2;
            int n3;
            int n4;
            byte[] byArray = this.m_StringBuffer.toString().getBytes("UTF-8");
            if (OlapiTracer.isTracingEnabled()) {
                OlapiTracer.log("ucslen = " + this.m_StringBuffer.length() + ", utflen = " + byArray.length);
            }
            int n5 = 0;
            int n6 = byArray.length;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            Object object = null;
            if (this.m_CanSegment) {
                if (null == this.m_BytesSegments) {
                    this.m_BytesSegments = new SegmentedByteArrayOutputStream();
                }
                if (null == this.m_BytesSegmentLengths) {
                    this.m_BytesSegmentLengths = new Vector();
                }
            }
            if (0 != this.m_UtfLeftoverCount) {
                GZIPOutputStream gZIPOutputStream;
                n6 = Math.min(byArray.length, 31744 - this.m_UtfLeftoverCount);
                System.arraycopy(byArray, 0, this.m_UtfLeftover, this.m_UtfLeftoverCount, n6);
                if (this.m_CanSegment) {
                    n4 = this.m_BytesSegments.size();
                    gZIPOutputStream = new GZIPOutputStream(this.m_BytesSegments);
                    gZIPOutputStream.write(this.m_UtfLeftover, 0, this.m_UtfLeftoverCount + n6);
                    gZIPOutputStream.finish();
                    n3 = this.m_BytesSegments.size();
                    n2 = n3 - n4;
                    this.m_BytesSegmentLengths.add(new Integer(n2));
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                    gZIPOutputStream.write(this.m_UtfLeftover, 0, this.m_UtfLeftoverCount + n6);
                    gZIPOutputStream.close();
                    byArray2 = byteArrayOutputStream.toByteArray();
                    n2 = byArray2.length;
                }
                if (OlapiTracer.isTracingEnabled()) {
                    OlapiTracer.log("compress " + this.m_UtfLeftoverCount + " + " + n6 + " bytes into " + n2 + " bytes");
                }
                n5 = n6;
                n6 = byArray.length - n6;
            }
            n4 = n6 / 31744;
            if (!this.m_CanSegment) {
                object = new byte[n4][];
            }
            for (n = 0; n < n4; ++n) {
                GZIPOutputStream gZIPOutputStream;
                if (this.m_CanSegment) {
                    n3 = this.m_BytesSegments.size();
                    gZIPOutputStream = new GZIPOutputStream(this.m_BytesSegments);
                    gZIPOutputStream.write(byArray, n5 + n * 31744, 31744);
                    gZIPOutputStream.finish();
                    int n7 = this.m_BytesSegments.size();
                    n2 = n7 - n3;
                    this.m_BytesSegmentLengths.add(new Integer(n2));
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                    gZIPOutputStream.write(byArray, n5 + n * 31744, 31744);
                    gZIPOutputStream.close();
                    object[n] = byteArrayOutputStream.toByteArray();
                    n2 = object[n].length;
                }
                if (OlapiTracer.isTracingEnabled()) {
                    OlapiTracer.log("compress 31744 bytes into " + n2 + " bytes");
                }
                n6 -= 31744;
            }
            if (0 != n6) {
                if (!bl) {
                    System.arraycopy(byArray, n5 + n4 * 31744, this.m_UtfLeftover, 0, n6);
                    this.m_UtfLeftoverCount = n6;
                } else {
                    int n8;
                    GZIPOutputStream gZIPOutputStream;
                    if (this.m_CanSegment) {
                        n = this.m_BytesSegments.size();
                        gZIPOutputStream = new GZIPOutputStream(this.m_BytesSegments);
                        gZIPOutputStream.write(byArray, n5 + n4 * 31744, n6);
                        gZIPOutputStream.close();
                        n8 = this.m_BytesSegments.size();
                        n2 = n8 - n;
                        this.m_BytesSegmentLengths.add(new Integer(n2));
                    } else {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                        gZIPOutputStream.write(byArray, 0, n6);
                        for (n8 = byArray.length; n8 < 31744; ++n8) {
                            gZIPOutputStream.write(32);
                        }
                        gZIPOutputStream.close();
                        this.m_TotalLength += 31744 - byArray.length;
                        byArray3 = byteArrayOutputStream.toByteArray();
                        n2 = byArray3.length;
                    }
                    if (OlapiTracer.isTracingEnabled()) {
                        OlapiTracer.log("compress " + n6 + " bytes into " + n2 + " bytes");
                    }
                }
            }
            if (!this.m_CanSegment) {
                int n9 = this.m_CompressedBytes.length;
                byte[][] byArrayArray = new byte[n9 + n4 + (null == byArray2 ? 0 : 1) + (null == byArray3 ? 0 : 1)][];
                System.arraycopy(this.m_CompressedBytes, 0, byArrayArray, 0, n9);
                if (null != byArray2) {
                    byArrayArray[n9++] = byArray2;
                }
                for (int i = 0; i < n4; ++i) {
                    byArrayArray[n9++] = object[i];
                }
                if (null != byArray3) {
                    byArrayArray[n9++] = byArray3;
                }
                this.m_CompressedBytes = byArrayArray;
            }
            this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
            OlapiTracer.log("m_UtfLeftoverCount = " + this.m_UtfLeftoverCount);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("XMLWriter.compress");
    }

    public boolean doIndent() {
        return this.m_DoIndent;
    }

    public void setDoIndent(boolean bl) {
        this.m_DoIndent = bl;
    }

    public void writeXML(Writer writer) throws IOException {
        if (this.isCompressed()) {
            throw new UnsupportedOperationException("Writing compressed XML to generic Writer");
        }
        for (XMLWriter xMLWriter = this; null != xMLWriter; xMLWriter = xMLWriter.getNextXMLWriter()) {
            StringBuffer[] stringBufferArray = this.getSegmentedStrings();
            for (int i = 0; i < stringBufferArray.length; ++i) {
                writer.write(stringBufferArray[i].toString());
            }
        }
    }
}

