/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.aw;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.olapi.data.source.DataProvider;

public final class AWMetadataLookup {
    private DataProvider m_DataProvider = null;
    private Map m_LookupMap = new HashMap();
    private CallableStatement awObjectNameStmt = null;
    private CallableStatement awNameStmt = null;
    private Collection attachedAW = new ArrayList();
    private HashMap awViewMap = new HashMap();

    public AWMetadataLookup(DataProvider dataProvider) {
        try {
            this.m_DataProvider = dataProvider;
            OracleConnection oracleConnection = this.getDataProvider().getConnection();
            String string = "{ ? = call dbms_aw_utilities.get_aw_object_name(?, ?) }";
            this.awObjectNameStmt = oracleConnection.prepareCall(string);
            this.awObjectNameStmt.registerOutParameter(1, 1);
            string = "{ ? = call dbms_aw_utilities.get_workspace_name(?) }";
            this.awNameStmt = oracleConnection.prepareCall(string);
            this.awNameStmt.registerOutParameter(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void prepareForView(String string) {
        try {
            String string2 = (String)this.awViewMap.get(string);
            if (string2 == null) {
                this.awNameStmt.setString(2, string);
                this.awNameStmt.execute();
                string2 = this.awNameStmt.getString(1);
                if (string2 != null) {
                    this.awViewMap.put(string, string2);
                    this.attachAW(string2);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachAW(String string) {
        if (this.attachedAW.contains(string = AWMetadataLookup.removePrefix(string, '.'))) {
            return;
        }
        CallableStatement callableStatement = null;
        try {
            OracleConnection oracleConnection = this.getDataProvider().getConnection();
            callableStatement = oracleConnection.prepareCall("{ call dbms_aw.execute(?) }");
            String string2 = "__AWG.ATTACH('" + string + "')";
            callableStatement.setString(1, string2);
            callableStatement.execute();
            this.attachedAW.add(string);
            this.closeStatement(callableStatement);
        }
        catch (SQLException sQLException) {
            this.closeStatement(callableStatement);
        }
        catch (Throwable throwable) {
            this.closeStatement(callableStatement);
            throw throwable;
        }
    }

    protected DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    private Map getLookupMap() {
        return this.m_LookupMap;
    }

    public static String removePrefix(String string, char c) {
        int n = string.indexOf(c);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String lookupAWObjectName(String string, String string2) {
        string = AWMetadataLookup.removePrefix(string, '.');
        this.prepareForView(string);
        try {
            this.awObjectNameStmt.setString(2, string);
            this.awObjectNameStmt.setString(3, string2);
            this.awObjectNameStmt.execute();
            String string3 = this.awObjectNameStmt.getString(1);
            string3 = AWMetadataLookup.removePrefix(string3, '!');
            return string3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getAWObjectName(String string, String string2) {
        String string3 = string + " " + string2;
        String string4 = (String)this.getLookupMap().get(string3);
        if (null == string4) {
            string4 = this.lookupAWObjectName(string, string2);
            this.getLookupMap().put(string3, string4);
        }
        return string4;
    }
}

