/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizSource;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizTablespace;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.panels.ShuttlePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class TablespaceSelectShell
extends DpExpWizTablespace {
    private static final long serialVersionUID = 1L;

    @Override
    protected List<String> getSourceSelection() {
        if (!this._isPrivileged) {
            return new ArrayList<String>();
        }
        List list = (List)this.getListModel().getPropertyValue("IMP_OBJ_LIST");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map map : list) {
            arrayList.add((String)map.get("ORIGINAL_OBJECT_NAME"));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    protected boolean showUserOnly() {
        return false;
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1 && (this._dp.getSelected() == null || this._dp.getSelected().size() == 0)) {
            throw new TraversalException(DpWizardArb.getString("EXP_TABLESPACE_TEXT"), DpWizardArb.getString("EXP_TABLESPACE_TITLE"));
        }
        this._eo.setProperty("DP_KEY_BRANCH", (Object)"DP_TABLESPACE");
        this._eo.setProperty("DP_TABLESPACE_LIST", (Object)this._dp.getSelected());
        traversableContext.put("KEY_EXPORT_OBJECTS", (Object)this._eo);
        if (this._eo.getTablespaces() != null) {
            String[] stringArray = new String[]{};
            List list = this._dp.getSelected();
            if (list != null) {
                stringArray = list.toArray(new String[list.size()]);
            }
            if (DpWizCommon.compareStringList(this._eo.getTablespaces(), stringArray)) {
                traversableContext.put("EXTRACT_LIST_UPDATED", (Object)false);
            } else {
                traversableContext.put("EXTRACT_LIST_UPDATED", (Object)true);
            }
        } else {
            traversableContext.put("EXTRACT_LIST_UPDATED", (Object)false);
        }
        this.remove((Component)this._dp);
        this._storeMeta = (DpExpWizSource.MetadataEnum)((Object)this._eo.getPropertyValue("DP_KEY_STOREMETA"));
    }

    public ShuttlePanel getShuttlePanel() {
        return this._dp;
    }

    public void refreshUIPanel() {
        this.setLayout(new BorderLayout());
        this._isPrivileged = (Boolean)this._eo.getPropertyValue("DP_EXP_IS_PRIV");
        List<String> list = this.getSourceSelection();
        List<Object> list2 = new ArrayList();
        if (!this._isPrivileged) {
            list2 = list;
            list = new ArrayList<String>();
        } else {
            List list3;
            if (list.size() == 0) {
                MessageDialog.error((Component)((Object)this), (Object)DpWizardArb.getString("IMP_TABLESPACE_NOT_GOT_TEXT"), (String)DpWizardArb.getString("EXP_TABLESPACE_NOT_GOT_TITLE"), null);
            }
            if ((list3 = (List)this._eo.getPropertyValue("DP_TABLESPACE_LIST")) != null) {
                List<Object> list4 = list2;
                List<String> list5 = list;
                for (String string : list3) {
                    if (list4.contains(string)) continue;
                    list4.add(string);
                    if (!list5.contains(string)) continue;
                    list5.remove(string);
                }
                list2 = list4;
                list = list5;
            }
        }
        this._ddlType = this.doTables();
        this._dp.setLists(list, list2);
    }

    @Override
    protected void buildUIPanel() {
        this.setLayout(new BorderLayout());
        ExtractListModel extractListModel = (ExtractListModel)this._dataContext.get("KEY_EXPORT_OBJECTS");
        this._isPrivileged = (Boolean)extractListModel.getPropertyValue("DP_EXP_IS_PRIV");
        ArrayList arrayList = new ArrayList();
        List list = (List)this._eo.getPropertyValue("DP_TABLESPACE_LIST");
        this._ddlType = this.doTables();
        this._dp = new ShuttlePanel(arrayList, list);
        this._initialText.setText(StringUtils.stripMnemonic((String)UiResources.getString((String)"SELECT_TABLESPACE_DESC")));
        this._chkbxToSummary.setText(StringUtils.stripMnemonic((String)UiResources.getString((String)"GOTO_SUMMARY")));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._initialText, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.add(jPanel, "North");
        this.add(jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)this._sourceSchemaDesc, new GridBagConstraints(0, 0, 1, 1, 2.0, 0.0, 21, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this._selectedSchemaDesc, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 2, new Insets(6, 5, 0, 0), 0, 0));
        jPanel3.add((Component)this._dp.getPanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 1, new Insets(6, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel3.add((Component)jPanel4, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        jPanel4.setBorder(BorderFactory.createEmptyBorder());
        this.add(jPanel3, "Center");
        this.validate();
    }
}

