/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class OutputDirectoriesUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane _scrollPane;
    private JComboBox _localCombo = new JComboBox();
    private String[] _directories;
    private JTable _table;
    private DefaultTableModel _model = new DefaultTableModel();
    private ExtractListModel _listModel = null;

    public void setDirectories(String[] stringArray) {
        this._directories = stringArray;
    }

    public OutputDirectoriesUI() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void jbInit() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, DpWizardArb.getString("EXP_CHOOSE_OUTPUT_FILES"), 0, 0, null, null));
        this._scrollPane = new JScrollPane();
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        this._model.addColumn(DpWizardArb.getString("EXP_DIRECTORIES"));
        this._model.addColumn(DpWizardArb.getString("EXP_FILE_NAMES"));
        this._model.addColumn(DpWizardArb.getString("EXP_SIZE"));
        this._table = new JTable(this._model);
        this._table.setShowGrid(true);
        TableColumn tableColumn = null;
        for (int i = 0; i < 3; ++i) {
            tableColumn = this._table.getColumnModel().getColumn(i);
            if (i == 2) {
                tableColumn.setPreferredWidth(50);
                continue;
            }
            tableColumn.setPreferredWidth(100);
        }
        this._scrollPane.setViewportView(this._table);
        this._scrollPane.setPreferredSize(new Dimension(220, 120));
        JButton jButton = new JButton();
        jButton.setText(DpWizardArb.getString("EXP_ADD_ROW"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                for (String string : OutputDirectoriesUI.this._directories) {
                    if (!string.equals("DATA_DUMP_DIR")) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    OutputDirectoriesUI.this.addRow("DATA_DUMP_DIR", "EXPDAT%U.DMP", "");
                } else if (OutputDirectoriesUI.this._directories.length > 0) {
                    OutputDirectoriesUI.this.addRow(OutputDirectoriesUI.this._directories[0].toString(), "EXPDAT%U.DMP", "");
                }
                OutputDirectoriesUI.this._table.setRowSelectionInterval(OutputDirectoriesUI.this._table.getRowCount() - 1, OutputDirectoriesUI.this._table.getRowCount() - 1);
                OutputDirectoriesUI.this._table.setColumnSelectionInterval(0, 0);
                OutputDirectoriesUI.this.validate();
            }
        });
        this._table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                if (object != null) {
                    this.setToolTipText(object.toString());
                }
            }
        });
        this.add((Component)jButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        jButton2.setText(DpWizardArb.getString("EXP_REMOVE_ROW"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = OutputDirectoriesUI.this._table.getSelectedRow();
                int n2 = OutputDirectoriesUI.this._table.getSelectedColumn();
                while (n > -1 && n2 > -1) {
                    if (OutputDirectoriesUI.this._table.isEditing()) {
                        OutputDirectoriesUI.this._table.getCellEditor(n, n2).stopCellEditing();
                    }
                    OutputDirectoriesUI.this._model.removeRow(n);
                    n = OutputDirectoriesUI.this._table.getSelectedRow();
                }
            }
        });
        this.add((Component)jButton2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 120), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 4, 2, 1, 10.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addRow(String string, String string2, String string3) {
        this._model.addRow(new String[]{string, string2, string3});
        this._model.fireTableDataChanged();
        this._table.revalidate();
        if (this._model.getRowCount() < 3) {
            this._scrollPane.setViewportView(this._table);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        ArrayList arrayList = (ArrayList)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_OUTDIRFILESIZE", new ArrayList());
        boolean bl = false;
        if (arrayList.size() == 0) {
            for (String string : this._directories) {
                if (!string.equals("DATA_PUMP_DIR")) continue;
                bl = true;
                break;
            }
            if (bl) {
                arrayList.add(new String[]{"DATA_PUMP_DIR", "EXPDAT%U.DMP", ""});
            } else if (this._directories.length > 0) {
                arrayList.add(new String[]{this._directories[0].toString(), "EXPDAT%U.DMP", ""});
            }
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{DpWizardArb.getString("EXP_DIRECTORIES"), DpWizardArb.getString("EXP_FILE_NAMES"), DpWizardArb.getString("EXP_SIZE")}, 0);
        for (Object[] objectArray : arrayList) {
            defaultTableModel.addRow(objectArray);
        }
        if (defaultTableModel.getColumnName(0).equals(DpWizardArb.getString("EXP_DIRECTORIES"))) {
            int n;
            String[] stringArray = this._directories;
            this._localCombo.removeAllItems();
            for (String string : stringArray) {
                this._localCombo.addItem(string.toString());
            }
            this._model = defaultTableModel;
            this._table.setModel(this._model);
            Object object = null;
            for (n = 0; n < 3; ++n) {
                object = this._table.getColumnModel().getColumn(n);
                if (n == 2) {
                    ((TableColumn)object).setPreferredWidth(50);
                    continue;
                }
                ((TableColumn)object).setPreferredWidth(100);
            }
            this._table.updateUI();
            n = 0;
            TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
            tableColumn.setCellEditor(new DefaultCellEditor(this._localCombo));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this._table.getCellEditor() != null) {
            this._table.getCellEditor().stopCellEditing();
        }
        TableModel tableModel = this._table.getModel();
        int n = tableModel.getRowCount();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if ((String)tableModel.getValueAt(i, 0) == null || ((String)tableModel.getValueAt(i, 0)).equals("")) {
                n2 = i;
                break;
            }
            if ((String)tableModel.getValueAt(i, 1) == null || ((String)tableModel.getValueAt(i, 1)).equals("")) {
                n2 = i;
                break;
            }
            arrayList.add(new String[]{(String)tableModel.getValueAt(i, 0), (String)tableModel.getValueAt(i, 1), (String)tableModel.getValueAt(i, 2)});
        }
        if (traversableContext.getDirection() == 1) {
            if (n2 != -1) {
                throw new TraversalException(DpWizardArb.format("EXP_EMPTY_DIR_TEXT", n2 + 1), DpWizardArb.getString("EXP_EMPTY_DIR_TITLE"));
            }
            if (n == 0) {
                throw new TraversalException(DpWizardArb.getString("EXP_OUTPUT_INFO_TEXT"), DpWizardArb.getString("EXP_OUTPUT_INFO_LABEL"));
            }
        }
        this._listModel.setProperty("DP_EXP_OUTDIRFILESIZE", arrayList);
    }
}

