/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class IncludeExcludeUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane _scrollPane = new JScrollPane();
    private JTable _table;
    private DefaultTableModel _model = new DefaultTableModel();
    private ExtractListModel _listModel = null;
    private JCheckBox _toEnable = null;
    private JPanel _outerJp = null;
    private JRadioButton _include = null;
    private JRadioButton _exclude = null;
    private JButton _addRowButton = null;
    private JButton _removeRowButton = null;
    private JLabel _includeLabel = null;
    private JLabel _excludeLabel = null;
    private JLabel _message = new JLabel();
    private boolean _onEntryCalled = false;

    public IncludeExcludeUI() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this._toEnable = new JCheckBox();
        this._toEnable.setText(DpWizardArb.getString("EXP_ENABLE_INCLUDE_EXCLUDE_FILTER"));
        this._outerJp = new JPanel();
        this._outerJp.setLayout(new GridBagLayout());
        this._include = new JRadioButton();
        this._exclude = new JRadioButton();
        this._addRowButton = new JButton();
        this._removeRowButton = new JButton();
        this._includeLabel = new JLabel(DpWizardArb.getString("EXP_INCLUDE_LABEL"));
        this._excludeLabel = new JLabel(DpWizardArb.getString("EXP_EXCLUDE_LABEL"));
        this._toEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    IncludeExcludeUI.this.setLocalEnabled(true);
                } else {
                    IncludeExcludeUI.this.setLocalEnabled(false);
                }
            }
        });
        this.setLocalEnabled(false);
        this._outerJp.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this._include, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        jPanel.add((Component)this._includeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        jPanel.add((Component)this._exclude, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        jPanel.add((Component)this._excludeLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        buttonGroup.add(this._include);
        buttonGroup.add(this._exclude);
        this._outerJp.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        this._outerJp.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 4, 3, 5.0, 5.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        this._model.addColumn(DpWizardArb.getString("EXP_FILTER_TYPE"));
        this._model.addColumn(DpWizardArb.getString("EXP_VALUE"));
        this._table = new JTable(this._model);
        this._table.setShowGrid(true);
        this._scrollPane.setViewportView(this._table);
        this._scrollPane.setPreferredSize(new Dimension(400, 120));
        this._addRowButton.setText(DpWizardArb.getString("EXP_ADD_ROW"));
        this._addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IncludeExcludeUI.this.addRow(IncludeExcludeDatabaseFilterType.values()[0].toString(), "");
                IncludeExcludeUI.this._table.setRowSelectionInterval(IncludeExcludeUI.this._table.getRowCount() - 1, IncludeExcludeUI.this._table.getRowCount() - 1);
                IncludeExcludeUI.this._table.setColumnSelectionInterval(0, 0);
                IncludeExcludeUI.this._outerJp.validate();
            }
        });
        this._table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                if (object != null) {
                    this.setToolTipText(object.toString());
                }
            }
        });
        this._outerJp.add((Component)this._addRowButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        this._removeRowButton.setText(DpWizardArb.getString("EXP_REMOVE_ROW"));
        this._removeRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = IncludeExcludeUI.this._table.getSelectedRow();
                int n2 = IncludeExcludeUI.this._table.getSelectedColumn();
                while (n > -1 && n2 > -1) {
                    if (IncludeExcludeUI.this._table.isEditing()) {
                        IncludeExcludeUI.this._table.getCellEditor(n, n2).stopCellEditing();
                    }
                    IncludeExcludeUI.this._model.removeRow(n);
                    n = IncludeExcludeUI.this._table.getSelectedRow();
                }
                IncludeExcludeUI.this._outerJp.validate();
            }
        });
        this._outerJp.add((Component)this._removeRowButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._outerJp, new GridBagConstraints(0, 0, 1, 1, 0.7, 10.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        TitledPane titledPane = new TitledPane((Component)this._toEnable, (Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)titledPane, "Center");
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this._message, new GridBagConstraints(0, 1, 2, 1, 0.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 10.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setLocalEnabled(boolean bl) {
        if (bl && !this._toEnable.isSelected()) {
            return;
        }
        this._outerJp.setEnabled(bl);
        this._include.setEnabled(bl);
        this._includeLabel.setEnabled(bl);
        this._excludeLabel.setEnabled(bl);
        this._exclude.setEnabled(bl);
        this._addRowButton.setEnabled(bl);
        this._scrollPane.setEnabled(bl);
        this._removeRowButton.setEnabled(bl);
        if (this._table != null) {
            this._table.setEnabled(bl);
        }
    }

    public void setWaitingOff() {
        this._message.setText("");
    }

    public void setCheckBoxEnabled(boolean bl) {
        this._toEnable.setEnabled(bl);
        if (bl) {
            this._message.setText("");
        } else {
            this._message.setText(DpWizardArb.getString("IMP_WAITING3"));
        }
    }

    public void addRow(String string, String string2) {
        for (int i = 0; i < this._model.getRowCount(); ++i) {
            String string3 = (String)this._model.getValueAt(i, 0);
            if (string3 == null || string3.equals("") || !string3.equals(string)) continue;
            return;
        }
        this._model.addRow(new String[]{string, string2});
        this._model.fireTableDataChanged();
        this._table.revalidate();
        if (this._model.getRowCount() < 3) {
            this._scrollPane.setViewportView(this._table);
        }
    }

    public void onEntry(final TraversableContext traversableContext) {
        this._onEntryCalled = true;
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        ArrayList arrayList = (ArrayList)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_INCLUDE_EXCLUDE_DIR_FILE", new ArrayList());
        Boolean bl = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_INCLUDE_EXCLUDE_DIR_CHECKBOX", Boolean.FALSE);
        this._toEnable.setSelected(bl);
        this.setLocalEnabled(bl);
        Boolean bl2 = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_INCLUDE_SELECTED", Boolean.TRUE);
        if (bl2.booleanValue()) {
            this._include.setSelected(true);
        } else {
            this._exclude.setSelected(true);
        }
        final DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{DpWizardArb.getString("EXP_FILTER_TYPE"), DpWizardArb.getString("EXP_VALUE")}, 0);
        for (Object object2 : arrayList) {
            defaultTableModel.addRow((Object[])object2);
        }
        if (defaultTableModel.getColumnName(0).equals(DpWizardArb.getString("EXP_FILTER_TYPE"))) {
            Object object;
            Object object2;
            final JComboBox jComboBox = new JComboBox();
            object2 = (String)this._listModel.getPropertyValue("DP_KEY_BRANCH");
            String string = null;
            if (((String)object2).equals("DP_DATABASE") || ((String)object2).equals("IMP_FULL")) {
                string = "DATABASE";
                object = IncludeExcludeDatabaseFilterType.values();
                for (IncludeExcludeDatabaseFilterType includeExcludeDatabaseFilterType : object) {
                    jComboBox.addItem(includeExcludeDatabaseFilterType.toString());
                }
            } else if (((String)object2).equals("DP_SCHEMA")) {
                string = "SCHEMA";
                for (Enum enum_ : object = IncludeExcludeSchemaFilterType.values()) {
                    jComboBox.addItem(enum_.toString());
                }
            } else if (((String)object2).equals("DP_TABLE") || ((String)object2).equals("DP_TABLESPACE")) {
                string = "TABLE";
                for (Enum enum_ : object = IncludeExcludeTableFilterType.values()) {
                    jComboBox.addItem(enum_.toString());
                }
            }
            object = string;
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
            final DatabaseQueryTask databaseQueryTask = new DatabaseQueryTask<List<Map<String, ?>>>(DpWizardArb.getString("EXP_CALCULATE"), IRaptorTaskRunMode.MODAL, false, false, (String)object){
                final /* synthetic */ String val$tryViewFinal;
                {
                    this.val$tryViewFinal = string2;
                    super(string, iRaptorTaskRunMode, bl, bl2);
                }

                protected List<Map<String, ?>> doWork() throws TaskException {
                    List list = DBUtil.getInstance((Connection)((Connection)IncludeExcludeUI.this._listModel.getPropertyValue("KEY_CONN"))).executeReturnList("select distinct (trim(object_path)) object_path from " + this.val$tryViewFinal + "_EXPORT_OBJECTS where NAMED='Y' order by object_path", new HashMap());
                    return list;
                }

                public String getQuery() {
                    return DpWizardArb.getString("EXP_GET_INCLUDE_EXCLUDE_FILTER");
                }

                public String getConnectionName() {
                    return (String)IncludeExcludeUI.this._listModel.getPropertyValue("KEY_CNAME");
                }
            };
            RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    try {
                        try {
                            final List list = (List)databaseQueryTask.getResult();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Object object2;
                                    if (list != null && list.size() > 0) {
                                        jComboBox.removeAllItems();
                                        for (Object object2 : list) {
                                            jComboBox.addItem(object2.get("OBJECT_PATH"));
                                        }
                                    }
                                    IncludeExcludeUI.this._model = defaultTableModel;
                                    IncludeExcludeUI.this._table.setModel(IncludeExcludeUI.this._model);
                                    IncludeExcludeUI.this._table.updateUI();
                                    int n = 0;
                                    object2 = IncludeExcludeUI.this._table.getColumnModel().getColumn(n);
                                    ((TableColumn)object2).setCellEditor(new DefaultCellEditor(jComboBox));
                                    traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, interruptedException.getStackTrace()[0].toString(), interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, DpWizardArb.getString("IMP_TASK_FAILED"));
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, DpWizardArb.getString("CANCELLED"));
                }
            };
            databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
            RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        } else {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Boolean bl = Boolean.FALSE;
        if (this._toEnable.isSelected()) {
            bl = Boolean.TRUE;
        }
        if (!this._onEntryCalled) {
            return;
        }
        this._onEntryCalled = false;
        if (this._table.getCellEditor() != null) {
            this._table.getCellEditor().stopCellEditing();
        }
        TableModel tableModel = this._table.getModel();
        int n = tableModel.getRowCount();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if ((String)tableModel.getValueAt(i, 0) == null || ((String)tableModel.getValueAt(i, 0)).equals("")) {
                n2 = i;
                break;
            }
            if ((String)tableModel.getValueAt(i, 1) == null || ((String)tableModel.getValueAt(i, 1)).equals("")) {
                n2 = i;
                break;
            }
            arrayList.add(new String[]{(String)tableModel.getValueAt(i, 0), (String)tableModel.getValueAt(i, 1)});
        }
        if (traversableContext.getDirection() == 1 && n2 != -1 && bl.equals(Boolean.TRUE)) {
            throw new TraversalException(DpWizardArb.format("EXP_EMPTY_FILE_TEXT", n2 + 1), DpWizardArb.getString("EXP_EMPTY_FILE_TITLE"));
        }
        this._listModel.setProperty("DP_EXP_INCLUDE_EXCLUDE_DIR_FILE", arrayList);
        this._listModel.setProperty("DP_EXP_INCLUDE_EXCLUDE_DIR_CHECKBOX", (Object)bl);
        bl = Boolean.FALSE;
        if (this._include.isSelected()) {
            bl = Boolean.TRUE;
        }
        this._listModel.setProperty("DP_EXP_INCLUDE_SELECTED", (Object)bl);
    }

    static enum IncludeExcludeTableFilterType {
        NULL{

            public String toString() {
                return "";
            }
        }
        ,
        CONSTRAINT,
        INDEX,
        PROCDEPOBJ,
        REF_CONSTRAINT,
        TRIGGER;

    }

    static enum IncludeExcludeSchemaFilterType {
        NULL{

            public String toString() {
                return "";
            }
        }
        ,
        ALTER_FUNCTION,
        ALTER_PACKAGE_SPEC,
        ALTER_PROCEDURE,
        CLUSTER,
        CONSTRAINT,
        DB_LINK,
        DIMENSION,
        FUNCTION,
        INDEX,
        INDEXTYPE,
        JAVA_CLASS,
        JAVA_RESOURCE,
        JAVA_SOURCE,
        LIBRARY,
        MATERIALIZED_VIEW,
        MATERIALIZED_VIEW_LOG,
        OPERATOR,
        PACKAGE,
        PACKAGE_BODY,
        PACKAGE_SPEC,
        PROCDEPOBJ,
        PROCEDURE,
        PROCOBJ,
        REFRESH_GROUP,
        REF_CONSTRAINT,
        SEQUENCE,
        SYNONYM,
        TABLE,
        TRIGGER,
        TYPE,
        TYPE_BODY,
        TYPE_SPEC,
        USER,
        VIEW,
        XMLSCHEMA;

    }

    static enum IncludeExcludeDatabaseFilterType {
        NULL{

            public String toString() {
                return "";
            }
        }
        ,
        ALTER_FUNCTION,
        ALTER_PACKAGE_SPEC,
        ALTER_PROCEDURE,
        CLUSTER,
        CONSTRAINT,
        CONTEXT,
        DB_LINK,
        DIMENSION,
        DIRECTORY,
        DVPS_COMMAND_RULE,
        DVPS_FACTOR,
        DVPS_FACTOR_LINK,
        DVPS_FACTOR_TYPE,
        DVPS_IDENTITY,
        DVPS_IDENTITY_MAP,
        DVPS_REALM,
        DVPS_REALM_AUTHORIZATION,
        DVPS_REALM_MEMBERSHIP,
        DVPS_ROLE,
        DVPS_RULE,
        DVPS_RULE_SET,
        DVPS_RULE_SET_MEMBERSHIP,
        DVPS_STAGING_REALM_MEMBERSHIP,
        FUNCTION,
        INDEX,
        INDEXTYPE,
        JAVA_CLASS,
        JAVA_RESOURCE,
        JAVA_SOURCE,
        LIBRARY,
        MATERIALIZED_VIEW,
        MATERIALIZED_VIEW_LOG,
        OPERATOR,
        PACKAGE,
        PACKAGE_BODY,
        PACKAGE_SPEC,
        PROCDEPOBJ,
        PROCEDURE,
        PROCOBJ,
        PROFILE,
        REFRESH_GROUP,
        REF_CONSTRAINT,
        ROLE,
        ROLLBACK_SEGMENT,
        SEQUENCE,
        SYNONYM,
        TABLE,
        TABLESPACE,
        TRIGGER,
        TYPE,
        TYPE_BODY,
        TYPE_SPEC,
        USER,
        VIEW,
        XMLSCHEMA;

    }
}

