/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizScheduleOptions;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.log.LogPage;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.controls.ProgressPanel;
import oracle.javatools.db.DBException;

public class DpWizCommon {
    public static String getToUpperMaybe(String string) {
        if (string == null) {
            return " UPPER('') ";
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return " '" + string.substring(1, string.lastIndexOf("\"")).replace("'", "''") + "' ";
        }
        return " UPPER('" + string.replace("'", "''") + "') ";
    }

    public static String getNoToUpper(String string) {
        if (string == null) {
            return " '' ";
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return " '" + string.substring(1, string.lastIndexOf("\"")).replace("'", "''") + "' ";
        }
        return " '" + string.replace("'", "''") + "' ";
    }

    public static boolean compareStringList(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            arrayList2.add(stringArray2[n]);
        }
        return arrayList.removeAll(arrayList2);
    }

    public static Object getOrInitializeList(ExtractListModel extractListModel, String string, Object object) {
        if (extractListModel.getPropertyValue(string) == null) {
            extractListModel.setProperty(string, object);
        }
        return extractListModel.getPropertyValue(string);
    }

    public static String[] getDirectories(TraversableContext traversableContext) {
        ExtractListModel extractListModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        return (String[])DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_DIRECTORIES", new String[0]);
    }

    public static String doProgressBar(DefaultTraversablePanel defaultTraversablePanel, ProgressBarRunnable progressBarRunnable, String string) throws TraversalException {
        ProgressBar progressBar = new ProgressBar((Component)defaultTraversablePanel, string, (Runnable)progressBarRunnable, true);
        progressBarRunnable.setProgressBar(progressBar);
        progressBarRunnable.run();
        if (progressBarRunnable.getTraversalException() != null) {
            throw progressBarRunnable.getTraversalException();
        }
        return progressBarRunnable.getRetVal();
    }

    public static String doProgressBarLive(DefaultTraversablePanel defaultTraversablePanel, ProgressBarRunnableLive progressBarRunnableLive, String string) throws TraversalException {
        ProgressBar progressBar = new ProgressBar((Component)defaultTraversablePanel, string, (Runnable)progressBarRunnableLive, true);
        progressBarRunnableLive.setProgressBar(progressBar);
        progressBar.setCancelable(false);
        progressBar.start(string, DpWizardArb.getString("PROCESSING"), 0, 0);
        progressBar.waitUntilDone();
        if (progressBarRunnableLive.getTraversalException() != null) {
            throw progressBarRunnableLive.getTraversalException();
        }
        if (progressBar.hasUserCancelled()) {
            throw new TraversalException(DpWizardArb.getString("USER_HAS_CANCELLED"), DpWizardArb.getString("CANCELLED"));
        }
        return progressBarRunnableLive.getRetVal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupConnection(ExtractListModel extractListModel, boolean bl) throws TraversalException {
        String string = (String)extractListModel.getPropertyValue("KEY_CNAME");
        try {
            Connections.getInstance().getConnection(string);
        }
        catch (Exception exception) {
            Throwable throwable;
            Exception exception2;
            while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                exception2 = (Exception)throwable;
            }
            throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", exception2.getLocalizedMessage()), DpWizardArb.getString("IMP_EXCEPTION_OCCURRED"));
        }
        if (Connections.getInstance().lock(string)) {
            try {
                Object object6;
                Object object22;
                Object object32;
                Object object42;
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (DBException dBException) {
                    throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", dBException.getLocalizedMessage()), DpWizardArb.getString("IMP_EXCEPTION_OCCURRED"));
                }
                extractListModel.setProperty("KEY_CONN", (Object)connection);
                List list = DBUtil.getInstance((String)string).executeReturnList("select username from user_role_privs where GRANTED_ROLE = 'DBA' OR GRANTED_ROLE = 'IMP_FULL_DATABASE' AND USERNAME = USER", null);
                Boolean bl2 = Boolean.FALSE;
                for (Object object42 : list) {
                    bl2 = Boolean.TRUE;
                }
                if (bl2.equals(Boolean.FALSE)) {
                    throw new TraversalException(DpWizardArb.getString("EXP_DBA_REQUIRED"), DpWizardArb.getString("EXP_PRIV_ERROR"));
                }
                extractListModel.setProperty("KEY_CONN", (Object)connection);
                DBUtil dBUtil = DBUtil.getInstance((String)string);
                object42 = "select DIRECTORY_NAME name from all_directories order by name";
                ArrayList<String> arrayList = new ArrayList<String>();
                List list2 = dBUtil.executeReturnList((String)object42, null);
                for (Object object32 : list2) {
                    arrayList.add((String)object32.get("NAME"));
                }
                Object[] objectArray = arrayList.toArray(new String[list2.size()]);
                Arrays.sort(objectArray);
                extractListModel.setProperty("DP_EXP_DIRECTORIES", (Object)objectArray);
                if (objectArray.length == 0) {
                    throw new TraversalException(DpWizardArb.getString("EXP_NO_DIRECTORIES"), DpWizardArb.getString("EXP_PRIV_ERROR"));
                }
                object32 = null;
                ResultSet resultSet = null;
                Timestamp timestamp = null;
                try {
                    connection = (Connection)extractListModel.getPropertyValue("KEY_CONN");
                    object32 = connection.prepareStatement("select current_timestamp from dual");
                    resultSet = object32.executeQuery();
                    resultSet.next();
                    timestamp = resultSet.getTimestamp(1);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger("DpWizCommon").log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (object32 != null) {
                        try {
                            object32.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                if (timestamp == null) {
                    extractListModel.setProperty("DP_EXP_SYSDATE", (Object)new Date());
                } else {
                    extractListModel.setProperty("DP_EXP_SYSDATE", (Object)new Date(timestamp.getTime()));
                }
                connection = (Connection)extractListModel.getPropertyValue("KEY_CONN");
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Statement statement = null;
                resultSet = null;
                if (bl) {
                    try {
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery("select name from sys.ku_noexp_tab where obj_type='SCHEMA'");
                        while (resultSet.next()) {
                            arrayList2.add(resultSet.getString(1));
                        }
                    }
                    catch (SQLException sQLException) {
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
                extractListModel.setProperty("DP_EXP_NO_EXPORT_LIST", arrayList2);
                Boolean bl3 = Boolean.FALSE;
                List list3 = DBUtil.getInstance((String)string).executeReturnList("select USER NAME from dual where USER = 'SYS'", null);
                for (Object object22 : list3) {
                    bl3 = Boolean.TRUE;
                }
                extractListModel.setProperty("DP_EXP_IS_SYS", (Object)bl3);
                object42 = null;
                object42 = bl ? "select username from user_role_privs where GRANTED_ROLE = 'DBA' OR GRANTED_ROLE = 'EXP_FULL_DATABASE' AND USERNAME = USER" : "select username from user_role_privs where GRANTED_ROLE = 'DBA' OR GRANTED_ROLE = 'IMP_FULL_DATABASE' AND USERNAME = USER";
                list3 = DBUtil.getInstance((String)string).executeReturnList((String)object42, null);
                Object object5 = Boolean.FALSE;
                for (Object object6 : list3) {
                    object5 = Boolean.TRUE;
                }
                extractListModel.setProperty("DP_EXP_IS_PRIV", object5);
                if (bl) {
                    extractListModel.setProperty("DP_EXP_GEN_NAME", (Object)DBUtil.getInstance((String)string).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('EXPORT_JOB_SQLDEV_') from dual", new HashMap()));
                } else {
                    extractListModel.setProperty("DP_EXP_GEN_NAME", (Object)DBUtil.getInstance((String)string).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('IMPORT_JOB_SQLDEV_') from dual", new HashMap()));
                }
                object32 = null;
                resultSet = null;
                object22 = "";
                try {
                    object32 = connection.prepareStatement("select to_char(current_scn,'99999999999999999999999999999999999999') from v$database");
                    resultSet = object32.executeQuery();
                    resultSet.next();
                    object22 = resultSet.getString(1).replaceFirst("^\\s+", "");
                }
                catch (SQLException sQLException) {
                    object22 = DpWizardArb.getString("EXP_NOT_PRIVILEGED");
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (object32 != null) {
                        try {
                            object32.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                extractListModel.setProperty("EXP_SCN_ON_ENTRY", object22);
                dBUtil = DBUtil.getInstance((String)string);
                extractListModel.setProperty("EXP_ALL_USERS", (Object)dBUtil.executeReturnList("select username from all_users order by username", null));
                extractListModel.setProperty("EXP_THIS_USER", (Object)dBUtil.executeReturnList("select user USERNAME from dual", null));
                extractListModel.setProperty("EXP_ALL_TABLESPACES", (Object)dBUtil.executeReturnList("select name from v$tablespace order by name", null));
                extractListModel.setProperty("EXP_NO_TABLESPACES", (Object)dBUtil.executeReturnList("select 'name' NAME from dual where 1=2", null));
                object6 = Boolean.TRUE;
                Statement statement2 = null;
                try {
                    statement2 = connection.createStatement();
                    statement2.execute("begin\nnull;\nEXCEPTION WHEN UTL_FILE.invalid_operation then null;\nend;");
                    statement2.close();
                }
                catch (SQLException sQLException) {
                    if (statement2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                    }
                    object6 = Boolean.FALSE;
                }
                extractListModel.setProperty("EXP_UTL_FILE", object6);
                extractListModel.setProperty("EXP_VERSION", (Object)RaptorVersionTracker.getDbVersion((Connection)connection));
            }
            finally {
                Connections.getInstance().unlock(string);
            }
        }
    }

    public static String utilDateToString(ExtractListModel extractListModel, OraTIMESTAMPTZ oraTIMESTAMPTZ) {
        String string = "";
        try {
            OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = new OraTIMESTAMPTZFormat("YYYY-MM-DD hh24:mi:ss TZR", OraLocaleInfo.getInstance((Locale)Locale.US));
            string = oraTIMESTAMPTZFormat.format(oraTIMESTAMPTZ.getDatum());
        }
        catch (Exception exception) {
            Logger.getLogger("DpExpWizSummary").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public static String scheduleCommon(ExtractListModel extractListModel, String string, String string2, String string3) throws TraversalException {
        String string4;
        ExtractListModel extractListModel2 = extractListModel;
        String string5 = string2;
        String string6 = string3;
        String string7 = string;
        if (Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_RBIMMEDIATE", Boolean.TRUE).equals(Boolean.TRUE)).booleanValue()) {
            return string7 + string6;
        }
        String string8 = null;
        string8 = Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_RBINDEFINATE", Boolean.TRUE).equals(Boolean.TRUE)) == false && !((Integer)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_MONTHLY_YEARLY", new Integer(1))).equals(new Integer(1)) ? "                        end_date => TO_TIMESTAMP_TZ('" + DpWizCommon.utilDateToString(extractListModel2, (OraTIMESTAMPTZ)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_REPEAT_UNTIL", DpExpWizScheduleOptions.getSysTIMESTAMPTZ(extractListModel2))) + "','YYYY-MM-DD hh24:mi:ss TZR'),\n" : "";
        String string9 = "";
        Integer n = (Integer)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_MONTHLY_YEARLY", new Integer(1));
        String string10 = "";
        if (n == 2) {
            string4 = (String)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_FREQUENCY", new String(""));
            Integer n2 = (Integer)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_FREQCOMBO", new Integer(0));
            string10 = "";
            if (n2 == 0) {
                string10 = "MINUTELY";
            } else if (n2 == 1) {
                string10 = "HOURLY";
            } else if (n2 == 2) {
                string10 = "DAILY";
            } else if (n2 == 3) {
                string10 = "WEEKLY";
            }
            if (!string4.equals("")) {
                string9 = "                        repeat_interval => 'FREQ=" + string10 + "; INTERVAL=" + string4 + "',\n";
            }
        } else if (n == 3) {
            string10 = "MONTHLY";
            string9 = "                        repeat_interval => 'FREQ=" + string10 + "',\n";
        } else if (n == 4) {
            string10 = "YEARLY";
            string9 = "                        repeat_interval => 'FREQ=" + string10 + "',\n";
        }
        string4 = (String)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_JNAME", "");
        string4 = string4.equals("") ? "DBMS_SCHEDULER.GENERATE_JOB_NAME()" : "'SCH_" + string4.replace("'", "''") + "'";
        string7 = "BEGIN \n    SYS.DBMS_SCHEDULER.CREATE_JOB (                        job_name => USER||'.'||" + string4 + ",\n                        job_type => 'PLSQL_BLOCK',\n                        job_action => '" + DpWizCommon.tryToReduce((string + string5).replace("'", "''")) + "',\n                        number_of_arguments => 0,\n                        start_date => TO_TIMESTAMP_TZ('" + DpWizCommon.utilDateToString(extractListModel2, (OraTIMESTAMPTZ)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_CALFROM", DpExpWizScheduleOptions.getSysTIMESTAMPTZ(extractListModel2))) + "','YYYY-MM-DD hh24:mi:ss TZR'),\n" + string9 + string8 + "                        job_class => 'DEFAULT_JOB_CLASS',\n                        enabled => true,\n                        auto_drop => true,\n                        comments => '" + ((String)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_JDESCRIPTION", "")).replace("'", "''") + "');\nEND;\n/\n";
        return string7;
    }

    public static String tryToReduce(String string) throws TraversalException {
        String string2 = string.replaceAll("[\\r \\t]*\\n[\\r\\n \\t]*", "\n").replaceAll("\\r", "");
        if (string2.length() > 4000) {
            throw new TraversalException(DpWizardArb.getString("EXP_JOB_OVER_4000_TEXT"), DpWizardArb.getString("EXP_JOB_OVER_4000"));
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onExitRun(ExtractListModel extractListModel, String string, boolean bl) throws TraversalException {
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.setScanOn(false);
            WrapListenBufferOutputStream wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream, null);
            wrapListenBufferOutputStream.setRemoveForcePrint(true);
            scriptRunnerContext.setOutputStreamWrapper((BufferedOutputStream)wrapListenBufferOutputStream);
            scriptRunnerContext.consumerRuning(true);
            scriptRunnerContext.setEscape(false);
            scriptRunnerContext.setSqlError(4);
            scriptRunnerContext.consumerRuning(true);
            OutputRedirectorToStringBuffer outputRedirectorToStringBuffer = new OutputRedirectorToStringBuffer(pipedInputStream, new StringBuffer(), null);
            outputRedirectorToStringBuffer.start();
            ScriptExecutor scriptExecutor = new ScriptExecutor(string, (Connection)extractListModel.getPropertyValue("KEY_CONN"));
            scriptExecutor.setOut((BufferedOutputStream)wrapListenBufferOutputStream);
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            scriptExecutor.setConn((Connection)extractListModel.getPropertyValue("KEY_CONN"));
            scriptExecutor.setStmt(string);
            boolean bl2 = Connections.getInstance().lock((Connection)extractListModel.getPropertyValue("KEY_CONN"));
            if (bl2) {
                try {
                    scriptExecutor.run();
                }
                catch (Exception exception) {
                    Logger.getLogger(DpWizCommon.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    Connections.getInstance().unlock((Connection)extractListModel.getPropertyValue("KEY_CONN"));
                }
            }
            try {
                if (wrapListenBufferOutputStream != null) {
                    wrapListenBufferOutputStream.flush();
                    wrapListenBufferOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            outputRedirectorToStringBuffer.join();
            if (scriptRunnerContext.getExited()) {
                StringBuffer stringBuffer = outputRedirectorToStringBuffer.getStringBuffer();
                String string2 = "Error";
                if (stringBuffer != null) {
                    string2 = stringBuffer.toString();
                }
                int n = string2.lastIndexOf("REMOVE FINAL TRACE TEXT\r");
                int n2 = string2.lastIndexOf("REMOVE FINAL TRACE TEXT\n");
                if (n2 > n) {
                    n = n2;
                }
                if (n != -1 && n > 2) {
                    string2 = string2.substring(0, n);
                }
                n = string2.lastIndexOf("REMOVE TO START TRACE TEXT\r");
                n2 = string2.lastIndexOf("REMOVE TO START TRACE TEXT\n");
                if (n2 > n) {
                    n = n2;
                }
                if (n != -1 && !string2.endsWith("REMOVE TO START TRACE TEXT")) {
                    string2 = string2.substring(n + "REMOVE TO START TRACE TEXT".length());
                }
                if (string2.length() > 620) {
                    string2 = "...\n" + string2.substring(string2.length() - 619);
                }
                String string3 = null;
                string3 = bl ? DBUtil.getInstance((Connection)((Connection)extractListModel.getPropertyValue("KEY_CONN"))).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('EXPORT_JOB_SQLDEV_') from dual", new HashMap()) : DBUtil.getInstance((Connection)((Connection)extractListModel.getPropertyValue("KEY_CONN"))).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('IMPORT_JOB_SQLDEV_') from dual", new HashMap());
                extractListModel.setProperty("DP_EXP_JNAME", (Object)string3);
                throw new TraversalException(string2, DpWizardArb.getString("EXP_ERROR_SUMIT"));
            }
        }
        catch (Exception exception) {
            if (exception instanceof TraversalException) {
                throw (TraversalException)exception;
            }
            Logger.getLogger(DpWizCommon.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private static class OutputRedirectorToStringBuffer
    extends Thread {
        private Logger logger = Logger.getLogger(OutputRedirectorToStringBuffer.class.getName());
        private PipedInputStream _in;
        private StringBuffer _text;
        private String _line = "";
        private BufferedReader _reader;
        private final int DISPLAY_NUMBER_OF_LINES = 50;
        private StringBuffer _editor;
        private LogPage _logPage;
        private ProgressPanel _progress;
        private Exception stopRunning;
        private boolean doStop = false;
        public static final String OUTPUTREADER_ENCODING = "UTF-8";

        public OutputRedirectorToStringBuffer(PipedInputStream pipedInputStream, LogPage logPage) {
            this(pipedInputStream, null, null, logPage);
        }

        public OutputRedirectorToStringBuffer(PipedInputStream pipedInputStream, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            this(pipedInputStream, stringBuffer, stringBuffer2, null);
        }

        public OutputRedirectorToStringBuffer(PipedInputStream pipedInputStream, StringBuffer stringBuffer, StringBuffer stringBuffer2, LogPage logPage) {
            this._in = pipedInputStream;
            this._text = stringBuffer;
            this._editor = stringBuffer2;
            this._logPage = logPage;
            try {
                this._reader = new BufferedReader(new InputStreamReader((InputStream)this._in, OUTPUTREADER_ENCODING));
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            try {
                while (this._line != null) {
                    for (int i = 0; i <= 50 && !bl; ++i) {
                        if (this.doStop) {
                            throw this.stopRunning;
                        }
                        this._line = this._reader.readLine();
                        if (this._line == null) break;
                        if (this._line.trim().equals("force_print")) {
                            this._line = "";
                            bl = true;
                        }
                        if (bl) continue;
                        stringBuffer.append(this._line + "\n");
                    }
                    if (this._text != null) {
                        this._text.append(stringBuffer.toString());
                    }
                    if (!(this._logPage == null || bl && stringBuffer.length() <= 0)) {
                        this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                    }
                    stringBuffer = null;
                    stringBuffer = new StringBuffer();
                    this.moveToLastRow();
                    bl = false;
                }
            }
            catch (Exception exception) {
                this.logger.info("Output Pipe finished");
            }
            finally {
                if (this._text != null) {
                    this._text.append(stringBuffer.toString());
                }
                if (this._logPage != null) {
                    this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                }
                this.moveToLastRow();
            }
        }

        public void moveToLastRow() {
        }

        public void setProgressPanel(ProgressPanel progressPanel) {
            this._progress = progressPanel;
        }

        public void setLogPage(LogPage logPage) {
            this._logPage = logPage;
        }

        public void stopRun() {
            this.doStop = true;
        }

        public StringBuffer getStringBuffer() {
            return this._text;
        }
    }

    public static abstract class ProgressBarRunnableLive
    extends ProgressBarRunnable {
        private ProgressBar _pb = null;

        @Override
        public abstract void run();

        @Override
        public void setProgressBar(ProgressBar progressBar) {
            this._pb = progressBar;
        }

        @Override
        public void setDoneStatus() {
            this._pb.setDoneStatus();
        }
    }

    public static abstract class ProgressBarRunnable
    implements Runnable {
        protected String _retVal = null;
        protected TraversalException _te = null;

        @Override
        public abstract void run();

        public void setProgressBar(ProgressBar progressBar) {
        }

        public void setDoneStatus() {
        }

        public String getRetVal() {
            return this._retVal;
        }

        public void setRetVal(String string) {
            this._retVal = string;
        }

        public void setTraversalException(TraversalException traversalException) {
            this._te = traversalException;
        }

        public TraversalException getTraversalException() {
            return this._te;
        }
    }
}

