/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.shardconsole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableListValue;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.dataobject.MarkerValues;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractGridViewMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

public class ShardMonitor
extends AbstractGridViewMonitor {
    private final ObjectProperty<PanelFactory<Region>> shardPanelFactoryProperty = new SimpleObjectProperty((Object)this, "shardPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> groupPanelFactoryProperty = new SimpleObjectProperty((Object)this, "groupPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> spacePanelFactoryProperty = new SimpleObjectProperty((Object)this, "spacePanelFactory");
    private final ObjectProperty<PanelFactory<Region>> regionPanelFactoryProperty = new SimpleObjectProperty((Object)this, "regionPanelFactory");
    private GridPane[][] cellPanels;

    public PanelFactory<Region> getShardPanelFactory() {
        return (PanelFactory)this.shardPanelFactoryProperty.get();
    }

    public void setShardPanelFactory(PanelFactory<Region> panelFactory) {
        this.shardPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> shardPanelFactoryProperty() {
        return this.shardPanelFactoryProperty;
    }

    public PanelFactory<Region> getGroupPanelFactory() {
        return (PanelFactory)this.groupPanelFactoryProperty.get();
    }

    public void setGroupPanelFactory(PanelFactory<Region> panelFactory) {
        this.groupPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> groupPanelFactoryProperty() {
        return this.groupPanelFactoryProperty;
    }

    public PanelFactory<Region> getSpacePanelFactory() {
        return (PanelFactory)this.spacePanelFactoryProperty.get();
    }

    public void setSpacePanelFactory(PanelFactory<Region> panelFactory) {
        this.spacePanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> spacePanelFactoryProperty() {
        return this.spacePanelFactoryProperty;
    }

    public PanelFactory<Region> getRegionPanelFactory() {
        return (PanelFactory)this.regionPanelFactoryProperty.get();
    }

    public void setRegionPanelFactory(PanelFactory<Region> panelFactory) {
        this.regionPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> regionPanelFactoryProperty() {
        return this.regionPanelFactoryProperty;
    }

    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        consumer.accept(Collections.singletonList(this.getShardPanelFactory()));
        consumer.accept(Collections.singletonList(this.getGroupPanelFactory()));
        consumer.accept(Collections.singletonList(this.getSpacePanelFactory()));
        consumer.accept(Collections.singletonList(this.getRegionPanelFactory()));
    }

    protected void onStart(Context context) {
        this.getItem().getUpdating().addListener((observableValue, bl, bl2) -> {
            if (!bl2.booleanValue()) {
                this.update();
            }
        });
    }

    protected Node createCellPanel(int n, int n2) {
        return this.cellPanels[n][n2];
    }

    private void update() {
        Object object;
        Node node;
        Object object2;
        DXRow dXRow2;
        Object object32;
        ArrayList[][] arrayListArray2;
        ObservableListValue observableListValue = this.getItem().getObservable();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        TreeMap<PanelFactory<Region>, Integer> treeMap2 = new TreeMap<PanelFactory<Region>, Integer>();
        for (Object object4 : observableListValue) {
            arrayListArray2 = (String)object4.get("Region", String.class).get();
            treeMap.put((String)arrayListArray2, (Integer)null);
            object32 = (PanelFactory<Region>)object4.get("Space", String.class).get();
            treeMap2.put((PanelFactory<Region>)object32, (Integer)null);
        }
        this.getColumns().clear();
        int n = 0;
        for (ArrayList[][] arrayListArray2 : treeMap.keySet()) {
            treeMap.put((String)arrayListArray2, n++);
            object32 = this.getRegionPanelFactory();
            dXRow2 = new MarkerValues(Collections.singletonMap("Region", arrayListArray2));
            object2 = object32.createPanel((MarkerValues)dXRow2);
            object2.start();
            node = object2.getPanel();
            this.getColumns().add(node);
        }
        this.getRows().clear();
        int n2 = 0;
        for (Object object32 : treeMap2.keySet()) {
            treeMap2.put((PanelFactory<Region>)object32, n2++);
            dXRow2 = this.getSpacePanelFactory();
            object2 = new MarkerValues(Collections.singletonMap("Space", object32));
            node = dXRow2.createPanel((MarkerValues)object2);
            node.start();
            object = node.getPanel();
            this.getRows().add(object);
        }
        arrayListArray2 = new ArrayList[treeMap.size()][treeMap2.size()];
        for (DXRow dXRow2 : observableListValue) {
            int n3;
            object2 = (String)dXRow2.get("Region", String.class).get();
            int n4 = (Integer)treeMap.get(object2);
            ArrayList<DXRow> arrayList = arrayListArray2[n4][n3 = ((Integer)treeMap2.get(object = (String)dXRow2.get("Space", String.class).get())).intValue()];
            if (arrayList == null) {
                arrayListArray2[n4][n3] = arrayList = new ArrayList<DXRow>();
            }
            arrayList.add(dXRow2);
        }
        this.cellPanels = new GridPane[treeMap.size()][treeMap2.size()];
        for (int i = 0; i < treeMap.size(); ++i) {
            for (int j = 0; j < treeMap2.size(); ++j) {
                this.cellPanels[i][j] = this.initCellPanel(arrayListArray2[i][j]);
            }
        }
    }

    private GridPane initCellPanel(List<DXRow> list) {
        SortedMap<String, Object> sortedMap;
        TreeMap<String, DXRow> treeMap = new TreeMap<String, DXRow>();
        TreeMap<Object, TreeMap<String, DXRow>> treeMap2 = new TreeMap<Object, TreeMap<String, DXRow>>();
        for (DXRow dXRow : list) {
            String string = (String)dXRow.get("Group", String.class).get();
            String string2 = (String)dXRow.get("Shard", String.class).get();
            if (string == null) {
                sortedMap = treeMap;
            } else {
                sortedMap = (SortedMap)treeMap2.get(string);
                if (sortedMap == null) {
                    sortedMap = new TreeMap();
                    treeMap2.put(string, (TreeMap<String, DXRow>)sortedMap);
                }
            }
            sortedMap.put(string2, dXRow);
        }
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"group-shard-grid");
        int n = 0;
        if (!treeMap.isEmpty()) {
            this.addGroupRow(gridPane, n, null, treeMap);
            ++n;
        }
        for (String string2 : treeMap2.keySet()) {
            sortedMap = (SortedMap)treeMap2.get(string2);
            this.addGroupRow(gridPane, n, string2, sortedMap);
            ++n;
        }
        return gridPane;
    }

    private void addGroupRow(GridPane gridPane, int n, String string, SortedMap<String, DXRow> sortedMap) {
        Object object;
        PanelFactory.Instance instance;
        int n2 = 0;
        if (string != null) {
            PanelFactory<Region> panelFactory = this.getGroupPanelFactory();
            MarkerValues object2 = new MarkerValues(Collections.singletonMap("Group", string));
            instance = panelFactory.createPanel(object2);
            instance.start();
            object = (Region)instance.getPanel();
            gridPane.add((Node)object, 0, n);
            ++n2;
        }
        for (String string2 : sortedMap.keySet()) {
            instance = (DXRow)sortedMap.get(string2);
            object = (String)instance.get("Role", String.class).get();
            long l = (Long)instance.get("ReplicaSet", Long.class).get();
            String string3 = (String)instance.get("ConnectString", String.class).get();
            long l2 = (Long)instance.get("ChunkCount", Long.class).get();
            PanelFactory<Region> panelFactory = this.getShardPanelFactory();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("Shard", string2);
            hashMap.put("Role", object);
            hashMap.put("ReplicaSet", l);
            hashMap.put("ConnectString", string3);
            hashMap.put("ChunkCount", l2);
            MarkerValues markerValues = new MarkerValues(hashMap);
            PanelFactory.Instance instance2 = panelFactory.createPanel(markerValues);
            instance2.start();
            Region region = (Region)instance2.getPanel();
            gridPane.add((Node)region, n2++, n);
        }
    }
}

