/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.AbstractNode;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NodeEnviron;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NodeType;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.NodeValue;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.RootNode;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;

@DefaultProperty(value="nodes")
public class TreeViewMonitor
extends AbstractMonitorObject {
    private final RootNode rootNode = new RootNode();
    private final ObservableList<NodeType> types = FXCollections.observableArrayList();
    private TreeView<NodeValue> treeView;
    private List<DataObject> dataObjects;

    public ObservableList<AbstractNode> getNodes() {
        return this.rootNode.getChildren();
    }

    public ObservableList<NodeType> getTypes() {
        return this.types;
    }

    protected Class<? extends Node> getBindToClass() {
        return TreeView.class;
    }

    protected List<DataObject> getDataObjects(Context context) {
        return this.dataObjects;
    }

    protected void onInit(Context context) {
        NodeEnviron nodeEnviron = new NodeEnviron(context, (List<NodeType>)this.types);
        for (NodeType nodeType : this.types) {
            nodeType.getNode().setEnviron(nodeEnviron);
        }
        this.rootNode.setEnviron(nodeEnviron);
        this.treeView = (TreeView)context.getContainer(TreeView.class);
        this.treeView.setShowRoot(false);
        Object object = this.rootNode.getRootItem();
        this.treeView.setRoot((TreeItem)object);
        this.dataObjects = ((NodeValue)object.getValue()).getDataObjects();
    }

    protected void onStop(Context context) {
        TreeItem treeItem = this.treeView.getRoot();
        ((NodeValue)treeItem.getValue()).stop((List<TreeItem<NodeValue>>)treeItem.getChildren());
    }
}

