/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Consumer;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ScaleTransition;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableListValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.panel.GridBackground;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.ListDataObject;
import oracle.dbtools.raptor.metrics.dataobject.MarkerValues;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

@DefaultProperty(value="item")
public class GridMonitor
extends AbstractMonitorObject {
    private final ObjectProperty<ListDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final StringProperty xColumnProperty = new SimpleStringProperty((Object)this, "xColumn");
    private final StringProperty yColumnProperty = new SimpleStringProperty((Object)this, "yColumn");
    private final ObjectProperty<PanelFactory> cellFactoryProperty = new SimpleObjectProperty((Object)this, "cellFactory");
    private final ObjectProperty<PanelFactory> rowLabelFactoryProperty = new SimpleObjectProperty((Object)this, "rowLabelFactory");
    private final ObjectProperty<PanelFactory> columnLabelFactoryProperty = new SimpleObjectProperty((Object)this, "columnLabelFactory");
    private final ObservableList<GridBackground> gridBackgrounds = FXCollections.observableArrayList();
    private ChangeListener<Boolean> listener;

    public ListDataObject getItem() {
        return (ListDataObject)this.itemProperty.get();
    }

    public void setItem(ListDataObject listDataObject) {
        this.itemProperty.set((Object)listDataObject);
    }

    public ObjectProperty<ListDataObject> itemProperty() {
        return this.itemProperty;
    }

    public String getXColumn() {
        return (String)this.xColumnProperty.get();
    }

    public void setXColumn(String string) {
        this.xColumnProperty.set((Object)string);
    }

    public StringProperty xColumnProperty() {
        return this.xColumnProperty;
    }

    public String getYColumn() {
        return (String)this.yColumnProperty.get();
    }

    public void setYColumn(String string) {
        this.yColumnProperty.set((Object)string);
    }

    public StringProperty yColumnProperty() {
        return this.yColumnProperty;
    }

    public PanelFactory getCellFactory() {
        return (PanelFactory)this.cellFactoryProperty.get();
    }

    public void setCellFactory(PanelFactory panelFactory) {
        this.cellFactoryProperty.set((Object)panelFactory);
    }

    public ObjectProperty<PanelFactory> cellFactoryProperty() {
        return this.cellFactoryProperty;
    }

    public PanelFactory getRowLabelFactory() {
        return (PanelFactory)this.rowLabelFactoryProperty.get();
    }

    public void setRowLabelFactory(PanelFactory panelFactory) {
        this.rowLabelFactoryProperty.set((Object)panelFactory);
    }

    public ObjectProperty<PanelFactory> rowLabelFactoryProperty() {
        return this.rowLabelFactoryProperty;
    }

    public PanelFactory getColumnLabelFactory() {
        return (PanelFactory)this.columnLabelFactoryProperty.get();
    }

    public void setColumnLabelFactory(PanelFactory panelFactory) {
        this.columnLabelFactoryProperty.set((Object)panelFactory);
    }

    public ObjectProperty<PanelFactory> columnLabelFactoryProperty() {
        return this.columnLabelFactoryProperty;
    }

    public ObservableList<GridBackground> getGridBackgrounds() {
        return this.gridBackgrounds;
    }

    protected Class<? extends Node> getBindToClass() {
        return GridPane.class;
    }

    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        PanelFactory panelFactory;
        consumer.accept(Collections.singletonList(this.getCellFactory()));
        PanelFactory panelFactory2 = this.getRowLabelFactory();
        if (panelFactory2 != null) {
            consumer.accept(Collections.singletonList(panelFactory2));
        }
        if ((panelFactory = this.getColumnLabelFactory()) != null) {
            consumer.accept(Collections.singletonList(panelFactory));
        }
    }

    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.itemProperty.get());
    }

    protected void onInit(Context context) {
        if (this.listener == null) {
            GridPane gridPane = (GridPane)context.getContainer(GridPane.class);
            this.listener = (observableValue, bl, bl2) -> {
                if (!bl2.booleanValue()) {
                    this.resetGrid(gridPane);
                }
            };
            this.getItem().getUpdating().addListener(this.listener);
        }
    }

    protected void onClose(Context context) {
        if (this.listener != null) {
            this.getItem().getUpdating().removeListener(this.listener);
            this.listener = null;
        }
    }

    private void resetGrid(GridPane gridPane) {
        Object object2;
        DXRow dXRow2;
        FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)0.6), (Node)gridPane);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(1.0);
        fadeTransition.setCycleCount(1);
        fadeTransition.setAutoReverse(false);
        fadeTransition.setInterpolator(Interpolator.LINEAR);
        ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)0.4), (Node)gridPane);
        scaleTransition.setFromX(0.0);
        scaleTransition.setFromY(0.0);
        scaleTransition.setFromZ(0.0);
        scaleTransition.setToX(1.0);
        scaleTransition.setToY(1.0);
        scaleTransition.setToZ(1.0);
        scaleTransition.setCycleCount(1);
        scaleTransition.setAutoReverse(false);
        fadeTransition.play();
        scaleTransition.play();
        gridPane.getChildren().clear();
        TreeMap<Comparable, Integer> treeMap = new TreeMap<Comparable, Integer>();
        TreeMap<Comparable, Integer> treeMap2 = new TreeMap<Comparable, Integer>();
        ObservableListValue observableListValue = this.getItem().getObservable();
        for (DXRow dXRow2 : observableListValue) {
            Comparable comparable = (Comparable)dXRow2.get(this.getXColumn(), Comparable.class).get();
            Comparable comparable2 = (Comparable)dXRow2.get(this.getYColumn(), Comparable.class).get();
            if (!treeMap.containsKey(comparable)) {
                treeMap.put(comparable, 0);
            }
            if (treeMap2.containsKey(comparable2)) continue;
            treeMap2.put(comparable2, 0);
        }
        Iterator iterator = this.getRowLabelFactory();
        dXRow2 = this.getColumnLabelFactory();
        int n = dXRow2 != null ? 1 : 0;
        int n2 = n + treeMap.size();
        int n3 = n;
        for (Comparable comparable : treeMap.keySet()) {
            treeMap.put(comparable, n3);
            ++n3;
        }
        int n4 = iterator != null ? 1 : 0;
        int n5 = n4 + treeMap2.size();
        int n6 = n4;
        for (Object object2 : treeMap2.keySet()) {
            treeMap2.put((Comparable)object2, n6);
            ++n6;
        }
        block7: for (Object object2 : this.gridBackgrounds) {
            Pane pane;
            switch (((GridBackground)object2).getType()) {
                case ROW: {
                    int n7;
                    for (n7 = n; n7 < n2; ++n7) {
                        pane = new Pane();
                        pane.getStyleClass().add((Object)((GridBackground)object2).getStyleClass());
                        gridPane.add((Node)pane, n4, n7, treeMap2.size(), 1);
                    }
                    continue block7;
                }
                case COLUMN: {
                    int n7;
                    for (n7 = n4; n7 < n5; ++n7) {
                        pane = new Pane();
                        pane.getStyleClass().add((Object)((GridBackground)object2).getStyleClass());
                        gridPane.add((Node)pane, n7, n, 1, treeMap.size());
                    }
                    break;
                }
            }
        }
        Object object3 = new boolean[n2];
        Arrays.fill((boolean[])object3, false);
        object2 = new boolean[n5];
        Arrays.fill((boolean[])object2, false);
        for (Pane pane : observableListValue) {
            PanelFactory.Instance instance;
            MarkerValues markerValues = new MarkerValues((DXRow)pane);
            Comparable comparable = (Comparable)pane.get(this.getXColumn(), Comparable.class).get();
            Comparable comparable3 = (Comparable)pane.get(this.getYColumn(), Comparable.class).get();
            int n8 = (Integer)treeMap.get(comparable);
            if (iterator != null && object3[n8] == false) {
                PanelFactory.Instance instance2 = iterator.createPanel(markerValues);
                gridPane.add(instance2.getPanel(), 0, n8);
                object3[n8] = true;
                instance2.start();
            }
            int n9 = (Integer)treeMap2.get(comparable3);
            if (dXRow2 != null && object2[n9] == false) {
                instance = dXRow2.createPanel(markerValues);
                gridPane.add(instance.getPanel(), n9, 0);
                object2[n9] = true;
                instance.start();
            }
            instance = this.getCellFactory().createPanel(markerValues);
            gridPane.add(instance.getPanel(), n9, n8);
            instance.start();
        }
    }
}

