/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.experimental.control;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.ContainerItem;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpokeItem;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.HubSpokePanelFactory;
import oracle.dbtools.raptor.dba.navigator.metrics.experimental.control.LayoutContext;

@DefaultProperty(value="spokePaths")
public class HubSpoke
extends Region {
    private final FloatProperty flowBiasProperty = new SimpleFloatProperty((Object)this, "flowBias", 0.6f);
    private final FloatProperty radiusPerSectorProperty = new SimpleFloatProperty((Object)this, "radiusPerSector", 0.2f);
    private final FloatProperty innerRadiusProperty = new SimpleFloatProperty((Object)this, "innerRadius", 0.05f);
    private final BooleanProperty alignedPanelsProperty = new SimpleBooleanProperty((Object)this, "alignedPanels", false);
    private final ObjectProperty<HubSpokePanelFactory> panelFactoryProperty = new SimpleObjectProperty((Object)this, "panelFactory");
    private final ObservableList<String> spokePaths = FXCollections.observableArrayList();
    private final ContainerItem rootItem;
    private boolean updateRequested;

    public HubSpoke() {
        this.getStyleClass().setAll((Object[])new String[]{"hub-spoke"});
        this.spokePaths.addListener(change -> this.onItemsChanged((ListChangeListener.Change<? extends String>)change));
        this.rootItem = new ContainerItem(null){

            @Override
            void layoutNodes(LayoutContext layoutContext) {
                HubSpoke.this.layoutSpokes();
            }
        };
    }

    public float getFlowBias() {
        return this.flowBiasProperty.get();
    }

    public void setFlowBias(float f) {
        this.flowBiasProperty.set(f);
    }

    public FloatProperty flowBiasProperty() {
        return this.flowBiasProperty;
    }

    public float getRadiusPerSector() {
        return this.radiusPerSectorProperty.get();
    }

    public void setRadiusPerSector(float f) {
        this.radiusPerSectorProperty.set(f);
    }

    public FloatProperty radiusPerSectorProperty() {
        return this.radiusPerSectorProperty;
    }

    public float getInnerRadius() {
        return this.innerRadiusProperty.get();
    }

    public void setInnerRadius(float f) {
        this.innerRadiusProperty.set(f);
    }

    public FloatProperty innerRadiusProperty() {
        return this.innerRadiusProperty;
    }

    public boolean getAlignedPanels() {
        return this.alignedPanelsProperty.get();
    }

    public void setAlignedPanels(boolean bl) {
        this.alignedPanelsProperty.set(bl);
    }

    public BooleanProperty alignedPanelsProperty() {
        return this.alignedPanelsProperty;
    }

    public HubSpokePanelFactory getPanelFactory() {
        return (HubSpokePanelFactory)this.panelFactoryProperty.get();
    }

    public void setPanelFactory(HubSpokePanelFactory hubSpokePanelFactory) {
        this.panelFactoryProperty.set((Object)hubSpokePanelFactory);
    }

    public ObjectProperty<HubSpokePanelFactory> panelFactoryProperty() {
        return this.panelFactoryProperty;
    }

    public ObservableList<String> getSpokePaths() {
        return this.spokePaths;
    }

    public List<Region> findSpokePanels(String string) {
        ArrayList<Region> arrayList = new ArrayList<Region>();
        this.rootItem.listSpokePanels(arrayList, this.splitPath(string));
        return arrayList;
    }

    protected double computePrefWidth(double d) {
        double d2;
        ObservableList observableList = this.getChildren();
        if (this.rootItem.getSpokeCount() > 0) {
            Node node = (Node)observableList.get(1);
            d2 = 6.0 * node.prefWidth(-1.0);
        } else {
            d2 = 0.0;
        }
        return d2;
    }

    protected double computePrefHeight(double d) {
        double d2;
        ObservableList observableList = this.getChildren();
        if (this.rootItem.getSpokeCount() > 0) {
            Node node = (Node)observableList.get(1);
            d2 = 6.0 * node.prefHeight(-1.0);
        } else {
            d2 = 0.0;
        }
        return d2;
    }

    protected void layoutChildren() {
        if (this.spokePaths.size() > 0) {
            this.rootItem.layoutNodes(null);
        }
    }

    private void layoutSpokes() {
        final double d = this.snappedTopInset();
        final double d2 = this.snappedLeftInset();
        final double d3 = this.getWidth() - d2 - this.snappedRightInset();
        final double d4 = this.getHeight() - d - this.snappedBottomInset();
        final double d5 = 360.0 / (double)this.rootItem.getSpokeCount();
        int n = 0;
        for (HubSpokeItem hubSpokeItem : this.rootItem.getChildItems()) {
            final int n2 = n;
            hubSpokeItem.layoutNodes(new LayoutContext(){

                @Override
                LayoutContext getRootContext() {
                    return this;
                }

                @Override
                double getFlowBias() {
                    return HubSpoke.this.flowBiasProperty.get();
                }

                @Override
                double getAnglePerSegment() {
                    return d5;
                }

                @Override
                int getAggregateSpokeCount() {
                    return HubSpoke.this.rootItem.getSpokeCount();
                }

                @Override
                double getSpokeAngle(int n) {
                    return (double)n * d5;
                }

                @Override
                double getSegmentStartAngle(int n) {
                    return this.getSpokeAngle(n) - 0.5 * d5;
                }

                @Override
                int getStartSpoke() {
                    return n2;
                }

                @Override
                double getRadiusPerSector() {
                    return HubSpoke.this.radiusPerSectorProperty.get();
                }

                @Override
                double getInnerRadius() {
                    return HubSpoke.this.innerRadiusProperty.get();
                }

                @Override
                boolean isAlignedPanels() {
                    return HubSpoke.this.alignedPanelsProperty.get();
                }

                @Override
                double getW(Node node) {
                    return 2.0 * node.prefWidth(-1.0) / d3;
                }

                @Override
                double getH(Node node) {
                    return 2.0 * node.prefHeight(-1.0) / d4;
                }

                @Override
                double getPhysicalX(double d6) {
                    return HubSpoke.this.physicalX(d6, d2, d3);
                }

                @Override
                double getPhysicalY(double d6) {
                    return HubSpoke.this.physicalY(d6, d, d4);
                }

                @Override
                double getPhysicalW(double d6) {
                    return HubSpoke.this.physicalW(d6, d3);
                }

                @Override
                double getPhysicalH(double d6) {
                    return HubSpoke.this.physicalH(d6, d4);
                }

                @Override
                void layoutNode(Node node, double d6, double d22, double d32, double d42) {
                    HubSpoke.this.layoutInArea(node, this.getPhysicalX(d6), this.getPhysicalY(d22), 0.5 * d32 * d3, 0.5 * d42 * d4, 0.0, HPos.LEFT, VPos.TOP);
                }
            });
            n += hubSpokeItem.getSpokeCount();
        }
    }

    private double physicalX(double d, double d2, double d3) {
        return d2 + 0.5 * (d + 1.0) * d3;
    }

    private double physicalY(double d, double d2, double d3) {
        return d2 + 0.5 * (d + 1.0) * d3;
    }

    private double physicalW(double d, double d2) {
        return 0.5 * d * d2;
    }

    private double physicalH(double d, double d2) {
        return 0.5 * d * d2;
    }

    private void onItemsChanged(ListChangeListener.Change<? extends String> change) {
        while (change.next()) {
            if (change.wasAdded()) {
                for (String string : change.getAddedSubList()) {
                    this.addSpoke(string);
                }
            }
            if (!change.wasRemoved()) continue;
            for (String string : change.getRemoved()) {
                this.removeSpoke(string);
            }
        }
        if (!this.updateRequested) {
            this.updateRequested = true;
            Platform.runLater(() -> {
                this.initPanels();
                this.requestLayout();
                this.updateRequested = false;
            });
        }
    }

    private HubSpokePanelFactory createDefaultPanelFactory() {
        return new HubSpokePanelFactory(){

            @Override
            public Region createSectorPanel(int n, String string) {
                return this.createLabel(string, "sector-label");
            }

            @Override
            public Region createNodePanel(String string) {
                return this.createLabel(string, "node-label");
            }

            @Override
            public Region createFlowPanel(String string) {
                return null;
            }

            private Label createLabel(String string, String string2) {
                Label label = new Label(string);
                label.getStyleClass().setAll((Object[])new String[]{string2});
                return label;
            }
        };
    }

    private void addSpoke(String string) {
        HubSpokePanelFactory hubSpokePanelFactory = this.getPanelFactory();
        this.rootItem.insertSpoke(this.splitPath(string), 0, hubSpokePanelFactory != null ? hubSpokePanelFactory : this.createDefaultPanelFactory());
    }

    private void removeSpoke(String string) {
        this.rootItem.removeSpoke(this.splitPath(string));
    }

    private void initPanels() {
        final ObservableList observableList = this.getChildren();
        observableList.clear();
        this.rootItem.addNodes(new HubSpokeItem.Nodes(){
            private final Set<Node> nodeSet = new HashSet<Node>();

            @Override
            void add(Node node) {
                if (this.nodeSet.add(node)) {
                    observableList.add((Object)node);
                }
            }
        });
    }

    private LinkedList<String> splitPath(String string) {
        String[] stringArray = string.split("/");
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedList.addLast(stringArray[i]);
        }
        return linkedList;
    }
}

