/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.common;

import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import oracle.dbtools.raptor.metrics.panel.AbstractContent;
import oracle.dbtools.raptor.metrics.panel.Context;

public class SQLTab
extends AbstractContent {
    private final ObjectProperty<Supplier<String>> sqlSupplierProperty = new SimpleObjectProperty();
    private final GridPane gridPane = new GridPane();
    private final TextArea textArea;
    private final ToggleButton editButton;
    private final Button revertButton;
    private boolean edits;
    private boolean inAutoUpdate;

    public SQLTab() {
        this.gridPane.getStyleClass().add((Object)"sql-tab-grid");
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHgrow(Priority.NEVER);
        this.gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2});
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setVgrow(Priority.NEVER);
        RowConstraints rowConstraints2 = new RowConstraints();
        rowConstraints2.setVgrow(Priority.NEVER);
        RowConstraints rowConstraints3 = new RowConstraints();
        rowConstraints3.setVgrow(Priority.ALWAYS);
        this.gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{rowConstraints, rowConstraints2, rowConstraints3});
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        this.gridPane.add((Node)this.textArea, 0, 0, 1, 3);
        Image image = new Image(((Object)((Object)this)).getClass().getResourceAsStream("edit.png"));
        this.editButton = new ToggleButton();
        this.editButton.setGraphic((Node)new ImageView(image));
        this.editButton.setMaxWidth(Double.POSITIVE_INFINITY);
        this.gridPane.add((Node)this.editButton, 1, 0);
        Image image2 = new Image(((Object)((Object)this)).getClass().getResourceAsStream("revert.png"));
        this.revertButton = new Button();
        this.revertButton.setGraphic((Node)new ImageView(image2));
        this.revertButton.setMaxWidth(Double.POSITIVE_INFINITY);
        this.revertButton.setDisable(true);
        this.gridPane.add((Node)this.revertButton, 1, 1);
        this.editButton.setOnAction(actionEvent -> this.onEdit(this.editButton.isSelected()));
        this.revertButton.setOnAction(actionEvent -> this.onRevert());
        this.textArea.textProperty().addListener(observable -> this.onChange());
    }

    public Node getContentPanel() {
        return this.gridPane;
    }

    public Supplier<String> getSqlSupplier() {
        return (Supplier)this.sqlSupplierProperty.get();
    }

    public void setSqlSupplier(Supplier<String> supplier) {
        this.sqlSupplierProperty.set(supplier);
    }

    public ObjectProperty<Supplier<String>> sqlSupplierProperty() {
        return this.sqlSupplierProperty;
    }

    public void applySql() {
    }

    protected void onInit(Context context) {
        super.onInit(context);
        this.getTab().selectedProperty().addListener((observableValue, bl, bl2) -> {
            if (bl2.booleanValue()) {
                this.refreshSQL();
            }
        });
    }

    private void onChange() {
        if (!this.inAutoUpdate && !this.edits) {
            this.edits = true;
            this.revertButton.setDisable(false);
            this.disableOtherTabs(true);
        }
    }

    private void onEdit(boolean bl) {
        this.textArea.setEditable(bl);
    }

    private void onRevert() {
        this.refreshSQL();
        this.edits = false;
        this.revertButton.setDisable(true);
        this.disableOtherTabs(false);
    }

    private void refreshSQL() {
        this.inAutoUpdate = true;
        try {
            this.textArea.setText(this.getSqlSupplier().get());
        }
        finally {
            this.inAutoUpdate = false;
        }
    }

    private void disableOtherTabs(boolean bl) {
        Tab tab = this.getTab();
        for (Tab tab2 : tab.getTabPane().getTabs()) {
            if (tab2 == tab) continue;
            tab2.setDisable(bl);
        }
    }
}

