/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics;

import java.net.URI;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;

public class DbaMetricsUtil {
    public static void dbShut(String string) throws SQLException {
        try (OracleConnection oracleConnection = DbaMetricsUtil.getShutStartConnection(string, false);){
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.IMMEDIATE);
            try (Statement statement = oracleConnection.createStatement();){
                statement.executeUpdate("ALTER DATABASE CLOSE NORMAL");
                statement.executeUpdate("ALTER DATABASE DISMOUNT");
            }
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
        }
        DXService.requestSourceKeepAlive((URI)DXIds.newId((String)"sql", (String)string, (String)"DbSql"), null);
    }

    public static void dbStart(String string) throws SQLException {
        try (OracleConnection oracleConnection = DbaMetricsUtil.getShutStartConnection(string, true);){
            oracleConnection.startup(OracleConnection.DatabaseStartupMode.NO_RESTRICTION);
        }
        oracleConnection = DbaMetricsUtil.getShutStartConnection(string, false);
        var2_2 = null;
        try (Statement statement = oracleConnection.createStatement();){
            statement.executeUpdate("ALTER DATABASE MOUNT");
            statement.executeUpdate("ALTER DATABASE OPEN");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (oracleConnection != null) {
                if (var2_2 != null) {
                    try {
                        oracleConnection.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    oracleConnection.close();
                }
            }
        }
        DXService.requestSourceKeepAlive((URI)DXIds.newId((String)"sql", (String)string, (String)"DbSql"), null);
    }

    private static OracleConnection getShutStartConnection(String string, boolean bl) throws SQLException {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            throw new IllegalArgumentException("connectionName");
        }
        Properties properties2 = new Properties();
        properties2.setProperty("user", properties.getProperty("user"));
        properties2.setProperty("password", properties.getProperty("password"));
        properties2.setProperty("internal_logon", properties.getProperty("role"));
        if (bl) {
            properties2.setProperty("prelim_auth", "true");
        }
        OracleDataSource oracleDataSource = new OracleDataSource();
        oracleDataSource.setConnectionProperties(properties2);
        oracleDataSource.setURL(properties.getProperty("customUrl"));
        return (OracleConnection)oracleDataSource.getConnection();
    }
}

