/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespace;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class StateManagementAction
extends ActionDialog {
    private static final String TABLESPACE = "Tablespace";
    private static final String ACTION = "action";
    private static final String ONLINE = "online";
    private static final String OFFLINE = "offline";
    private String _status = null;

    protected String getTitle() {
        if (this._status.equals("ONLINE")) {
            return DbaNavigatorResources.getString("TABLESPACE_OFFLINE_TITLE");
        }
        if (this._status.equals("OFFLINE")) {
            return DbaNavigatorResources.getString("TABLESPACE_ONLINE_TITLE");
        }
        return DbaNavigatorResources.getString("INVALID_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TNAME", this.getDBObject().getObjectName());
        this._status = DBUtil.getInstance((Connection)connection).executeOracleReturnOneCol("select status from dba_tablespaces where tablespace_name = :TNAME", hashMap);
        boolean bl = false;
        boolean bl2 = false;
        if (this._status.equals("ONLINE")) {
            bl = true;
        } else if (this._status.equals("READ ONLY")) {
            bl = true;
        } else {
            bl2 = true;
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(TABLESPACE, DbaNavigatorResources.getString("TABLESPACE_LABEL"), this.getDBObject().getObjectName());
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(ONLINE, DbaNavigatorResources.getString("ONLINE"), bl2);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(OFFLINE, DbaNavigatorResources.getString("OFFLINE"), bl);
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(ACTION, DbaNavigatorResources.getString("OFFLINE_ACTION"), new String[]{"NORMAL", "TEMPORARY", "IMMEDIATE"}, "NORMAL");
        textBoxActionControl.enableUI(false);
        booleanCheckBoxActionControl.enableUI(false);
        booleanCheckBoxActionControl2.enableUI(false);
        comboBoxActionControl.enableUI(bl);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        arrayList.add((ActionControl)comboBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER TABLESPACE ");
        stringBuffer.append(DBUtil.addDoubleQuote((String)values.get(TABLESPACE)));
        stringBuffer.append(" ");
        if (Boolean.parseBoolean(values.get(ONLINE))) {
            stringBuffer.append("\n ONLINE");
        } else if (Boolean.parseBoolean(values.get(OFFLINE))) {
            stringBuffer.append("\n OFFLINE");
            stringBuffer.append("\n " + values.get(ACTION));
        } else {
            return "-- Invalid State";
        }
        return stringBuffer.toString();
    }
}

