/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.performance;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ObjectOperationDialog;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class ChangeExpirationAction
extends ObjectOperationDialog {
    private static final String EXPIRES_IN = "ExpiresIn";
    private int expiresIn;

    protected String getTitle() {
        return DbaNavigatorResources.getString("CHANGE_EXPIRATION_TITLE");
    }

    protected String getObjectLabel() {
        return DbaNavigatorResources.getString("TASK_NAME_LABEL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Object object2;
        this.expiresIn = 0;
        if (Connections.getInstance().lock(connection)) {
            block6: {
                object2 = null;
                try {
                    object = DBUtil.getInstance((Connection)connection);
                    object.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("NAME", this.getDBObjectName());
                    object2 = object.executeOracleQuery(Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)"getExpirationTime"), hashMap);
                    if (object2 == null) break block6;
                    while (object2.next()) {
                        this.expiresIn = object2.getInt(1);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object2);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object2);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object2);
            Connections.getInstance().unlock(connection);
        }
        object2 = new SpinnerActionControl(EXPIRES_IN, DbaNavigatorResources.getString("EXPIRES_IN_LABEL"), Integer.valueOf(this.expiresIn), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(1));
        object = super.createControls(connection);
        object.add(object2);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.parseInt(values.get(EXPIRES_IN));
        if (n != this.expiresIn) {
            stringBuffer.append("BEGIN\n");
            stringBuffer.append("   DBMS_ADVISOR.SET_TASK_PARAMETER('");
            stringBuffer.append(this.getDBObjectName());
            stringBuffer.append("', 'DAYS_TO_EXPIRE', ");
            stringBuffer.append(n);
            stringBuffer.append(");\n");
            stringBuffer.append("END;\n");
        }
        return stringBuffer.toString();
    }
}

