/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbsAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.FilePathActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class UnplugPdbsAction
extends PdbsAction {
    private static final String PDB_NAME = "PdbName";
    private static final String XML_FILE = "XmlFile";
    private static final String HELP_ID = "f1_dba_unplug_pdb_html";
    private Connection connection;

    protected String getHelpId() {
        return HELP_ID;
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("UNPLUG_PDB_TITLE");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected List<ActionControl> createControls(Connection connection) {
        FilePathActionControl filePathActionControl;
        TextBoxActionControl textBoxActionControl;
        Operation operation = this.getOperation();
        if (operation == Operation.PDBS) {
            textBoxActionControl = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), this.getObjectName());
            textBoxActionControl.setEditable(false);
            filePathActionControl = new FilePathActionControl(XML_FILE, DbaNavigatorResources.getString("XML_FILE"), this.getObjectName() + ".XML", 1);
        } else {
            textBoxActionControl = new SqlComboBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), connection, "select name from v$pdbs where name != 'PDB$SEED'");
            filePathActionControl = new FilePathActionControl(XML_FILE, DbaNavigatorResources.getString("XML_FILE"), "PDB.XML", 1);
        }
        this.connection = connection;
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)filePathActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "    ";
        stringBuilder.append("BEGIN");
        PdbsAction.State state = this.getState(this.connection, values.get(PDB_NAME));
        this.toggleState(stringBuilder, values.get(PDB_NAME), state, PdbsAction.State.MOUNTED, string);
        stringBuilder.append('\n' + string + "EXECUTE IMMEDIATE 'ALTER PLUGGABLE DATABASE \"" + values.get(PDB_NAME) + '\"');
        stringBuilder.append(" UNPLUG INTO ''");
        stringBuilder.append(values.get(XML_FILE) + "''';");
        stringBuilder.append('\n' + string + "EXECUTE IMMEDIATE 'DROP PLUGGABLE DATABASE \"" + values.get(PDB_NAME) + "\" KEEP DATAFILES';");
        stringBuilder.append("\nEND;");
        return stringBuilder.toString();
    }

    private static enum Operation {
        CONTAINER,
        PDBS;

    }
}

