/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbsAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class RefreshPdbsAction
extends PdbsAction {
    private static final String PDB_NAME = "PdbName";
    private static final String HELP_ID = "f1_dba_refresh_pdb_html";
    private String objName;
    private String conName;
    private Connection connection;

    protected String getHelpId() {
        return HELP_ID;
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("REFRESH_PDBS");
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.connection = connection;
        this.objName = this.getDBObject().getObjectName();
        this.conName = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select SYS_CONTEXT('USERENV', 'CON_NAME') NAME FROM DUAL");
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), this.getObjectName());
        textBoxActionControl.setEditable(false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "    ";
        stringBuilder.append("BEGIN");
        PdbsAction.State state = this.getState(this.connection, values.get(PDB_NAME));
        this.toggleState(stringBuilder, values.get(PDB_NAME), state, PdbsAction.State.MOUNTED, string);
        stringBuilder.append('\n' + string + "EXECUTE IMMEDIATE 'ALTER SESSION SET CONTAINER = " + this.objName + "';");
        stringBuilder.append('\n' + string + "EXECUTE IMMEDIATE 'ALTER PLUGGABLE DATABASE " + this.objName + " REFRESH';");
        stringBuilder.append('\n' + string + "EXECUTE IMMEDIATE 'ALTER SESSION SET CONTAINER = " + this.conName + "';");
        stringBuilder.append('\n' + string + "EXECUTE IMMEDIATE 'ALTER PLUGGABLE DATABASE \"" + this.objName + "\" OPEN READ ONLY';");
        stringBuilder.append("\nEND;");
        return stringBuilder.toString();
    }
}

