/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.datapump;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.ui.GlassPaneTaskViewer;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ssh.SshFilter;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.ActionContext;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.JavaActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ListActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.JSchSessionLocation;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferTask;
import oracle.dbtools.transfer.task.TransferTaskByteProgressMonitor;
import oracle.dbtools.transfer.task.TransferTaskProgressListener;
import oracle.dbtools.util.Logger;
import oracle.javatools.dialogs.MessageDialog;

public class DpExportFileTransfer
extends JavaActionDialog {
    private boolean transferTaskDone;
    private Throwable actionThrowable;
    private static final String EXPORT_JOB = "ExportJob";
    private static final String EXPORT_FILES = "ExportFiles";
    private static final String TARGET_CONNECTION = "TargetConnection";
    private static HashMap<String, String> _connMap = new HashMap();
    private static final String TARGET_DIRECTORY = "TargetDirectory";
    private static final String TARGET_DIRECTORY_PATH = "TargetDirectoryPath";
    private static final String NETWORK_TYPE = "networkType";
    private ListActionControl exportFiles;
    private ArrayList<String> exportFileList;
    private ComboBoxActionControl targetConnection;
    private ComboBoxActionControl targetDirectory;
    private TextBoxActionControl targetDirectoryPath;
    private GlassPaneTaskViewer glassPaneTaskViewer;
    private VetoableChangeListener dontCloseDialogListener;
    private RaptorTaskAdapter closeDialogListener;

    protected void doAction(ActionContext actionContext) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DbaNavigatorResources.getString("DP_XFER_TITLE"), true, IRaptorTaskRunMode.TASKVIEWER){

            protected Void doWork() throws TaskException {
                try {
                    FileSet fileSet = new FileSet(Location.getLocal(), (Collection)DpExportFileTransfer.this.exportFileList);
                    String string = DpExportFileTransfer.this.getValues().get(DpExportFileTransfer.TARGET_CONNECTION);
                    Properties properties = Connections.getInstance().getConnectionInfo((String)_connMap.get(string));
                    String string2 = (String)properties.get("SshHost.NAME");
                    Store store = Client.getInstance().getStore();
                    HostDescriptor hostDescriptor = store.getHostDescriptor(string2);
                    HostConnection hostConnection = Client.getInstance().openConnection(hostDescriptor);
                    JSchSessionLocation jSchSessionLocation = new JSchSessionLocation(hostConnection.getSession());
                    TransferTask transferTask = TransferManager.INSTANCE.createTransferTask("DataPumpExportFileTransferTask", IRaptorTaskRunMode.NO_GUI, fileSet, (Location)jSchSessionLocation, DpExportFileTransfer.this.getValues().get(DpExportFileTransfer.TARGET_DIRECTORY_PATH));
                    transferTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                            DpExportFileTransfer.this.actionThrowable = raptorTaskEvent.getThrowable();
                            this.done();
                        }

                        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                            this.done();
                        }

                        private void done() {
                            DpExportFileTransfer.this.transferTaskDone = true;
                        }
                    });
                    transferTask.getProgressMonitor().addListener((TransferTaskProgressListener)new TransferTaskByteProgressMonitor((RaptorTask)this, FileInfo.CHUNK_SIZE * 4L));
                    this.setMessage("Transfering " + fileSet.getPaths().size() + " files");
                    DpExportFileTransfer.this.transferTaskDone = false;
                    RaptorTaskManager.getInstance().addTask((RaptorTask)transferTask);
                    while (!DpExportFileTransfer.this.transferTaskDone) {
                        Thread.sleep(5000L);
                    }
                    if (DpExportFileTransfer.this.actionThrowable != null) {
                        throw DpExportFileTransfer.this.actionThrowable;
                    }
                }
                catch (Throwable throwable) {
                    throw new TaskException(throwable);
                }
                return null;
            }
        };
        this.addTask(raptorTask, true);
    }

    protected String getHelpId() {
        return "f1_dba_data_pump_export_file_transfer_html";
    }

    protected List<ActionControl> createControls(Connection connection) {
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(EXPORT_JOB, DbaNavigatorResources.getString("DP_XFER_JOB_LABEL"), this.getObjectName());
        textBoxActionControl.setEditable(false);
        this.exportFiles = new ListActionControl(EXPORT_FILES, DbaNavigatorResources.getString("DP_XFER_FILES_LABEL"), new String[0]);
        this.exportFiles.setEditable(false);
        this.targetConnection = new ComboBoxActionControl(TARGET_CONNECTION, DbaNavigatorResources.getString("DP_XFER_TGT_CONN_LABEL"), new String[0]);
        this.targetDirectory = new ComboBoxActionControl(TARGET_DIRECTORY, DbaNavigatorResources.getString("DP_XFER_TGT_DIR_LABEL"), new String[0]);
        this.targetDirectoryPath = new TextBoxActionControl(TARGET_DIRECTORY_PATH, DbaNavigatorResources.getString("DP_XFER_TGT_DIR_PATH_LABEL"), "");
        this.targetDirectoryPath.setEditable(false);
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(NETWORK_TYPE, DbaNavigatorResources.getString("NETWORK_TYPE_LABEL"), new String[]{DbaNavigatorResources.getString("NETWORK_TYPE_EXTREMELY_SLOW"), DbaNavigatorResources.getString("NETWORK_TYPE_TYPICAL"), DbaNavigatorResources.getString("NETWORK_TYPE_EXTREMELY_FAST")}, DbaNavigatorResources.getString("NETWORK_TYPE_TYPICAL"));
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)this.exportFiles);
        arrayList.add((ActionControl)this.targetConnection);
        arrayList.add((ActionControl)this.targetDirectory);
        arrayList.add((ActionControl)this.targetDirectoryPath);
        arrayList.add((ActionControl)comboBoxActionControl);
        this.initializeStaticValues();
        return arrayList;
    }

    private void initializeStaticValues() {
        Map map = this.getDBObject().getDictionary();
        String string = (String)map.get("OBJECT_OWNER");
        String string2 = (String)map.get("OBJECT_NAME");
        String string3 = String.format("\"%s\".\"%s\"", string, string2);
        Connection connection = this.getDBObject().getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        String string4 = String.format("select value_t from %s where name='LOG_FILE_DIRECTORY'", string3);
        String string5 = dBUtil.executeReturnOneCol(string4);
        String string6 = String.format("select DIRECTORY_PATH from ALL_DIRECTORIES where DIRECTORY_NAME='%s'", string5);
        String string7 = dBUtil.executeReturnOneCol(string6);
        if (null == string7) {
            Logger.severe(((Object)((Object)this)).getClass(), (String)"Can't determine log file directory path.");
        }
        File file = new File(string7);
        Logger.info(((Object)((Object)this)).getClass(), (String)("log file directory: " + file));
        if (!file.isDirectory()) {
            Logger.severe(((Object)((Object)this)).getClass(), (String)("Can't access log file directory path: " + string7));
        }
        String string8 = String.format("select value_t from %s where name='LOG_FILE_NAME'", string3);
        String string9 = dBUtil.executeReturnOneCol(string8);
        File file2 = new File(file, string9);
        Logger.info(((Object)((Object)this)).getClass(), (String)("log file: " + file2));
        if (!file2.canRead()) {
            Logger.severe(((Object)((Object)this)).getClass(), (String)("Can't access log_file: " + file2));
        }
        this.exportFileList = new ArrayList();
        this.exportFileList.add(String.valueOf(file2));
        String string10 = String.format("select USER_DIRECTORY, USER_FILE_NAME, FILE_NAME from %s where FILE_TYPE is not null and USER_FILE_NAME is not null", string3);
        List list = dBUtil.executeReturnListofList(string10, null);
        Logger.info(((Object)((Object)this)).getClass(), (String)String.valueOf(list));
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            this.exportFileList.add((String)((List)list.get(i)).get(2));
        }
        String[] stringArray = new String[this.exportFileList.size()];
        this.exportFiles.setListData(this.exportFileList.toArray(stringArray));
        List<String> list2 = Arrays.asList(Connections.getInstance().getConnNames((Connections.NameFilter)SshFilter.INSTANCE));
        for (String objectArray2 : list2) {
            _connMap.put(Connections.getDisplayName((String)objectArray2), objectArray2);
        }
        list2 = new ArrayList<String>();
        String string11 = "";
        list2.add(string11);
        list2.addAll(_connMap.keySet());
        Object[] objectArray = list2.toArray(new String[0]);
        Arrays.sort(objectArray);
        this.targetConnection.reset((String[])objectArray, string11);
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("DP_XFER_TITLE");
    }

    protected void addTask(RaptorTask<?> raptorTask, boolean bl) {
        if (bl) {
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)this.closeDialogListener);
        }
        RaptorTaskManager.getInstance().addTask(raptorTask, Collections.singletonList(this.glassPaneTaskViewer));
    }

    protected void initializeValues(final JEWTDialog jEWTDialog) {
        super.initializeValues(jEWTDialog);
        this.glassPaneTaskViewer = new GlassPaneTaskViewer();
        this.glassPaneTaskViewer.setBackground(jEWTDialog.getBackground());
        jEWTDialog.setGlassPane((Component)this.glassPaneTaskViewer);
        this.dontCloseDialogListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("closed" == propertyChangeEvent.getPropertyName()) {
                    jEWTDialog.removeVetoableChangeListener((VetoableChangeListener)this);
                    throw new PropertyVetoException(null, propertyChangeEvent);
                }
            }
        };
        jEWTDialog.addVetoableChangeListener(this.dontCloseDialogListener);
        jEWTDialog.setModalityType(Dialog.ModalityType.MODELESS);
        this.closeDialogListener = new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.done(raptorTaskEvent, true);
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                this.done(raptorTaskEvent, false);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                this.done(raptorTaskEvent, true);
            }

            private void done(RaptorTaskEvent raptorTaskEvent, boolean bl) {
                String string = raptorTaskEvent.getTaskDescriptor().getStatus().value();
                JPanel jPanel = LayoutControl.GBC.createPanel();
                jPanel.add((Component)new JLabel(string), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                if (bl) {
                    JPanel jPanel2 = LayoutControl.GBC.createDialogMainPanel((Component)jEWTDialog.getContent());
                    jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
                    jEWTDialog.closeDialog(raptorTaskEvent.getTaskDescriptor().isCancelled());
                    MessageDialog.information((Component)jEWTDialog.getParent(), (Object)jPanel, (String)DpExportFileTransfer.this.getTitle(), (String)DpExportFileTransfer.this.getHelpId());
                } else {
                    Throwable throwable = raptorTaskEvent.getThrowable();
                    if (throwable != null) {
                        JTextArea jTextArea = new JTextArea(throwable.getLocalizedMessage() + "\n" + String.valueOf(throwable.getStackTrace()[0]));
                        jTextArea.setEditable(false);
                        jPanel.add((Component)jTextArea, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
                    }
                    jEWTDialog.addVetoableChangeListener(DpExportFileTransfer.this.dontCloseDialogListener);
                    jEWTDialog.setVisible(true);
                    MessageDialog.error((Component)jEWTDialog.getParent(), (Object)jPanel, (String)DpExportFileTransfer.this.getTitle(), (String)DpExportFileTransfer.this.getHelpId());
                }
            }
        };
        this.targetConnection.addPropertyChangeListener(propertyChangeEvent -> {
            String string = this.getValues().get(TARGET_CONNECTION);
            final String string2 = _connMap.get(string);
            final String string3 = "select DIRECTORY_NAME from ALL_DIRECTORIES";
            DeferUIOperationTask deferUIOperationTask = new DeferUIOperationTask(TARGET_DIRECTORY){
                ArrayList directory_list;
                {
                    super(string);
                    this.directory_list = new ArrayList();
                }

                protected Object doWork() throws TaskException {
                    DBUtil dBUtil = DBUtil.getInstance((String)this.getConnectionName());
                    dBUtil.setRaiseError(true);
                    List list = dBUtil.executeReturnListofList(string3, null);
                    int n = list.size();
                    for (int i = 1; i < n; ++i) {
                        this.directory_list.add((String)((List)list.get(i)).get(0));
                    }
                    return null;
                }

                protected void invokeLater() {
                    Object[] objectArray = this.directory_list.toArray(new String[0]);
                    Arrays.sort(objectArray);
                    DpExportFileTransfer.this.targetDirectory.reset((String[])objectArray);
                }

                public String getConnectionName() {
                    return string2;
                }

                public String getQuery() {
                    return string3;
                }
            };
            this.addTask((RaptorTask<?>)deferUIOperationTask, false);
        });
        this.targetDirectory.addPropertyChangeListener(propertyChangeEvent -> {
            String string = this.getValues().get(TARGET_CONNECTION);
            final String string2 = _connMap.get(string);
            String string3 = this.getValues().get(TARGET_DIRECTORY);
            final String string4 = String.format("select DIRECTORY_PATH from ALL_DIRECTORIES where DIRECTORY_NAME='%s'", string3);
            DeferUIOperationTask deferUIOperationTask = new DeferUIOperationTask(TARGET_DIRECTORY_PATH){
                String target_directory_path;

                protected Object doWork() throws TaskException {
                    DBUtil dBUtil = DBUtil.getInstance((String)this.getConnectionName());
                    dBUtil.setRaiseError(true);
                    this.target_directory_path = dBUtil.executeReturnOneCol(string4);
                    return null;
                }

                protected void invokeLater() {
                    DpExportFileTransfer.this.targetDirectoryPath.set(this.target_directory_path);
                }

                public String getConnectionName() {
                    return string2;
                }

                public String getQuery() {
                    return string4;
                }
            };
            this.addTask((RaptorTask<?>)deferUIOperationTask, false);
        });
    }
}

