/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.datafiles;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateEditAction
extends ActionDialog {
    private static final String FILE_NAME = "FileName";
    private static final String DIRECTORY = "FileDirectory";
    private static final String TABLESPACE = "Tablespace";
    private static final String FILE_SIZE = "FileSize";
    private static final String REUSE = "Reuse";
    private static final String AUTO_EXTEND = "AutoExtend";
    private static final String INCREMENT = "Increment";
    private static final String UNLIMITED_MAX_SIZE = "UnlimitedMaxSize";
    private static final String MAX_SIZE = "MaxSize";

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_DATAFILE_TITLE") : DbaNavigatorResources.getString("CREATE_DATAFILE_TITLE");
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        String string;
        String string2;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        Object object;
        Operation operation = this.getOperation();
        String string3 = this.getObjectName();
        String string4 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
        String string5 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT") + "/";
        String string6 = null;
        long l = 100L;
        boolean bl = false;
        long l2 = 1000L;
        long l3 = 100L;
        if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
            object = null;
            try {
                textBoxActionControl = new HashMap();
                textBoxActionControl.put("FILEPATH", string3);
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "getDataFile"), (Map)textBoxActionControl);
                if (object != null) {
                    while (object.next()) {
                        string2 = object.getString("FILE_NAME");
                        int n = string2.lastIndexOf(47);
                        if (n < 0) {
                            n = string2.lastIndexOf(92);
                        }
                        n = n < 0 ? 0 : ++n;
                        string5 = string2.substring(0, n);
                        if (operation == Operation.EDIT) {
                            string4 = string2.substring(n);
                        }
                        string6 = object.getString("TABLESPACE_NAME");
                        long l4 = object.getLong("BYTES");
                        l = l4 / 1024L;
                        string = object.getString("AUTOEXTENSIBLE");
                        bl = "YES".equals(string);
                        long l5 = object.getLong("MAXBYTES");
                        l2 = l5 / 1024L;
                        long l6 = object.getLong("INCREMENTBYTES");
                        l3 = l6 / 1024L;
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
        object = new TextBoxActionControl(FILE_NAME, DbaNavigatorResources.getString("FILE_NAME_LABEL"), string4);
        textBoxActionControl = new TextBoxActionControl(DIRECTORY, DbaNavigatorResources.getString("DIRECTORY_LABEL"), string5);
        dBUtil = new SqlComboBoxActionControl(TABLESPACE, DbaNavigatorResources.getString("TABLESPACE_LABEL"), connection, this.getQuery(connection, "getTablespaceNames"), string6);
        string2 = new FileSizeActionControl(FILE_SIZE, DbaNavigatorResources.getString("FILE_SIZE_LABEL"), l * 1024L);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(REUSE, DbaNavigatorResources.getString("REUSE_LABEL"), false);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(AUTO_EXTEND, DbaNavigatorResources.getString("AUTO_EXTEND_LABEL"), bl);
        FileSizeActionControl fileSizeActionControl = new FileSizeActionControl(INCREMENT, DbaNavigatorResources.getString("INCREMENT_LABEL"), l3 * 1024L);
        string = new BooleanCheckBoxActionControl(UNLIMITED_MAX_SIZE, DbaNavigatorResources.getString("UNLIMITED_MAX_SIZE_LABEL"), operation == Operation.CREATE_NEW);
        FileSizeActionControl fileSizeActionControl2 = new FileSizeActionControl(MAX_SIZE, DbaNavigatorResources.getString("MAX_SIZE_LABEL"), l2 * 1024L);
        if (operation == Operation.EDIT) {
            object.setEditable(false);
            textBoxActionControl.setEditable(false);
            dBUtil.setEditable(false);
        }
        fileSizeActionControl.enableUI(bl);
        string.enableUI(bl && operation == Operation.CREATE_NEW);
        fileSizeActionControl2.enableUI(bl && operation != Operation.CREATE_NEW);
        booleanCheckBoxActionControl2.addPropertyChangeListener(new PropertyChangeListener((ActionControl)booleanCheckBoxActionControl2, (ActionControl)fileSizeActionControl, (BooleanCheckBoxActionControl)string, (ActionControl)fileSizeActionControl2){
            final /* synthetic */ ActionControl val$autoExtend;
            final /* synthetic */ ActionControl val$increment;
            final /* synthetic */ BooleanCheckBoxActionControl val$unlimitedMaxSize;
            final /* synthetic */ ActionControl val$maxSize;
            {
                this.val$autoExtend = actionControl;
                this.val$increment = actionControl2;
                this.val$unlimitedMaxSize = booleanCheckBoxActionControl;
                this.val$maxSize = actionControl3;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = Boolean.parseBoolean(this.val$autoExtend.getValue().get());
                this.val$increment.enableUI(bl);
                this.val$unlimitedMaxSize.enableUI(bl);
                this.val$maxSize.enableUI(bl);
            }
        });
        string.addPropertyChangeListener(new PropertyChangeListener((BooleanCheckBoxActionControl)string, (ActionControl)fileSizeActionControl2){
            final /* synthetic */ BooleanCheckBoxActionControl val$unlimitedMaxSize;
            final /* synthetic */ ActionControl val$maxSize;
            {
                this.val$unlimitedMaxSize = booleanCheckBoxActionControl;
                this.val$maxSize = actionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = !Boolean.parseBoolean(this.val$unlimitedMaxSize.getValue().get());
                this.val$maxSize.enableUI(bl);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)string2);
        if (operation != Operation.EDIT) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl);
        }
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        arrayList.add((ActionControl)fileSizeActionControl);
        arrayList.add((ActionControl)string);
        arrayList.add((ActionControl)fileSizeActionControl2);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("ALTER TABLESPACE \"");
            stringBuffer.append(values.get(TABLESPACE));
            stringBuffer.append("\"\nADD DATAFILE '");
            stringBuffer.append(values.get(DIRECTORY));
            stringBuffer.append(values.get(FILE_NAME));
            stringBuffer.append("'\nSIZE ");
            stringBuffer.append(values.get(FILE_SIZE, "SizeClause"));
            if (Boolean.parseBoolean(values.get(REUSE))) {
                stringBuffer.append("\nREUSE");
            }
        } else {
            stringBuffer.append("ALTER DATABASE DATAFILE '");
            stringBuffer.append(values.get(DIRECTORY));
            stringBuffer.append(values.get(FILE_NAME));
            stringBuffer.append("'\nRESIZE ");
            stringBuffer.append(values.get(FILE_SIZE, "SizeClause"));
            stringBuffer.append(";\n");
            stringBuffer.append("ALTER DATABASE DATAFILE '");
            stringBuffer.append(values.get(DIRECTORY));
            stringBuffer.append(values.get(FILE_NAME));
            stringBuffer.append("'");
        }
        if (Boolean.parseBoolean(values.get(AUTO_EXTEND))) {
            stringBuffer.append("\nAUTOEXTEND ON NEXT ");
            stringBuffer.append(values.get(INCREMENT, "SizeClause"));
            stringBuffer.append(" \nMAXSIZE ");
            if (Boolean.parseBoolean(values.get(UNLIMITED_MAX_SIZE))) {
                stringBuffer.append("UNLIMITED");
            } else {
                stringBuffer.append(values.get(MAX_SIZE, "SizeClause"));
            }
        } else {
            stringBuffer.append("\nAUTOEXTEND OFF");
        }
        return stringBuffer.toString();
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

