/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backuptabs;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditCompressionAlgorithmSettingsTab
extends ActionDialogTab {
    public static final String COMPRESSION_ALGORITHM = "COMPRESSION_ALGORITHM";
    public static final String ALGORITHM_RELEASE = "ALGORITHM_RELEASE";
    public static final String OPTIMIZE_FOR_LOAD = "OPTIMIZE_FOR_LOAD";
    private boolean _includeProcessorAction;

    public EditCompressionAlgorithmSettingsTab() {
        super(null, null);
        this._includeProcessorAction = true;
    }

    public EditCompressionAlgorithmSettingsTab(String string) {
        super(string, DbaNavigatorResources.getString("COMPRESSION_TAB"));
        this._includeProcessorAction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        ComboBoxActionControl comboBoxActionControl;
        Object object;
        Object object2;
        String[] stringArray;
        String[] stringArray2;
        block16: {
            block18: {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("DEFAULT");
                try {
                    stringArray2 = connection.getMetaData();
                    int n = stringArray2.getDatabaseMajorVersion();
                    int n2 = stringArray2.getDatabaseMinorVersion();
                    arrayList.add(Integer.toString(n) + '.' + n2 + ".0.0.0");
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                stringArray2 = new String[arrayList.size()];
                arrayList.toArray(stringArray2);
                stringArray = new String[]{};
                if (DbaUtil.getDatabaseMajorVersion(connection) < 11) break block18;
                if (!Connections.getInstance().lock(connection)) break block16;
                ResultSet resultSet = null;
                try {
                    object2 = new HashMap();
                    DBUtil dBUtil2 = DBUtil.getInstance((Connection)connection);
                    dBUtil2.setRaiseError(true);
                    resultSet = dBUtil2.executeOracleQuery(this.getQuery(connection, "getCompressionAlgorithmNames"), object2);
                    object = new ArrayList();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            ((ArrayList)object).add(resultSet.getString("ALGORITHM_NAME"));
                        }
                    }
                    stringArray = new String[((ArrayList)object).size()];
                    ((ArrayList)object).toArray(stringArray);
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block16;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
                break block16;
            }
            stringArray = new String[]{"BASIC"};
        }
        String string = null;
        object2 = null;
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            block17: {
                object = null;
                try {
                    comboBoxActionControl = new HashMap();
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "getCompressionAlgorithmSettings"), (Map)comboBoxActionControl);
                    if (object == null) break block17;
                    while (object.next()) {
                        string = object.getString(COMPRESSION_ALGORITHM);
                        object2 = object.getString(ALGORITHM_RELEASE);
                        bl = object.getString(OPTIMIZE_FOR_LOAD).equals("TRUE");
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object);
            Connections.getInstance().unlock(connection);
        }
        object = new ComboBoxActionControl(COMPRESSION_ALGORITHM, DbaNavigatorResources.getString("BACKUP_ALGORITHM_NAME_LABEL"), stringArray, string);
        comboBoxActionControl = new ComboBoxActionControl(ALGORITHM_RELEASE, DbaNavigatorResources.getString("BACKUP_RELEASE_LABEL"), stringArray2, object2);
        dBUtil = new BooleanCheckBoxActionControl(OPTIMIZE_FOR_LOAD, DbaNavigatorResources.getString("OPTIMIZE_FOR_LOAD_LABEL"), bl);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        if (this._includeProcessorAction) {
            arrayList.add((ActionControl)new SeperatorActionControl());
            arrayList.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        }
        return arrayList;
    }

    public static String getCompressionAlgorithm(ActionDialog.Lookup lookup) {
        return lookup.get(COMPRESSION_ALGORITHM);
    }

    public static String getAlgorithmRelease(ActionDialog.Lookup lookup) {
        return lookup.get(ALGORITHM_RELEASE);
    }

    public static boolean isOptimizeForLoad(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(OPTIMIZE_FOR_LOAD));
    }
}

