/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.awt.Component;
import java.sql.Connection;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditCompressionAlgorithmSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class EditCompressionAlgorithmSettingsAction
extends ActionDialog {
    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_COMPRESSION_ALGORITHM_SETTINGS_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        if (DbaUtil.getDatabaseMajorVersion(connection) < 11) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("ACTION_REQUIRES_11G"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
            throw new RuntimeException("11g or later is required");
        }
        EditCompressionAlgorithmSettingsTab editCompressionAlgorithmSettingsTab = new EditCompressionAlgorithmSettingsTab();
        return editCompressionAlgorithmSettingsTab.createControls(connection);
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CONFIGURE COMPRESSION ALGORITHM '");
        stringBuffer.append(values.get("COMPRESSION_ALGORITHM"));
        stringBuffer.append("' AS OF RELEASE '");
        stringBuffer.append(values.get("ALGORITHM_RELEASE"));
        stringBuffer.append("' OPTIMIZE FOR LOAD ");
        stringBuffer.append(Boolean.parseBoolean(values.get("OPTIMIZE_FOR_LOAD")) ? "TRUE" : "FALSE");
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }
}

