/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupjobs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.CustomBackupScriptGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.BackupOptionsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditCompressionAlgorithmSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditDiskDeviceSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditTapeBackupSetSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.EditTapeDeviceSettingsTab;
import oracle.dbtools.raptor.dba.navigator.actions.backuptabs.OverridePoliciesTab;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;

public abstract class CreateCustomBackupAction
extends ActionDialog {
    public static final String OPTIONS_TAB = "OPTIONS_TAB";
    public static final String COMPRESSION_TAB = "COMPRESSION_TAB";
    public static final String DISK_DEVICE_TAB = "DISK_DEVICE_TAB";
    public static final String TAPE_DEVICE_TAB = "TAPE_DEVICE_TAB";
    public static final String TAPE_BACKUP_SET_TAB = "TAPE_BACKUP_SET_TAB";
    public static final String POLICIES_TAB = "POLICIES_TAB";
    private boolean archiveLogMode;

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor(this);
    }

    protected abstract int getOptionsControlGroupsMask();

    protected boolean getTapeOnly() {
        return false;
    }

    protected abstract RMANScriptProcessorActionControl getScriptProcessorActionControl();

    protected List<ActionDialogTab> createAdditionalTabs() {
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>();
        arrayList.add(new BackupOptionsTab(OPTIONS_TAB, this.getOptionsControlGroupsMask(), this.getScriptProcessorActionControl(), this.getTapeOnly(), this, new String[]{COMPRESSION_TAB, DISK_DEVICE_TAB, TAPE_DEVICE_TAB, TAPE_BACKUP_SET_TAB, POLICIES_TAB}));
        arrayList.add(new EditCompressionAlgorithmSettingsTab(COMPRESSION_TAB));
        arrayList.add(new EditDiskDeviceSettingsTab(DISK_DEVICE_TAB));
        arrayList.add(new EditTapeDeviceSettingsTab(TAPE_DEVICE_TAB));
        arrayList.add(new EditTapeBackupSetSettingsTab(TAPE_BACKUP_SET_TAB));
        arrayList.add(new OverridePoliciesTab(POLICIES_TAB, true));
        return arrayList;
    }

    protected void onCreateControls(Connection connection) {
        this.archiveLogMode = DbaUtil.isArchiveLogMode(connection);
    }

    protected boolean isArchiveLogMode() {
        return this.archiveLogMode;
    }

    protected boolean isScriptProcessorDetached() {
        return false;
    }

    protected String getScript(ActionDialog.Values values) {
        CustomBackupScriptGenerator customBackupScriptGenerator = new CustomBackupScriptGenerator(this, this.isScriptProcessorDetached(), (ActionDialog.Lookup)values, (ActionDialog.Lookup)values.getTabLookup(OPTIONS_TAB), (ActionDialog.Lookup)values.getTabLookup(COMPRESSION_TAB), (ActionDialog.Lookup)values.getTabLookup(DISK_DEVICE_TAB), (ActionDialog.Lookup)values.getTabLookup(TAPE_DEVICE_TAB), (ActionDialog.Lookup)values.getTabLookup(TAPE_BACKUP_SET_TAB), (ActionDialog.Lookup)values.getTabLookup(POLICIES_TAB));
        return customBackupScriptGenerator.generateScript();
    }
}

