/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.navigator.DbaConnection;
import oracle.dbtools.raptor.dba.navigator.Messages;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.db.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.db.impl.TypeContainerTreeNode;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.javatools.db.DBException;

public class DbaTreeNode
extends TypeContainerTreeNode {
    private String m_tooltip;

    protected ObjectFactory getFactory() throws IOException, DBException {
        ObjectFactoryRegistry objectFactoryRegistry = ObjectFactoryRegistry.getRegistry((String)"sqldev.dbanav");
        DbaConnection dbaConnection = (DbaConnection)this.getElement();
        return objectFactoryRegistry.getFactory(dbaConnection.getQualifiedConnectionName(), (Connection)dbaConnection.getConnection());
    }

    public String getToolTipText() {
        if (this.m_tooltip == null) {
            AbstractConnectionNode abstractConnectionNode = (AbstractConnectionNode)this.getElement();
            this.m_tooltip = abstractConnectionNode.getShortLabel();
        }
        return this.m_tooltip;
    }

    protected RaptorTask<Collection<Element>> getLoadingTask() {
        final AbstractConnectionNode abstractConnectionNode = (AbstractConnectionNode)this.getElement();
        RaptorTask<Collection<Element>> raptorTask = new RaptorTask<Collection<Element>>(Messages.getString("DbaFilter.0"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            private void checkStatus(String string) throws AbortException {
                try {
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    throw new AbortException(string);
                }
            }

            protected Collection<Element> doWork() throws TaskException {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                try {
                    ObjectFactory objectFactory = null;
                    try {
                        this.checkStatus("getFactory");
                        objectFactory = DbaTreeNode.this.getFactory();
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    DbaTreeNode.this.m_tooltip = abstractConnectionNode.getShortLabel() + Messages.getString("DbaFilter.2");
                    if (objectFactory != null) {
                        String string = DbaTreeNode.this.getURLProtocol();
                        String string2 = objectFactory.getConnectionName();
                        String string3 = objectFactory.getSchema();
                        for (Object object : objectFactory.listTypes(null)) {
                            if (object.requiresParentObject()) continue;
                            String string4 = object.getType();
                            for (DatabaseFolder databaseFolder : object.getFolders()) {
                                DBFolderInstance dBFolderInstance = objectFactory.createFolderInstance(string4, databaseFolder);
                                if (dBFolderInstance == null) continue;
                                dBFolderInstance.setProperty("ConnectionType", (Object)objectFactory.getConnectionType());
                                URL uRL = DBURLFormatHelper.getURL((String)string, (String)string2, null, (String)string3, (String)dBFolderInstance.getType());
                                Folder folder = DatabaseNavigatorElementFactory.getTypeFolder((URL)uRL, (DBFolderInstance)dBFolderInstance);
                                arrayList.add((Element)folder);
                            }
                        }
                        DBSchemaInstance dBSchemaInstance = objectFactory.createSchemaInstance(null);
                        for (CategoryInstance categoryInstance : dBSchemaInstance.listCategories()) {
                            Object object;
                            object = DBURLFormatHelper.getURL((String)string, (String)string2, null, (String)string3, (String)categoryInstance.getDescriptor().getType());
                            arrayList.add((Element)new CategoryFolder((URL)object, categoryInstance));
                        }
                    }
                }
                catch (IOException iOException) {
                    Throwable throwable = iOException;
                    if (iOException instanceof WrappedException) {
                        throwable = iOException.getCause();
                    }
                    throw new TaskException(throwable);
                }
                catch (AbortException abortException) {
                    throw new TaskException((Throwable)abortException);
                }
                return arrayList;
            }

            public boolean cancel() {
                return true;
            }
        };
        return raptorTask;
    }
}

