/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.dba.navigator.Databases;
import oracle.dbtools.raptor.dba.navigator.DbaConnection;
import oracle.dbtools.raptor.dba.navigator.DbaNavWindow;
import oracle.dbtools.raptor.dba.navigator.editors.DbControlEditor;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.AbstractDBViewController;
import oracle.dbtools.raptor.navigator.db.impl.FilterableTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.view.View;

class DbaNavController
implements Controller {
    private static final String TOOLBAR_MENU = "DbaNavigator.TOOLBAR_MENU";
    private static final String REFRESH_CONNECTION = "DbaNavigator.REFRESH_CONNECTION";
    private static final String ADD_CONNECTION = "DbaNavigator.ADD_CONNECTION";
    private static final String MANAGE_CONNECTION = "DbaNavigator.MANAGE_CONNECTION";
    private static final String REMOVE_CONNECTION = "DbaNavigator.REMOVE_CONNECTION";
    public static final int ADD_CONNECTION_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.ADD_CONNECTION");
    public static final int REFRESH_CONNECTION_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.REFRESH_CONNECTION");
    public static final int MANAGE_CONNECTION_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.MANAGE_CONNECTION");
    public static final int REMOVE_CONNECTION_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.REMOVE_CONNECTION");
    public static final int COLLAPSEALL_CONNECTIONS_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.COLLAPSEALL_CONNECTIONS");
    public static final int TOOLBAR_MENU_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.TOOLBAR_MENU");

    DbaNavController() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (context.getView() instanceof DbaNavWindow) {
            int n = ideAction.getCommandId();
            if (n == REFRESH_CONNECTION_ID || n == 51) {
                bl = true;
                this.refreshParent(context);
            } else if (n == AbstractDBViewController.CLEAR_FILTER_CMD_ID) {
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getFirstNavigatorTreeNodeFromContext((Context)context);
                boolean bl2 = false;
                if (navigatorTreeNode instanceof FilterableTreeNode) {
                    bl2 = ((FilterableTreeNode)navigatorTreeNode).clearFilter();
                }
                if (bl2) {
                    DatabaseOverlayClient.updateOverlay((Element)navigatorTreeNode.getElement());
                    IdeAction ideAction2 = IdeAction.find((int)51);
                    if (ideAction2 != null) {
                        this.handleEvent(ideAction2, context);
                    }
                }
                bl = true;
            } else if (n == ADD_CONNECTION_ID) {
                String string = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)true);
                Databases.getInstance().addConnection(string);
                bl = true;
            } else if (n == MANAGE_CONNECTION_ID) {
                Element element;
                Element[] elementArray = context.getSelection();
                if (elementArray != null && elementArray.length == 1 && (element = context.getElement()) instanceof DbaConnection) {
                    DbControlEditor.openNewEditor((DbaConnection)element);
                }
                bl = true;
            } else if (n == REMOVE_CONNECTION_ID) {
                Element[] elementArray = context.getSelection();
                if (elementArray != null) {
                    for (Element element : elementArray) {
                        if (!(element instanceof DbaConnection)) continue;
                        String string = ((DbaConnection)element).getQualifiedConnectionName();
                        Databases.getInstance().removeConnection(string);
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    public void refreshParent(Context context) {
        View view;
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        NavigatorTreeNode navigatorTreeNode2 = null;
        if (navigatorTreeNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            navigatorTreeNode2 = navigatorTreeNode.findAncestorTreeNode(Element.class, true);
            if (navigatorTreeNode2 == null) {
                this.refreshNode(context);
            } else {
                NavigatorTree navigatorTree = ((NavigatorWindow)view).getTree();
                navigatorTree.refresh(navigatorTreeNode2);
            }
        }
    }

    public void refreshNode(Context context) {
        View view;
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        if (navigatorTreeNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            NavigatorTree navigatorTree = ((NavigatorWindow)view).getTree();
            navigatorTree.refresh(navigatorTreeNode);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (context.getView() instanceof DbaNavWindow) {
            int n = ideAction.getCommandId();
            if (n == REFRESH_CONNECTION_ID || n == 51) {
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
                if (navigatorTreeNode != null) {
                    boolean bl2 = false;
                    bl2 = true;
                    ideAction.setEnabled(bl2);
                    bl = true;
                }
            } else if (n == AbstractDBViewController.CLEAR_FILTER_CMD_ID) {
                boolean bl3 = false;
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getFirstNavigatorTreeNodeFromContext((Context)context);
                if (navigatorTreeNode instanceof FilterableTreeNode) {
                    bl3 = ((FilterableTreeNode)navigatorTreeNode).isFiltered();
                }
                ideAction.setEnabled(bl3);
                bl = true;
            } else if (n == AbstractDBViewController.FILTER_CMD_ID) {
                boolean bl4 = false;
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getFirstNavigatorTreeNodeFromContext((Context)context);
                if (navigatorTreeNode instanceof FilterableTreeNode) {
                    bl4 = ((FilterableTreeNode)navigatorTreeNode).canHaveFilter();
                }
                ideAction.setEnabled(bl4);
                bl = true;
            } else if (n == 55) {
                ideAction.setEnabled(true);
            } else if (n == 20) {
                ideAction.setEnabled(false);
                bl = true;
            }
        }
        return bl;
    }

    void initButton(JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbaNavController.this.handleButtonEvent();
            }
        });
    }

    public void handleButtonEvent() {
    }
}

