/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.headless;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.headless.CommandlineResources;
import oracle.dbtools.raptor.dba.headless.CopyDefinition;
import oracle.dbtools.raptor.dba.headless.DatabaseCopier;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;

public class DBAProcessor
implements HeadlessCommandProcessor {
    private String objectOwner = null;
    private String objectType = "TABLE";
    private CopyDefinition.DBO dbo = null;

    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headlessCore, String ... stringArray) throws InvalidCommandArgumentException {
        if (stringArray.length != 0) {
            if ("DBCOPY".equalsIgnoreCase(stringArray[0])) {
                CopyDefinition copyDefinition = this.parseCopyDefinition(stringArray);
                return copyDefinition != null ? new CopyDatabaseTask(copyDefinition) : null;
            }
            headlessCore.printErrorMessage(new String[]{CommandlineResources.format("INVALID_COMMAND", stringArray[0]), CommandlineResources.getString("USAGE_STRING")});
            throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", stringArray[0]));
        }
        headlessCore.printMessage(new String[]{CommandlineResources.getString("USAGE_STRING")});
        return null;
    }

    public String getUsageString() {
        return CommandlineResources.getString("USAGE_STRING");
    }

    private CopyDefinition parseCopyDefinition(String[] stringArray) throws InvalidCommandArgumentException {
        if (stringArray.length == 2 && (stringArray[1].equalsIgnoreCase("-help") || stringArray[1].equalsIgnoreCase("-h"))) {
            System.out.println(CommandlineResources.getString("DBCOPY_HELP"));
            return null;
        }
        CopyDefinition copyDefinition = new CopyDefinition();
        List<String> list = this.expandCopyDefinition(stringArray);
        String string = null;
        ArrayList<String> arrayList = null;
        for (String string2 : list) {
            if (string2.startsWith("-")) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                } else {
                    this.processCopyItem(copyDefinition, string, arrayList);
                    arrayList.clear();
                }
                string = string2.substring(1);
                continue;
            }
            if (arrayList == null) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string2));
            }
            arrayList.add(string2);
        }
        if (string != null) {
            this.processCopyItem(copyDefinition, string, arrayList);
        }
        if (copyDefinition.sourceDatabase() == null) {
            throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", "-sourcedb"));
        }
        if (copyDefinition.destDatabase() == null) {
            throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", "-destdb"));
        }
        return copyDefinition;
    }

    private List<String> expandCopyDefinition(String[] stringArray) throws InvalidCommandArgumentException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while (n < stringArray.length) {
            String string;
            if ("-DEFFILE".equalsIgnoreCase(string = stringArray[n++])) {
                if (n >= stringArray.length) {
                    throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
                }
                String string2 = stringArray[n++];
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
                    String string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        if (!string3.equals("") && !string3.startsWith("#")) {
                            Deque<String> deque = this.tokenizeLine(string3);
                            StringBuilder stringBuilder = null;
                            while (!deque.isEmpty()) {
                                String string4 = deque.pop();
                                if (stringBuilder != null) {
                                    if (string4.equals("\"")) {
                                        if (!deque.isEmpty() && deque.peek().equals("\"")) {
                                            deque.pop();
                                            stringBuilder.append("\"");
                                            continue;
                                        }
                                        arrayList.add(stringBuilder.toString());
                                        stringBuilder = null;
                                        continue;
                                    }
                                    stringBuilder.append(string4);
                                    continue;
                                }
                                if (string4.equals("\"")) {
                                    stringBuilder = new StringBuilder();
                                    continue;
                                }
                                if (string4.equals(" ")) continue;
                                arrayList.add(string4);
                            }
                            if (stringBuilder != null) {
                                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string3));
                            }
                        }
                        string3 = bufferedReader.readLine();
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string2));
                }
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private Deque<String> tokenizeLine(String string) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        while (stringTokenizer.hasMoreTokens()) {
            arrayDeque.addLast(stringTokenizer.nextToken());
        }
        return arrayDeque;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCopyItem(CopyDefinition copyDefinition, String string, List<String> list) throws InvalidCommandArgumentException {
        if ("SOURCEDB".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setSourceDatabase(list.get(0));
            return;
        } else if ("DESTDB".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setDestDatabase(list.get(0));
            return;
        } else if ("LOGFILE".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setLogFile(list.get(0));
            return;
        } else if ("SCHEMAS".equalsIgnoreCase(string)) {
            if (list.size() == 0) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            copyDefinition.setCopySchemas(stringArray);
            return;
        } else if ("TABLESPACE".equalsIgnoreCase(string)) {
            if (list.size() != 2) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setCopyTablespace(list.get(0), list.get(1));
            return;
        } else if ("CONSOLIDATESCHEMA".equalsIgnoreCase(string)) {
            if (list.size() != 0) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setConsolidateSchemaEnabled(true);
            return;
        } else if ("COPYDDL".equalsIgnoreCase(string)) {
            if (list.size() > 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setCopyDDLEnabled(true);
            if (list.size() == 1) {
                if (!"REPLACE".equalsIgnoreCase(list.get(0))) throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
                copyDefinition.setCopyDDLReplace(true);
                return;
            } else {
                copyDefinition.setCopyDDLReplace(false);
            }
            return;
        } else if ("NOCOPYDDL".equalsIgnoreCase(string)) {
            if (list.size() != 0) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setCopyDDLEnabled(false);
            return;
        } else if ("COPYDATA".equalsIgnoreCase(string)) {
            if (list.size() > 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setCopyDataEnabled(true);
            if (list.size() == 1) {
                if (!"TRUNCATE".equalsIgnoreCase(list.get(0))) throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
                copyDefinition.setCopyDataTruncateEnabled(true);
                return;
            } else {
                copyDefinition.setCopyDataTruncateEnabled(false);
            }
            return;
        } else if ("NOCOPYDATA".equalsIgnoreCase(string)) {
            if (list.size() != 0) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setCopyDataEnabled(false);
            return;
        } else if ("GLOBALWHERE".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setGlobalWhere(list.get(0));
            return;
        } else if ("ALLTYPES".equalsIgnoreCase(string)) {
            if (list.size() != 0) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setAllDDLTypes(true);
            return;
        } else if ("ALLTYPESBUT".equalsIgnoreCase(string)) {
            if (list.size() < 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setAllDDLTypes(true);
            this.setDDLTypeExclusions(copyDefinition, list);
            return;
        } else if ("NOTYPESBUT".equalsIgnoreCase(string)) {
            if (list.size() < 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            copyDefinition.setAllDDLTypes(false);
            this.setDDLTypeExclusions(copyDefinition, list);
            return;
        } else if ("OWNER".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            this.objectOwner = list.get(0);
            return;
        } else if ("TYPE".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            this.objectType = list.get(0).toUpperCase();
            return;
        } else if ("OBJECT".equalsIgnoreCase(string)) {
            if (list.size() < 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            for (String string2 : list) {
                try {
                    this.dbo = copyDefinition.addObjectDef(this.objectType, this.objectOwner, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", illegalArgumentException.getMessage()));
                }
            }
            return;
        } else if ("COLUMN".equalsIgnoreCase(string)) {
            if (this.dbo == null || list.size() < 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            for (String string3 : list) {
                this.dbo.columns().add(string3);
            }
            return;
        } else {
            if (!"WHERE".equalsIgnoreCase(string)) return;
            if (this.dbo == null || list.size() != 1) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
            this.dbo.setWhere(list.get(0));
        }
    }

    private void setDDLTypeExclusions(CopyDefinition copyDefinition, List<String> list) throws InvalidCommandArgumentException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            try {
                arrayList.add(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", string));
            }
        }
        try {
            copyDefinition.setDDLTypeExclusions(arrayList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidCommandArgumentException(CommandlineResources.format("INVALID_COMMAND", illegalArgumentException.getMessage()));
        }
    }

    private static class CopyDatabaseTask
    extends HeadlessTask<Void> {
        private CopyDefinition definition;

        CopyDatabaseTask(CopyDefinition copyDefinition) {
            super("copy");
            this.definition = copyDefinition;
        }

        protected Void doWork() throws TaskException {
            DatabaseCopier databaseCopier = new DatabaseCopier();
            databaseCopier.process(this.definition);
            return null;
        }
    }
}

