/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.headless;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.raptor.ddl.DDLTypes;

public class CopyDefinition {
    private Type copyType = Type.OBJECTS;
    private boolean consolidateSchemaEnabled = false;
    private boolean copyDDLEnabled = true;
    private boolean copyDDLReplace = false;
    private boolean copyDataEnabled = true;
    private boolean copyDataTruncateEnabled = false;
    private String sourceTablespace;
    private String destTablespace;
    private String logFile;
    private String[] schemas;
    private String sourceDatabase;
    private String destDatabase;
    private String globalWhere;
    private List<DBO> objectDefs = new ArrayList<DBO>();
    private boolean allDDLTypes = false;
    private List<String> ddlTypeExclusions;
    private Set<String> ddlTypeSet;

    public CopyDefinition() {
        DDLTypes dDLTypes = new DDLTypes();
        this.ddlTypeSet = new HashSet<String>(dDLTypes.getTypeList());
    }

    public void setCopySchemas(String[] stringArray) {
        if (this.copyType != Type.TABLESPACE) {
            this.copyType = Type.SCHEMAS;
        }
        this.schemas = stringArray;
    }

    public void setCopyTablespace(String string, String string2) {
        this.copyType = Type.TABLESPACE;
        this.sourceTablespace = string;
        this.destTablespace = string2;
    }

    public void setConsolidateSchemaEnabled(boolean bl) {
        this.consolidateSchemaEnabled = bl;
    }

    public void setCopyDDLEnabled(boolean bl) {
        this.copyDDLEnabled = bl;
    }

    public void setCopyDDLReplace(boolean bl) {
        this.copyDDLReplace = bl;
    }

    public void setCopyDataEnabled(boolean bl) {
        this.copyDataEnabled = bl;
    }

    public void setCopyDataTruncateEnabled(boolean bl) {
        this.copyDataTruncateEnabled = bl;
    }

    public void setSourceDatabase(String string) {
        this.sourceDatabase = string;
    }

    public void setDestDatabase(String string) {
        this.destDatabase = string;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public void setGlobalWhere(String string) {
        this.globalWhere = string;
    }

    public void setAllDDLTypes(boolean bl) {
        this.allDDLTypes = bl;
    }

    public void setDDLTypeExclusions(List<String> list) {
        for (String string : list) {
            if (this.ddlTypeSet.contains(string.toUpperCase())) continue;
            throw new IllegalArgumentException(string);
        }
        this.ddlTypeExclusions = list;
    }

    public DBO addObjectDef(String string, String string2, String string3) {
        DBO dBO = new DBO(string, string2, string3);
        this.objectDefs.add(dBO);
        return dBO;
    }

    public Type copyType() {
        return this.copyType;
    }

    public boolean isConsolidateSchemaEnabled() {
        return this.consolidateSchemaEnabled;
    }

    public boolean isCopyDDLEnabled() {
        return this.copyDDLEnabled;
    }

    public boolean isCopyDDLReplace() {
        return this.copyDDLReplace;
    }

    public boolean isCopyDataEnabled() {
        return this.copyDataEnabled;
    }

    public boolean isCopyDataTruncateEnabled() {
        return this.copyDataTruncateEnabled;
    }

    public String sourceTablespace() {
        return this.sourceTablespace;
    }

    public String destTablespace() {
        return this.destTablespace;
    }

    public String[] schemas() {
        return this.schemas;
    }

    public String sourceDatabase() {
        return this.sourceDatabase;
    }

    public String destDatabase() {
        return this.destDatabase;
    }

    public String logFile() {
        return this.logFile;
    }

    public String globalWhere() {
        return this.globalWhere;
    }

    public boolean allDDLTypes() {
        return this.allDDLTypes;
    }

    public List<String> ddlTypeExclusions() {
        return this.ddlTypeExclusions;
    }

    public List<DBO> objectDefs() {
        return Collections.unmodifiableList(this.objectDefs);
    }

    public static enum Type {
        OBJECTS,
        SCHEMAS,
        TABLESPACE;

    }

    public class DBO {
        private String objectType;
        private String objectOwner;
        private String name;
        private List<String> columns;
        private String where;

        DBO(String string, String string2, String string3) {
            if (!CopyDefinition.this.ddlTypeSet.contains(string.toUpperCase())) {
                throw new IllegalArgumentException(string);
            }
            this.objectType = string;
            this.objectOwner = string2;
            this.name = string3;
            this.columns = new ArrayList<String>();
            this.where = null;
        }

        public String objectType() {
            return this.objectType;
        }

        public String objectOwner() {
            return this.objectOwner;
        }

        public String name() {
            return this.name;
        }

        public List<String> columns() {
            return this.columns;
        }

        public String where() {
            return this.where;
        }

        public void setWhere(String string) {
            this.where = string;
        }
    }
}

