/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.streams.Offline3rdPartyDMSAbstract;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;
import oracle.dbtools.migration.teradata.offline.OfflineBTEQExternalLoaderDMStream;
import oracle.dbtools.migration.teradata.offline.OfflineBTEQSQLLoaderDMStream;
import oracle.dbtools.migration.teradata.offline.OfflineTeradataDatamoveStream;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.AbstractTeradataPlugin;
import oracle.dbtools.migration.workbench.plugin.Teradata12BTEQExternalSQLLoaderState;
import oracle.dbtools.migration.workbench.plugin.Teradata12BTEQState;
import oracle.dbtools.migration.workbench.plugin.Teradata12FEXPExternalSQLLoaderState;
import oracle.dbtools.migration.workbench.plugin.Teradata12FEXPState;
import oracle.dbtools.migration.workbench.plugin.TeradataQuoter;
import oracle.dbtools.migration.workbench.plugin.TeradataStateInterface;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12Converter;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12OfflineCapturerStage;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12Provider;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class Teradata12Plugin
extends AbstractTeradataPlugin {
    public static final String BTEQ_CMD_WIN = "bteq -e UTF8 -c UTF8 .logon %1/%2,%3 < unload_script.bteq";
    public static final String BTEQ_CMD_UNIX = "bteq -e UTF8 -c UTF8 .logon ${args[0]}/${args[1]},${args[2]} < unload_script.bteq";
    public static final String FEXP_CMD_WIN = "fexp  -i UTF8 -u UTF8 -c UTF16 -r \".logon %1/%2,%3 ;\" < unload_script.fexp";
    public static final String FEXP_CMD_UNIX = "fexp  -i UTF8 -u UTF8 -c UTF16 -r \".logon ${args[0]}/${args[1]},${args[2]} ;\" < unload_script.fexp";
    protected Converter m_converter = null;
    protected StringTemplateGroup m_templateGroup = null;
    public static final String DRIVER_CLASS = "com.teradata.jdbc.TeraDriver";
    protected static boolean s_driverLoaded = false;
    protected TeradataStateInterface bteqState = null;
    protected TeradataStateInterface externalBTEQSQLLoaderState = null;
    protected TeradataStateInterface externalFEXPSQLLoaderState = null;
    protected TeradataStateInterface fexpState = null;
    protected TeradataStateInterface state;

    public Teradata12Plugin() {
        this.initState();
    }

    public String getPlatformName() {
        return "Teradata";
    }

    public String getPluginName() {
        return "Teradata 12";
    }

    public String getVersionNumber() {
        return "12.0";
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.teradata");
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.equals(this.getPlatformName()) && n == 12) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    public String getPlatformNameforNavigator() {
        return "Teradata";
    }

    public String getPublishedVersion() {
        return "12";
    }

    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            Teradata12Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return this.getProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName(DRIVER_CLASS).newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationPluginException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MigrationPluginException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MigrationPluginException((Throwable)illegalAccessException);
            }
        }
    }

    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        try {
            Teradata12Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return this.getProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        try {
            Teradata12Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return this.getProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection connection) {
        return new Teradata12Provider(connection);
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new Teradata12Converter();
        }
        return this.m_converter;
    }

    private void loadTemplates() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2) {
        return this.state.getDataExportCommmand(this, string, mdColumnArray, string2, true);
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        return this.state.getDataExportCommmand(this, string, mdColumnArray, string2, bl);
    }

    @Override
    public String quote(String string) {
        String string2 = null;
        if (string != null) {
            if (string.contains("\"")) {
                string2 = string;
            } else if (string.contains(".")) {
                String[] stringArray = string.split("\\.");
                String string3 = "";
                string2 = "";
                for (String string4 : stringArray) {
                    string2 = string2 + string3 + "\"" + string4 + "\"";
                    string3 = ".";
                }
            } else {
                string2 = "\"" + string + "\"";
            }
        }
        return string2;
    }

    protected String getLobFileOption() {
        return "";
    }

    public String getDatafileExtension() {
        return this.state == null ? "dat" : this.state.getDatafileExtension();
    }

    public String getBTEQExportExtension() {
        return "exp";
    }

    public String maybeQuoteSqlldrFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = this.getState().maybeQuoteSqlldrFieldReference(this, mdColumn, mdColumn2);
        return string;
    }

    public String maybeQuoteExternalFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = this.getState().maybeQuoteExternalFieldReference(this, mdColumn, mdColumn2);
        return string;
    }

    @Override
    public String trunk30(String string) {
        if (string.length() > 30) {
            return string.substring(0, 30);
        }
        return string;
    }

    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        return this.getBTEQState().formatSQLLoaderColumn(this, mdColumn, mdColumn2, false);
    }

    public MigrationPlugin.ProjectMergeLevel getMergeProjectSupportLevel() {
        return MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_SCHEMA;
    }

    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/Teradata12DataTypesMap.xml";
    }

    public void initialize() {
        super.initialize();
    }

    public OfflineCapturer getOfflineCapturer() {
        return new Teradata12OfflineCapturerStage();
    }

    public Offline3rdPartyDMSAbstract getOffline3rdPartyPrintStream(String string, String string2) {
        return new OfflineTeradataDatamoveStream(string2, (MigrationPlugin)this);
    }

    public OfflineDMSAbstract getSQLLoaderDMStream(String string, String string2) {
        return new OfflineBTEQSQLLoaderDMStream(string2, (MigrationPlugin)this);
    }

    public OfflineDMSAbstract getExternalLoaderDMStream(String string, String string2) {
        return new OfflineBTEQExternalLoaderDMStream(string2, (MigrationPlugin)this);
    }

    public Object[] generateExternalTableColumnDefinitions(MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        Object[] objectArray = null;
        objectArray = this.getState().generateExternalTableColumnDefinitions(this, mdColumnArray, mdColumnArray2);
        return objectArray;
    }

    public String generateExternalColumnDefinitions(MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        String string = null;
        string = this.getState().generateExternalColumnDefinitions(this, mdColumnArray, mdColumnArray2);
        return string;
    }

    public String generateExternalSelectColumnList(MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        String string = null;
        string = this.getState().generateExternalSelectColumnList(this, mdColumnArray, mdColumnArray2);
        return string;
    }

    public StringTemplate getLoadCtlStatementTemplate() {
        this.loadTemplates();
        return this.m_templateGroup.getInstanceOf("LoadCtlStatement");
    }

    public StatementProvider getStatementProviderForDataMove() {
        return new StatementProvider(){

            public String getColumnSelectPattern(String string, MdColumn mdColumn) {
                String string2 = mdColumn.getColumnType();
                String string3 = mdColumn.getColumnName();
                String string4 = string;
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND")) {
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL DAY" + (n != null ? "(" + n + ")" : "") + " TO SECOND" + (n2 != null ? "(" + n2 + ")" : "") + ") (NAMED " + string + ")";
                } else if (string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND")) {
                    switch (n) {
                        case 4: {
                            n = 3;
                            break;
                        }
                        case 3: {
                            n = 2;
                            break;
                        }
                        default: {
                            n = 1;
                        }
                    }
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL DAY(" + n + ") TO SECOND" + (n2 != null ? "(" + n2 + ")" : "") + ") (NAMED " + string + ")";
                } else if (string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("SECOND")) {
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL DAY(1) TO SECOND" + (n2 != null ? "(" + n2 + ")" : "") + ") (NAMED " + string + ")";
                } else if (string2.equals("YEAR") || string2.equals("YEARMONTH")) {
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) (NAMED " + string + ")";
                } else if (string2.equals("MONTH")) {
                    switch (n) {
                        case 4: {
                            n = 3;
                            break;
                        }
                        case 3: {
                            n = 2;
                            break;
                        }
                        default: {
                            n = 1;
                        }
                    }
                    string4 = "CAST(\"" + string3 + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) (NAMED " + string + ")";
                }
                return string4;
            }
        };
    }

    public String createDataFileName(String string, String string2) {
        return string.replaceAll("[ \\\\/$]", "_") + "." + this.getDatafileExtension();
    }

    public Quoter getQuoter() {
        return new TeradataQuoter();
    }

    public int getPlatformMask() {
        return 131072;
    }

    public void setConnectStatement(PrintStream printStream) {
        String string = "FIXME";
        string = string.substring(0, string.lastIndexOf(".")) + ".sh";
        String string2 = "";
    }

    protected TeradataStateInterface initState() {
        this.state = this.bteqState;
        return this.state;
    }

    @Override
    public TeradataStateInterface getFEXPState() {
        if (this.fexpState == null) {
            this.fexpState = new Teradata12FEXPState(this);
        }
        return this.fexpState;
    }

    @Override
    public TeradataStateInterface getBTEQState() {
        if (this.bteqState == null) {
            this.bteqState = new Teradata12BTEQState(this);
        }
        return this.bteqState;
    }

    @Override
    public TeradataStateInterface getBTEQExternalSQLLoaderState() {
        if (this.externalBTEQSQLLoaderState == null) {
            this.externalBTEQSQLLoaderState = new Teradata12BTEQExternalSQLLoaderState(this);
        }
        return this.externalBTEQSQLLoaderState;
    }

    @Override
    public TeradataStateInterface getFEXPExternalSQLLoaderState() {
        if (this.externalFEXPSQLLoaderState == null) {
            this.externalFEXPSQLLoaderState = new Teradata12FEXPExternalSQLLoaderState(this);
        }
        return this.externalFEXPSQLLoaderState;
    }

    @Override
    public void setState(TeradataStateInterface teradataStateInterface) {
        this.state = teradataStateInterface;
    }

    public TeradataStateInterface getState() {
        return this.state;
    }

    public String getDataHeaderCommand(boolean bl) {
        return "";
    }
}

