/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.teradata.offline;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.offline.streams.MdColumnComparator;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;
import oracle.dbtools.migration.teradata.offline.AbstractTeradataOfflineStream;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import org.antlr.stringtemplate.StringTemplateGroup;

public class OfflineBTEQScriptTeradataDMStream
extends AbstractTeradataOfflineStream {
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getName());
    protected StringTemplateGroup m_templateGroup = null;
    private static final String FILENAME = "bteq1";
    private static final String EXTENSION = "bteq1";
    private static final String TYPE = "bteq1";
    private PrintWriter bteqPW;

    public OfflineBTEQScriptTeradataDMStream(String string, MigrationPlugin migrationPlugin) {
        super(string, "bteq1");
        this.setPlugin(migrationPlugin);
    }

    public String getExtension() {
        return "bteq1";
    }

    public String getFileName() {
        return "bteq1";
    }

    public String getGenType() {
        return "bteq1";
    }

    public String getDataFileName(String string, String string2) {
        return this.getPlugin().createDataFileName(string, string2);
    }

    public String getRowDelimiter() {
        return null;
    }

    public String getFieldTerminator() {
        return null;
    }

    public ArrayList<String> getColumnList() {
        return null;
    }

    public void println(PrintWriter printWriter, String string, boolean bl) {
        try {
            printWriter.print(bl ? OfflineDMSAbstract.makeWindows((CharSequence)string) : OfflineDMSAbstract.makeUnix((CharSequence)string));
            printWriter.print(bl ? "\r\n" : "\n");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public void finished() {
    }

    public void start(MdConnection mdConnection, PersistenceManager persistenceManager) {
        try {
            this.setPlugin(MigrationUtils.getPluginForConnection((MdConnection)mdConnection));
        }
        catch (MigrationPluginException migrationPluginException) {
            this.LOGGER.log(Level.SEVERE, "Migration Plugin cannot be found");
        }
        this.mdConnection = mdConnection;
        this.m_persistenceManager = persistenceManager;
    }

    public void startDatabase(String string, String string2) {
        this.setCatalogDir("Teradata");
    }

    public void endDatabase() {
    }

    public void startSchema(String string, String string2) {
        this.setCatalogDir("Teradata");
        this.schemaDir = string2;
        String string3 = this.getSchemaDir() + File.separator + "unload_script.bteq";
        try {
            this.bteqPW = new PrintWriter(string3);
        }
        catch (Exception exception) {
            this.bteqPW = null;
        }
    }

    public void endSchema() {
        if (this.bteqPW != null) {
            this.bteqPW.close();
        }
    }

    public void startTable(String string) {
        MdColumn[] mdColumnArray = this.m_descriptor.getSourceColumns();
        Arrays.sort(mdColumnArray, new MdColumnComparator());
        String string2 = this.getPlugin().createDataFileName(this.m_descriptor.getTargetTableName(true), this.m_descriptor.getSourceTableName());
        String string3 = this.getDataExportCommmand(this.m_descriptor.getSourceTableName(), mdColumnArray, string2, false);
        this.println(this.bteqPW, string3, true);
    }

    public void endTable() {
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        String string3 = this.getTeradataPlugin().getBTEQState().getDataExportScript(this.getTeradataPlugin(), string, mdColumnArray, string2);
        return string3;
    }
}

