/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.javatools.util.NullResourceBundle;

public class FormatBundle_es {
    private String bundleName;
    private ResourceBundle bundle = null;

    public FormatBundle_es(ResourceBundle bundle) {
        this.bundleName = null;
        this.bundle = bundle;
    }

    public FormatBundle_es(String bundleName) {
        this.bundleName = bundleName;
    }

    public FormatBundle_es(Class type) {
        this.bundleName = type.getName();
        if (!ResourceBundle.class.isAssignableFrom(type)) {
            this.bundleName = this.bundleName + "Bundle";
        }
    }

    public String get(String key) {
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return "?" + key;
        }
    }

    public String get(String key, Object ... arguments) {
        if (arguments == null) {
            try {
                return this.getBundle().getString(key);
            }
            catch (MissingResourceException e) {
                return "?" + key;
            }
        }
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = String.valueOf(arguments[i]);
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String message = this.getBundle().getString(key);
            new MessageFormat(message).format(arguments, buffer, (FieldPosition)null);
        }
        catch (MissingResourceException e) {
            buffer.append(key);
            buffer.append(" {");
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(arguments[i]);
            }
            buffer.append('}');
        }
        return buffer.toString();
    }

    public boolean contains(String key) {
        try {
            this.getBundle().getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            try {
                Locale locale = Locale.getDefault();
                this.bundle = ResourceBundle.getBundle(this.bundleName, locale);
            }
            catch (MissingResourceException e) {
                this.bundle = NullResourceBundle.instance();
            }
        }
        return this.bundle;
    }
}

