/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.javatools.util.NullResourceBundle;

public class FormatBundle {
    private ClassLoader loader;
    private String bundleName;
    private ResourceBundle bundle = null;

    public FormatBundle(ResourceBundle bundle) {
        this.bundleName = null;
        this.bundle = bundle;
    }

    public FormatBundle(Class type) {
        this.loader = type.getClassLoader();
        this.bundleName = type.getName();
        if (!ResourceBundle.class.isAssignableFrom(type)) {
            this.bundleName = this.bundleName + "Bundle";
        }
    }

    public String get(String key) {
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return "?" + key;
        }
    }

    public String get(String key, Object ... arguments) {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer, key, arguments);
        return buffer.toString();
    }

    public StringBuffer append(StringBuffer buffer, String key, Object ... arguments) {
        if (arguments == null) {
            try {
                buffer.append(this.getBundle().getString(key));
            }
            catch (MissingResourceException e) {
                buffer.append("?").append(key);
            }
        } else {
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = String.valueOf(arguments[i]);
            }
            try {
                String message = this.getBundle().getString(key);
                new MessageFormat(message).format(arguments, buffer, (FieldPosition)null);
            }
            catch (MissingResourceException e) {
                buffer.append(key);
                buffer.append(" {");
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(arguments[i]);
                }
                buffer.append('}');
            }
        }
        return buffer;
    }

    public boolean contains(String key) {
        try {
            this.getBundle().getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            try {
                Locale locale = Locale.getDefault();
                this.bundle = ResourceBundle.getBundle(this.bundleName, locale, this.loader);
            }
            catch (MissingResourceException e) {
                this.bundle = NullResourceBundle.instance();
            }
        }
        return this.bundle;
    }
}

