/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

public class CamelCaseFilter {
    protected final int _inputLength;
    protected final char[] _inputCharArray;
    protected final char[] _uppercases;

    public CamelCaseFilter(String userInput) {
        this._inputCharArray = userInput.toCharArray();
        this._inputLength = userInput.length();
        this._uppercases = new char[this._inputLength];
        for (int i = 0; i < this._inputCharArray.length; ++i) {
            char c = this._inputCharArray[i];
            this._uppercases[i] = Character.toUpperCase(c);
        }
    }

    public boolean matches(String name) {
        int inputLength = this._inputLength;
        int nameLength = name.length();
        if (inputLength > nameLength) {
            return false;
        }
        int inputPos = 0;
        int namePos = 0;
        block0: while (inputPos != inputLength) {
            if (namePos == nameLength) {
                return false;
            }
            char inputChar = this._inputCharArray[inputPos];
            char nameChar = name.charAt(namePos);
            if (inputChar == nameChar) {
                ++inputPos;
                ++namePos;
                continue;
            }
            char upperInput = this._uppercases[inputPos];
            if (upperInput != inputChar) {
                if (upperInput == nameChar) {
                    ++inputPos;
                    ++namePos;
                    continue;
                }
                return false;
            }
            if (upperInput != inputChar) continue;
            if (namePos == 0) {
                return false;
            }
            while (true) {
                if (namePos >= nameLength) continue block0;
                char advanceNameChar = name.charAt(namePos);
                if (advanceNameChar == inputChar) {
                    ++namePos;
                    ++inputPos;
                    continue block0;
                }
                if (Character.isUpperCase(advanceNameChar)) {
                    return false;
                }
                ++namePos;
            }
            break;
        }
        return true;
    }
}

