/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class BundleLoader {
    private static final BundleLoader INSTANCE = new BundleLoader(Locale.getDefault(), System.getProperty("oracle.translated.locales"));
    private final Locale LOCALE;

    public BundleLoader(Locale locale, String inclusionList) {
        this.LOCALE = this.findLocale(locale, inclusionList);
    }

    private Locale findLocale(Locale locale, String inclusionList) {
        int newpos;
        if (inclusionList == null) {
            return locale;
        }
        HashMap<String, String> inclusions = new HashMap<String, String>();
        int pos = 0;
        do {
            String inclusion = (newpos = inclusionList.indexOf(44, pos)) == -1 ? inclusionList.substring(pos) : inclusionList.substring(pos, newpos);
            inclusions.put(inclusion.trim(), "");
            pos = newpos + 1;
        } while (newpos != -1);
        if (inclusions.containsKey(locale.toString())) {
            return locale;
        }
        if (inclusions.containsKey((locale = new Locale(locale.getLanguage(), locale.getCountry())).toString())) {
            return locale;
        }
        if (inclusions.containsKey((locale = new Locale(locale.getLanguage())).toString())) {
            return locale;
        }
        return new Locale("");
    }

    ResourceBundle getBundleImpl(String baseName, ClassLoader loader) {
        return ResourceBundle.getBundle(baseName, this.LOCALE, loader);
    }

    public static final ResourceBundle getBundle(String baseName, ClassLoader loader) {
        return INSTANCE.getBundleImpl(baseName, loader);
    }
}

