/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;

public class PatchIndexFile {
    public static final char separatorChar = '/';
    public static final String separator = "/";
    private final File _directoryFile;
    private final String _path;
    private final File _file;
    private TextBuffer _textBuffer;
    private String _charsetName;

    public PatchIndexFile(File directoryFile, String path) {
        this._directoryFile = directoryFile;
        this._path = path;
        this._file = new File(this._directoryFile, PatchIndexFile.convertToFileSeparators(this._path));
    }

    public void setTextBuffer(TextBuffer textBuffer) {
        this._textBuffer = textBuffer;
    }

    public void setEncoding(String charsetName) {
        this._charsetName = charsetName;
    }

    public File getDirectoryFile() {
        return this._directoryFile;
    }

    public String getPath() {
        return this._path;
    }

    public File getFile() {
        return this._file;
    }

    protected boolean exists() {
        return this._file.exists();
    }

    protected boolean isDirectory() {
        return this._file.isDirectory();
    }

    protected boolean createNewFile() throws IOException {
        return this._file.createNewFile();
    }

    protected TextBuffer getTextBuffer() throws IOException {
        if (this._textBuffer != null) {
            return this._textBuffer;
        }
        this._textBuffer = TextBufferFactory.createTextBuffer();
        if (this._file.exists()) {
            if (this._charsetName != null) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(this._file), this._charsetName);
                    this._textBuffer.read(reader);
                    this.closeReader(reader);
                }
                catch (Throwable throwable) {
                    this.closeReader(reader);
                    throw throwable;
                }
            }
            FileReader reader = null;
            try {
                reader = new FileReader(this._file);
                this._textBuffer.read(reader);
                this.closeReader(reader);
            }
            catch (Throwable throwable) {
                this.closeReader(reader);
                throw throwable;
            }
        }
        return this._textBuffer;
    }

    protected boolean saveTextBuffer() throws IOException {
        if (this._textBuffer == null) {
            throw new IllegalStateException();
        }
        if (!this._file.canWrite() && !this.setReadOnly(false)) {
            return false;
        }
        this._file.getParentFile().mkdirs();
        if (this._charsetName != null) {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this._file), this._charsetName);
                this._textBuffer.write(writer);
                this.closeWriter(writer);
            }
            catch (Throwable throwable) {
                this.closeWriter(writer);
                throw throwable;
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this._file);
            this._textBuffer.write(writer);
            this.closeWriter(writer);
        }
        catch (Throwable throwable) {
            this.closeWriter(writer);
            throw throwable;
        }
        return true;
    }

    protected String getBackupName() {
        return this._file.getName() + ".orig";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createBackup(String backupFileName) throws IOException {
        File backupFile = new File(this._file.getParent(), backupFileName);
        if (backupFile.exists() && !backupFile.delete()) {
            return false;
        }
        if (!this._file.exists()) {
            return backupFile.createNewFile();
        }
        FileChannel sourceChannel = null;
        FileChannel destinationChannel = null;
        try {
            sourceChannel = new FileInputStream(this._file).getChannel();
            destinationChannel = new FileOutputStream(backupFile).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
            this.closeFile(sourceChannel);
            this.closeFile(destinationChannel);
        }
        catch (Throwable throwable) {
            this.closeFile(sourceChannel);
            this.closeFile(destinationChannel);
            throw throwable;
        }
        return true;
    }

    private void closeFile(FileChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean delete() {
        return this._file.delete();
    }

    protected boolean setLastModified(long modTime) {
        return this._file.setLastModified(modTime);
    }

    protected long lastModified() {
        return this._file.lastModified();
    }

    protected boolean setReadOnly(boolean readOnly) {
        return readOnly && this._file.setReadOnly();
    }

    protected String getRevision() {
        return null;
    }

    static final String convertToPatchSeparators(String path) {
        return path.replace(File.separatorChar, '/');
    }

    static final String convertToFileSeparators(String path) {
        return path.replace('/', File.separatorChar);
    }
}

