/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.patch.PatchIndexFile;

public class PatchContributor {
    private final File _directoryFile;
    private final String _argumentFilePath;

    public PatchContributor(File directoryFile) {
        this(directoryFile, null);
    }

    public PatchContributor(File directoryFile, String argumentFilePath) {
        this._directoryFile = directoryFile;
        this._argumentFilePath = argumentFilePath != null ? PatchIndexFile.convertToPatchSeparators(argumentFilePath) : null;
    }

    public File getDirectoryFile() {
        return this._directoryFile;
    }

    public String getArgumentFilePath() {
        return this._argumentFilePath;
    }

    protected String getBaseDirectoryPath() {
        if (this._argumentFilePath == null) {
            return null;
        }
        if (!this.isArgumentDirectory()) {
            return null;
        }
        String directoryPath = this._argumentFilePath;
        while (directoryPath.endsWith("/")) {
            directoryPath = directoryPath.substring(0, directoryPath.length() - 1);
        }
        return directoryPath + "/";
    }

    protected String getFilePath() {
        return !this.isArgumentDirectory() ? this._argumentFilePath : null;
    }

    protected String[] listFilePaths(boolean recursive) {
        if (!this.isArgumentFileExists()) {
            return new String[0];
        }
        if (!this.isArgumentDirectory()) {
            return new String[]{this._argumentFilePath};
        }
        ArrayList filePaths = new ArrayList();
        this.listDirectory(this.createArgumentFile(), filePaths, recursive);
        return filePaths.toArray(new String[0]);
    }

    protected PatchIndexFile constructIndexFile(String path) {
        return this.constructIndexFileImpl(!this.isArgumentDirectory() ? this._directoryFile : this.createArgumentFile(), path);
    }

    protected PatchIndexFile constructIndexFileImpl(File directoryFile, String path) {
        return new PatchIndexFile(directoryFile, path);
    }

    protected boolean isArgumentFileExists() {
        return this.createArgumentFile().exists();
    }

    protected boolean isArgumentDirectory() {
        return this.createArgumentFile().isDirectory();
    }

    private File createArgumentFile() {
        if (this._argumentFilePath == null) {
            return this._directoryFile;
        }
        return new File(this._directoryFile, PatchIndexFile.convertToFileSeparators(this._argumentFilePath));
    }

    private void listDirectory(File directoryFile, Collection filePaths, boolean recursive) {
        File[] contentsFiles = directoryFile.listFiles();
        for (int i = 0; i < contentsFiles.length; ++i) {
            if (contentsFiles[i].isDirectory()) {
                if (!recursive) continue;
                this.listDirectory(contentsFiles[i], filePaths, recursive);
                continue;
            }
            String path = contentsFiles[i].getAbsolutePath().substring(this._directoryFile.getPath().length());
            while (path.startsWith(File.separator)) {
                path = path.substring(1);
            }
            filePaths.add(PatchIndexFile.convertToPatchSeparators(path));
        }
    }
}

