/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.util.AsyncTask;

public class AsyncScheduler {
    private List taskList = new ArrayList();
    private int threadCount = 0;
    private List threadList = new ArrayList();
    private String threadPrefix;
    private int threadId = 1;
    private int idleTimeout;
    private int idleCount = 0;
    private int maxThreads;
    private static final int DEFAULT_MAX_TOTAL_THREADS = 1;
    private static final boolean DEBUG_VERBOSE = false;

    public AsyncScheduler(String runnerPrefix, int idleTimeout) {
        this(runnerPrefix, idleTimeout, 1);
    }

    public AsyncScheduler(String runnerPrefix, int idleTimeout, int maxThreads) {
        this.threadPrefix = runnerPrefix;
        this.idleTimeout = idleTimeout;
        this.maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(AsyncTask task) {
        List list = this.taskList;
        synchronized (list) {
            Thread t;
            this.taskList.add(task);
            int numTasks = this.taskList.size();
            for (int i = this.threadCount - 1; i >= 0; --i) {
                t = (Thread)this.threadList.get(i);
                if (t.isAlive()) continue;
                this.threadList.remove(t);
                --this.threadCount;
            }
            if (this.idleCount > 0) {
                this.taskList.notify();
            } else if (this.threadCount < this.maxThreads) {
                TRunner r = new TRunner();
                t = new Thread(r);
                String name = this.threadPrefix + this.threadId++;
                t.setName(name);
                t.setPriority(1);
                this.threadList.add(t);
                ++this.threadCount;
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(AsyncTask task) {
        List list = this.threadList;
        synchronized (list) {
            this.threadList.remove(task);
        }
        task.requestCancel();
    }

    private class TRunner
    implements Runnable {
        private TRunner() {
        }

        private void printVerbose(String message) {
            String name = Thread.currentThread().getName();
            System.out.print("TRunner(" + name + ") ");
            System.out.println(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                AsyncTask task = null;
                List list = AsyncScheduler.this.taskList;
                synchronized (list) {
                    if (AsyncScheduler.this.taskList.size() == 0) {
                        try {
                            AsyncScheduler.this.idleCount++;
                            AsyncScheduler.this.taskList.wait(AsyncScheduler.this.idleTimeout);
                            AsyncScheduler.this.idleCount--;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (AsyncScheduler.this.taskList.size() == 0) {
                            AsyncScheduler.this.threadCount--;
                            AsyncScheduler.this.threadList.remove(Thread.currentThread());
                            return;
                        }
                    }
                    task = (AsyncTask)AsyncScheduler.this.taskList.remove(0);
                }
                task.run();
            }
        }
    }
}

