/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.PlsqlTreeGenerator;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.RootSymbol;

public class PlsqlParser {
    public static final boolean ERRORS_CHOKE = false;
    public static final boolean ERRORS_REPORT = true;
    public static final int INPUT_PLSQL_FILE = 1;
    public static final int INPUT_EXPR = 2;
    public static final int DEPTH_DECLARATIONS = 1;
    public static final int DEPTH_FULL = 2;

    public static RootSymbol parse(ReadTextBuffer buffer) {
        ParsingOptions defaultOptions = new ParsingOptions();
        return (RootSymbol)PlsqlParser.parse(buffer, defaultOptions);
    }

    public static ErrorReporter parse(ReadTextBuffer buffer, ParsingOptions options) {
        PlsqlTreeGenerator tg = new PlsqlTreeGenerator();
        PlsqlSyntaxRecognizer sr = PlsqlSyntaxRecognizer.newRecognizer(options.inputType, options.parseDepth);
        sr.initialize(buffer, options.startOffset);
        sr.setDebugLevel(options.reportErrors ? 1 : 0);
        tg.initialize(sr);
        try {
            CommonRoot root = tg.generate();
            if (root != null) {
                return root.getRealRoot();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static class ParsingOptions {
        public boolean reportErrors = false;
        public int inputType = 1;
        public int parseDepth = 2;
        public int startOffset = 0;

        public String toString() {
            StringBuffer string = new StringBuffer();
            string.append("ERRORS ");
            if (!this.reportErrors) {
                string.append("choke ");
            } else {
                string.append("report ");
            }
            string.append("INPUT-TYPE ");
            switch (this.inputType) {
                case 1: {
                    string.append("plsql file ");
                    break;
                }
                case 2: {
                    string.append("expression ");
                    break;
                }
                default: {
                    string.append("unknown ");
                }
            }
            string.append("DEPTH ");
            switch (this.parseDepth) {
                case 1: {
                    string.append("decls ");
                    break;
                }
                case 2: {
                    string.append("full ");
                }
            }
            string.append("START-OFFSET ");
            string.append(this.startOffset);
            return string.toString();
        }
    }
}

