/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old;

import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.old.PlsqlTokens;
import oracle.javatools.parser.util.KeywordTable;

public class PlsqlLexer
extends AbstractLexer
implements PlsqlTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipComments = false;
    @CodeSharingSafe(value="StaticField")
    private static final KeywordTable keywordTable = PlsqlLexer.initKeywordTable();
    @CodeSharingSafe(value="StaticField")
    private static final boolean[] identifierPart = PlsqlLexer.initIdentifierPart();

    public PlsqlLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    @Override
    public int lex(LexerToken lexedToken) {
        block60: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.lastToken = 0;
            try {
                block36: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block36;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '+': {
                            this.lastToken = 100;
                            break block36;
                        }
                        case '%': {
                            this.lastToken = 101;
                            break block36;
                        }
                        case ')': {
                            this.lastToken = 105;
                            break block36;
                        }
                        case ',': {
                            this.lastToken = 107;
                            break block36;
                        }
                        case '@': {
                            this.lastToken = 109;
                            break block36;
                        }
                        case ';': {
                            this.lastToken = 110;
                            break block36;
                        }
                        case '(': {
                            this.lastToken = 104;
                            if (this.textBuffer.getChar(this.currentPos) == '+' && this.textBuffer.getChar(this.currentPos + 1) == ')') {
                                this.lastToken = 125;
                                this.currentPos += 2;
                                break block36;
                            }
                            break block60;
                        }
                        case '!': 
                        case '^': 
                        case '~': {
                            this.lastToken = 20;
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = 122;
                                ++this.currentPos;
                                break block36;
                            }
                            break block60;
                        }
                        case '|': {
                            this.lastToken = 20;
                            if (this.textBuffer.getChar(this.currentPos) == '|') {
                                this.lastToken = 114;
                                ++this.currentPos;
                                break block36;
                            }
                            break block60;
                        }
                        case '.': {
                            this.lastToken = 102;
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '.') {
                                this.lastToken = 118;
                                ++this.currentPos;
                                break block36;
                            }
                            if (PlsqlLexer.isDecimalDigit(c)) {
                                this.lastToken = 52;
                                this.skipFloatLiteral();
                                break block36;
                            }
                            break block60;
                        }
                        case '*': {
                            this.lastToken = 108;
                            if (this.textBuffer.getChar(this.currentPos) == '*') {
                                this.lastToken = 115;
                                ++this.currentPos;
                                break block36;
                            }
                            break block60;
                        }
                        case ':': {
                            this.lastToken = 106;
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = 112;
                                ++this.currentPos;
                                break block36;
                            }
                            break block60;
                        }
                        case '=': {
                            this.lastToken = 119;
                            if (this.textBuffer.getChar(this.currentPos) == '>') {
                                this.lastToken = 113;
                                ++this.currentPos;
                                break block36;
                            }
                            break block60;
                        }
                        case '/': {
                            this.lastToken = 103;
                            if (this.textBuffer.getChar(this.currentPos) == '*') {
                                this.lastToken = 82;
                                ++this.currentPos;
                                this.skipMultiLineComment();
                                if (this.skipComments) {
                                    this.lastToken = 0;
                                    continue block36;
                                }
                            }
                            break block60;
                        }
                        case '-': {
                            this.lastToken = 111;
                            if (this.textBuffer.getChar(this.currentPos) == '-') {
                                this.lastToken = 81;
                                ++this.currentPos;
                                this.skipLineComment();
                                if (this.skipComments) {
                                    this.lastToken = 0;
                                    continue block36;
                                }
                            }
                            break block60;
                        }
                        case '>': {
                            this.lastToken = 121;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '>': {
                                    this.lastToken = 117;
                                    ++this.currentPos;
                                    break block36;
                                }
                                case '=': {
                                    this.lastToken = 124;
                                    ++this.currentPos;
                                }
                            }
                            break block36;
                        }
                        case '<': {
                            this.lastToken = 120;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '<': {
                                    this.lastToken = 116;
                                    ++this.currentPos;
                                    break block36;
                                }
                                case '>': {
                                    this.lastToken = 122;
                                    ++this.currentPos;
                                    break block36;
                                }
                                case '=': {
                                    this.lastToken = 123;
                                    ++this.currentPos;
                                }
                            }
                            break block36;
                        }
                        case '\"': {
                            this.lastToken = 11;
                            this.skipQuotedIdentifier();
                            break block36;
                        }
                        case '\'': {
                            this.lastToken = 54;
                            this.skipStringLiteral();
                            break block36;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.lastToken = 51;
                            --this.currentPos;
                            this.skipNumericLiteral();
                            break block36;
                        }
                        default: {
                            int keyword;
                            if (!this.isIdentifierStart(c)) {
                                this.lastToken = 0;
                                continue block36;
                            }
                            this.lastToken = 11;
                            int hash = KeywordTable.computeInsensitivePartialHash(c, 0);
                            while ((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' && identifierPart[c]) {
                                hash = KeywordTable.computeInsensitivePartialHash(c, hash);
                                ++this.currentPos;
                            }
                            if (c >= '\u0100') {
                                while (Character.isJavaIdentifierPart(c = this.textBuffer.getChar(this.currentPos))) {
                                    hash = KeywordTable.computeInsensitivePartialHash(c, hash);
                                    ++this.currentPos;
                                }
                            }
                            if ((keyword = keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, hash)) != -1) {
                                this.lastToken = keyword;
                                break block36;
                            }
                            break block60;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    this.startOffset = this.currentPos;
                } else if (this.lastToken == 11) {
                    int hash = 0;
                    for (int i = this.startOffset; i < this.currentPos; ++i) {
                        char c = this.textBuffer.getChar(i);
                        hash = KeywordTable.computeInsensitivePartialHash(c, hash);
                    }
                    int keyword = keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, hash);
                    if (keyword != -1) {
                        this.lastToken = keyword;
                    }
                }
                if (!this.skipComments || this.lastToken != 81 && this.lastToken != 82) break block60;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    @Override
    public void backup() {
        this.useLastToken = true;
    }

    @Override
    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
    }

    private void skipStringLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\'': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '\'') {
                        return;
                    }
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipQuotedIdentifier() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\"': {
                    return;
                }
            }
        }
    }

    private void skipLineComment() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipMultiLineComment() {
        ++this.currentPos;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '*': {
                    c = this.textBuffer.getChar(this.currentPos + 1);
                    if (c != '/') break;
                    this.currentPos += 2;
                    return;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos - 1);
                    if (c != '*') break;
                    ++this.currentPos;
                    return;
                }
            }
            this.currentPos += 2;
        }
    }

    private void skipNumericLiteral() {
        char c = this.textBuffer.getChar(this.currentPos);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.skipDecimalDigits();
                c = this.textBuffer.getChar(this.currentPos);
                switch (c) {
                    case '.': {
                        this.lastToken = 52;
                        c = this.textBuffer.getChar(this.currentPos + 1);
                        this.lastToken = 51;
                        if (c == '.') break;
                        ++this.currentPos;
                        this.lastToken = 52;
                        this.skipFloatLiteral();
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        this.lastToken = 52;
                        this.skipFloatLiteral();
                    }
                }
                break;
            }
            case '.': {
                ++this.currentPos;
                this.lastToken = 52;
                this.skipFloatLiteral();
            }
        }
    }

    private void skipFloatLiteral() {
        char c = this.textBuffer.getChar(this.currentPos);
        while (PlsqlLexer.isDecimalDigit(c)) {
            ++this.currentPos;
            c = this.textBuffer.getChar(this.currentPos);
        }
        switch (c) {
            case 'E': 
            case 'e': {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
                if (c == '+' || c == '-') {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                while (PlsqlLexer.isDecimalDigit(c)) {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                break;
            }
        }
    }

    private void skipDecimalDigits() {
        char c;
        while (PlsqlLexer.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static boolean isDecimalDigit(char digit) {
        switch (digit) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private static KeywordTable initKeywordTable() {
        KeywordTable table = new KeywordTable(193);
        table.setCaseSensitivity(false);
        table.addKeyword("all", 1000);
        table.addKeyword("alter", 1001);
        table.addKeyword("and", 1002);
        table.addKeyword("any", 1003);
        table.addKeyword("array", 1004);
        table.addKeyword("as", 1005);
        table.addKeyword("asc", 1006);
        table.addKeyword("at", 1007);
        table.addKeyword("authid", 1008);
        table.addKeyword("avg", 1009);
        table.addKeyword("begin", 1010);
        table.addKeyword("between", 1011);
        table.addKeyword("binary_integer", 1012);
        table.addKeyword("body", 1013);
        table.addKeyword("boolean", 1014);
        table.addKeyword("bulk", 1015);
        table.addKeyword("by", 1016);
        table.addKeyword("char", 1017);
        table.addKeyword("char_base", 1018);
        table.addKeyword("check", 1019);
        table.addKeyword("close", 1020);
        table.addKeyword("cluster", 1021);
        table.addKeyword("collect", 1022);
        table.addKeyword("comment", 1023);
        table.addKeyword("commit", 1024);
        table.addKeyword("compress", 1025);
        table.addKeyword("connect", 1026);
        table.addKeyword("constant", 1027);
        table.addKeyword("create", 1028);
        table.addKeyword("current", 1029);
        table.addKeyword("currval", 1030);
        table.addKeyword("cursor", 1031);
        table.addKeyword("date", 1032);
        table.addKeyword("day", 1033);
        table.addKeyword("declare", 1034);
        table.addKeyword("decimal", 1035);
        table.addKeyword("default", 1036);
        table.addKeyword("delete", 1037);
        table.addKeyword("desc", 1038);
        table.addKeyword("distinct", 1039);
        table.addKeyword("do", 1040);
        table.addKeyword("drop", 1041);
        table.addKeyword("else", 1042);
        table.addKeyword("elsif", 1043);
        table.addKeyword("end", 1044);
        table.addKeyword("exception", 1045);
        table.addKeyword("exclusive", 1046);
        table.addKeyword("execute", 1047);
        table.addKeyword("exists", 1048);
        table.addKeyword("exit", 1049);
        table.addKeyword("extends", 1050);
        table.addKeyword("false", 53);
        table.addKeyword("fetch", 1052);
        table.addKeyword("float", 1053);
        table.addKeyword("for", 1054);
        table.addKeyword("forall", 1055);
        table.addKeyword("from", 1056);
        table.addKeyword("function", 1057);
        table.addKeyword("goto", 1058);
        table.addKeyword("group", 1059);
        table.addKeyword("having", 1060);
        table.addKeyword("heap", 1061);
        table.addKeyword("hour", 1062);
        table.addKeyword("if", 1063);
        table.addKeyword("immediate", 1064);
        table.addKeyword("in", 1065);
        table.addKeyword("index", 1066);
        table.addKeyword("indicator", 1067);
        table.addKeyword("insert", 1068);
        table.addKeyword("integer", 1069);
        table.addKeyword("interface", 1070);
        table.addKeyword("intersect", 1071);
        table.addKeyword("interval", 1072);
        table.addKeyword("into", 1073);
        table.addKeyword("is", 1074);
        table.addKeyword("isolation", 1075);
        table.addKeyword("java", 1076);
        table.addKeyword("level", 1077);
        table.addKeyword("like", 1078);
        table.addKeyword("limited", 1079);
        table.addKeyword("lock", 1080);
        table.addKeyword("long", 1081);
        table.addKeyword("loop", 1082);
        table.addKeyword("max", 1083);
        table.addKeyword("min", 1084);
        table.addKeyword("minus", 1085);
        table.addKeyword("minute", 1086);
        table.addKeyword("mlslabel", 1087);
        table.addKeyword("mod", 1088);
        table.addKeyword("mode", 1089);
        table.addKeyword("month", 1090);
        table.addKeyword("natural", 1091);
        table.addKeyword("naturaln", 1092);
        table.addKeyword("new", 1093);
        table.addKeyword("nextval", 1094);
        table.addKeyword("nocopy", 1095);
        table.addKeyword("not", 1096);
        table.addKeyword("nowait", 1097);
        table.addKeyword("null", 55);
        table.addKeyword("number", 1099);
        table.addKeyword("number_base", 1100);
        table.addKeyword("ocirowid", 1101);
        table.addKeyword("of", 1102);
        table.addKeyword("on", 1103);
        table.addKeyword("opaque", 1104);
        table.addKeyword("open", 1105);
        table.addKeyword("operator", 1106);
        table.addKeyword("option", 1107);
        table.addKeyword("or", 1108);
        table.addKeyword("order", 1109);
        table.addKeyword("organization", 1110);
        table.addKeyword("others", 1111);
        table.addKeyword("out", 1112);
        table.addKeyword("package", 1113);
        table.addKeyword("partition", 1114);
        table.addKeyword("pctfree", 1115);
        table.addKeyword("pls_integer", 1116);
        table.addKeyword("positive", 1117);
        table.addKeyword("positiven", 1118);
        table.addKeyword("pragma", 1119);
        table.addKeyword("prior", 1120);
        table.addKeyword("private", 1121);
        table.addKeyword("procedure", 1122);
        table.addKeyword("public", 1123);
        table.addKeyword("raise", 1124);
        table.addKeyword("range", 1125);
        table.addKeyword("raw", 1126);
        table.addKeyword("real", 1127);
        table.addKeyword("record", 1128);
        table.addKeyword("ref", 1129);
        table.addKeyword("release", 1130);
        table.addKeyword("return", 1131);
        table.addKeyword("reverse", 1132);
        table.addKeyword("rollback", 1133);
        table.addKeyword("row", 1134);
        table.addKeyword("rowid", 1135);
        table.addKeyword("rownum", 1136);
        table.addKeyword("rowtype", 1137);
        table.addKeyword("savepoint", 1138);
        table.addKeyword("second", 1139);
        table.addKeyword("select", 1140);
        table.addKeyword("separate", 1141);
        table.addKeyword("set", 1142);
        table.addKeyword("share", 1143);
        table.addKeyword("smallint", 1144);
        table.addKeyword("space", 1145);
        table.addKeyword("sql", 1146);
        table.addKeyword("sqlcode", 1147);
        table.addKeyword("sqlerrm", 1148);
        table.addKeyword("start", 1149);
        table.addKeyword("stddev", 1150);
        table.addKeyword("subtype", 1151);
        table.addKeyword("successful", 1152);
        table.addKeyword("sum", 1153);
        table.addKeyword("synonym", 1154);
        table.addKeyword("sysdate", 1155);
        table.addKeyword("table", 1156);
        table.addKeyword("then", 1157);
        table.addKeyword("time", 1158);
        table.addKeyword("timestamp", 1159);
        table.addKeyword("to", 1160);
        table.addKeyword("trigger", 1161);
        table.addKeyword("true", 53);
        table.addKeyword("type", 1163);
        table.addKeyword("uid", 1164);
        table.addKeyword("union", 1165);
        table.addKeyword("unique", 1166);
        table.addKeyword("update", 1167);
        table.addKeyword("use", 1168);
        table.addKeyword("user", 1169);
        table.addKeyword("validate", 1170);
        table.addKeyword("values", 1171);
        table.addKeyword("varchar", 1172);
        table.addKeyword("varchar2", 1173);
        table.addKeyword("variance", 1174);
        table.addKeyword("view", 1175);
        table.addKeyword("when", 1176);
        table.addKeyword("whenever", 1177);
        table.addKeyword("where", 1178);
        table.addKeyword("while", 1179);
        table.addKeyword("with", 1180);
        table.addKeyword("work", 1181);
        table.addKeyword("write", 1182);
        table.addKeyword("year", 1183);
        table.addKeyword("zone", 1184);
        table.addKeyword("nchar", 1204);
        table.addKeyword("clob", 1202);
        table.addKeyword("nclob", 1205);
        table.addKeyword("blob", 1201);
        table.addKeyword("bfile", 1200);
        table.addKeyword("numeric", 1206);
        table.addKeyword("dec", 1203);
        table.addKeyword("nvarchar2", 1207);
        table.addKeyword("case", 1300);
        table.addKeyword("coalesce", 1301);
        table.addKeyword("nullif", 1302);
        table.addKeyword("timezone_abbr", 1303);
        table.addKeyword("timezone_hour", 1304);
        table.addKeyword("timezone_minute", 1305);
        table.addKeyword("timezone_region", 1306);
        table.addKeyword("extract", 1350);
        return table;
    }

    private static boolean[] initIdentifierPart() {
        boolean[] table = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = Character.isJavaIdentifierPart((char)i);
        }
        table[35] = true;
        return table;
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 11: {
                return "TK_IDENTIFIER";
            }
            case 12: {
                return "TK_QUOTED_IDENTIFIER";
            }
            case 51: {
                return "TK_INT_LITERAL";
            }
            case 52: {
                return "TK_FLOAT_LITERAL";
            }
            case 53: {
                return "TK_BOOLEAN_LITERAL";
            }
            case 54: {
                return "TK_CHAR_LITERAL";
            }
            case 81: {
                return "TK_SINGLE_COMMENT";
            }
            case 82: {
                return "TK_MULTI_COMMENT";
            }
            case 100: {
                return "TK_PLUS";
            }
            case 101: {
                return "TK_ATTRIBUTE";
            }
            case 102: {
                return "TK_DOT";
            }
            case 103: {
                return "TK_DIV";
            }
            case 104: {
                return "TK_LPAREN";
            }
            case 105: {
                return "TK_RPAREN";
            }
            case 106: {
                return "TK_COLON";
            }
            case 107: {
                return "TK_COMMA";
            }
            case 108: {
                return "TK_MUL";
            }
            case 109: {
                return "TK_AT";
            }
            case 110: {
                return "TK_SEMI";
            }
            case 111: {
                return "TK_MINUS";
            }
            case 112: {
                return "TK_ASG";
            }
            case 113: {
                return "TK_ASSOC";
            }
            case 114: {
                return "TK_CONCAT";
            }
            case 115: {
                return "TK_EXPONENT";
            }
            case 116: {
                return "TK_LLABEL";
            }
            case 117: {
                return "TK_RLABEL";
            }
            case 118: {
                return "TK_RANGE";
            }
            case 119: {
                return "TK_EQ";
            }
            case 120: {
                return "TK_LT";
            }
            case 121: {
                return "TK_GT";
            }
            case 122: {
                return "TK_NE";
            }
            case 123: {
                return "TK_LE";
            }
            case 124: {
                return "TK_GE";
            }
            case 125: {
                return "TK_OUTERJOIN";
            }
            case 1000: {
                return "TKKW_ALL";
            }
            case 1001: {
                return "TKKW_ALTER";
            }
            case 1002: {
                return "TKKW_AND";
            }
            case 1003: {
                return "TKKW_ANY";
            }
            case 1004: {
                return "TKKW_ARRAY";
            }
            case 1005: {
                return "TKKW_AS";
            }
            case 1006: {
                return "TKKW_ASC";
            }
            case 1007: {
                return "TKKW_AT";
            }
            case 1008: {
                return "TKKW_AUTHID";
            }
            case 1009: {
                return "TKKW_AVG";
            }
            case 1010: {
                return "TKKW_BEGIN";
            }
            case 1011: {
                return "TKKW_BETWEEN";
            }
            case 1012: {
                return "TKKW_BINARY_INTEGER";
            }
            case 1013: {
                return "TKKW_BODY";
            }
            case 1014: {
                return "TKKW_BOOLEAN";
            }
            case 1015: {
                return "TKKW_BULK";
            }
            case 1016: {
                return "TKKW_BY";
            }
            case 1017: {
                return "TKKW_CHAR";
            }
            case 1018: {
                return "TKKW_CHAR_BASE";
            }
            case 1019: {
                return "TKKW_CHECK";
            }
            case 1020: {
                return "TKKW_CLOSE";
            }
            case 1021: {
                return "TKKW_CLUSTER";
            }
            case 1022: {
                return "TKKW_COLLECT";
            }
            case 1023: {
                return "TKKW_COMMENT";
            }
            case 1024: {
                return "TKKW_COMMIT";
            }
            case 1025: {
                return "TKKW_COMPRESS";
            }
            case 1026: {
                return "TKKW_CONNECT";
            }
            case 1027: {
                return "TKKW_CONSTANT";
            }
            case 1028: {
                return "TKKW_CREATE";
            }
            case 1029: {
                return "TKKW_CURRENT";
            }
            case 1030: {
                return "TKKW_CURRVAL";
            }
            case 1031: {
                return "TKKW_CURSOR";
            }
            case 1032: {
                return "TKKW_DATE";
            }
            case 1033: {
                return "TKKW_DAY";
            }
            case 1034: {
                return "TKKW_DECLARE";
            }
            case 1035: {
                return "TKKW_DECIMAL";
            }
            case 1036: {
                return "TKKW_DEFAULT";
            }
            case 1037: {
                return "TKKW_DELETE";
            }
            case 1038: {
                return "TKKW_DESC";
            }
            case 1039: {
                return "TKKW_DISTINCT";
            }
            case 1040: {
                return "TKKW_DO";
            }
            case 1041: {
                return "TKKW_DROP";
            }
            case 1042: {
                return "TKKW_ELSE";
            }
            case 1043: {
                return "TKKW_ELSIF";
            }
            case 1044: {
                return "TKKW_END";
            }
            case 1045: {
                return "TKKW_EXCEPTION";
            }
            case 1046: {
                return "TKKW_EXCLUSIVE";
            }
            case 1047: {
                return "TKKW_EXECUTE";
            }
            case 1048: {
                return "TKKW_EXISTS";
            }
            case 1049: {
                return "TKKW_EXIT";
            }
            case 1050: {
                return "TKKW_EXTENDS";
            }
            case 1051: {
                return "TKKW_FALSE";
            }
            case 1052: {
                return "TKKW_FETCH";
            }
            case 1053: {
                return "TKKW_FLOAT";
            }
            case 1054: {
                return "TKKW_FOR";
            }
            case 1055: {
                return "TKKW_FORALL";
            }
            case 1056: {
                return "TKKW_FROM";
            }
            case 1057: {
                return "TKKW_FUNCTION";
            }
            case 1058: {
                return "TKKW_GOTO";
            }
            case 1059: {
                return "TKKW_GROUP";
            }
            case 1060: {
                return "TKKW_HAVING";
            }
            case 1061: {
                return "TKKW_HEAP";
            }
            case 1062: {
                return "TKKW_HOUR";
            }
            case 1063: {
                return "TKKW_IF";
            }
            case 1064: {
                return "TKKW_IMMEDIATE";
            }
            case 1065: {
                return "TKKW_IN";
            }
            case 1066: {
                return "TKKW_INDEX";
            }
            case 1067: {
                return "TKKW_INDICATOR";
            }
            case 1068: {
                return "TKKW_INSERT";
            }
            case 1069: {
                return "TKKW_INTEGER";
            }
            case 1070: {
                return "TKKW_INTERFACE";
            }
            case 1071: {
                return "TKKW_INTERSECT";
            }
            case 1072: {
                return "TKKW_INTERVAL";
            }
            case 1073: {
                return "TKKW_INTO";
            }
            case 1074: {
                return "TKKW_IS";
            }
            case 1075: {
                return "TKKW_ISOLATION";
            }
            case 1076: {
                return "TKKW_JAVA";
            }
            case 1077: {
                return "TKKW_LEVEL";
            }
            case 1078: {
                return "TKKW_LIKE";
            }
            case 1079: {
                return "TKKW_LIMITED";
            }
            case 1080: {
                return "TKKW_LOCK";
            }
            case 1081: {
                return "TKKW_LONG";
            }
            case 1082: {
                return "TKKW_LOOP";
            }
            case 1083: {
                return "TKKW_MAX";
            }
            case 1084: {
                return "TKKW_MIN";
            }
            case 1085: {
                return "TKKW_MINUS";
            }
            case 1086: {
                return "TKKW_MINUTE";
            }
            case 1087: {
                return "TKKW_MLSLABEL";
            }
            case 1088: {
                return "TKKW_MOD";
            }
            case 1089: {
                return "TKKW_MODE";
            }
            case 1090: {
                return "TKKW_MONTH";
            }
            case 1091: {
                return "TKKW_NATURAL";
            }
            case 1092: {
                return "TKKW_NATURALN";
            }
            case 1093: {
                return "TKKW_NEW";
            }
            case 1094: {
                return "TKKW_NEXTVAL";
            }
            case 1095: {
                return "TKKW_NOCOPY";
            }
            case 1096: {
                return "TKKW_NOT";
            }
            case 1097: {
                return "TKKW_NOWAIT";
            }
            case 55: {
                return "TKKW_NULL";
            }
            case 1099: {
                return "TKKW_NUMBER";
            }
            case 1100: {
                return "TKKW_NUMBER_BASE";
            }
            case 1101: {
                return "TKKW_OCIROWID";
            }
            case 1102: {
                return "TKKW_OF";
            }
            case 1103: {
                return "TKKW_ON";
            }
            case 1104: {
                return "TKKW_OPAQUE";
            }
            case 1105: {
                return "TKKW_OPEN";
            }
            case 1106: {
                return "TKKW_OPERATOR";
            }
            case 1107: {
                return "TKKW_OPTION";
            }
            case 1108: {
                return "TKKW_OR";
            }
            case 1109: {
                return "TKKW_ORDER";
            }
            case 1110: {
                return "TKKW_ORGANIZATION";
            }
            case 1111: {
                return "TKKW_OTHERS";
            }
            case 1112: {
                return "TKKW_OUT";
            }
            case 1113: {
                return "TKKW_PACKAGE";
            }
            case 1114: {
                return "TKKW_PARTITION";
            }
            case 1115: {
                return "TKKW_PCTFREE";
            }
            case 1116: {
                return "TKKW_PLS_INTEGER";
            }
            case 1117: {
                return "TKKW_POSITIVE";
            }
            case 1118: {
                return "TKKW_POSITIVEN";
            }
            case 1119: {
                return "TKKW_PRAGMA";
            }
            case 1120: {
                return "TKKW_PRIOR";
            }
            case 1121: {
                return "TKKW_PRIVATE";
            }
            case 1122: {
                return "TKKW_PROCEDURE";
            }
            case 1123: {
                return "TKKW_PUBLIC";
            }
            case 1124: {
                return "TKKW_RAISE";
            }
            case 1125: {
                return "TKKW_RANGE";
            }
            case 1126: {
                return "TKKW_RAW";
            }
            case 1127: {
                return "TKKW_REAL";
            }
            case 1128: {
                return "TKKW_RECORD";
            }
            case 1129: {
                return "TKKW_REF";
            }
            case 1130: {
                return "TKKW_RELEASE";
            }
            case 1131: {
                return "TKKW_RETURN";
            }
            case 1132: {
                return "TKKW_REVERSE";
            }
            case 1133: {
                return "TKKW_ROLLBACK";
            }
            case 1134: {
                return "TKKW_ROW";
            }
            case 1135: {
                return "TKKW_ROWID";
            }
            case 1136: {
                return "TKKW_ROWNUM";
            }
            case 1137: {
                return "TKKW_ROWTYPE";
            }
            case 1138: {
                return "TKKW_SAVEPOINT";
            }
            case 1139: {
                return "TKKW_SECOND";
            }
            case 1140: {
                return "TKKW_SELECT";
            }
            case 1141: {
                return "TKKW_SEPARATE";
            }
            case 1142: {
                return "TKKW_SET";
            }
            case 1143: {
                return "TKKW_SHARE";
            }
            case 1144: {
                return "TKKW_SMALLINT";
            }
            case 1145: {
                return "TKKW_SPACE";
            }
            case 1146: {
                return "TKKW_SQL";
            }
            case 1147: {
                return "TKKW_SQLCODE";
            }
            case 1148: {
                return "TKKW_SQLERRM";
            }
            case 1149: {
                return "TKKW_START";
            }
            case 1150: {
                return "TKKW_STDDEV";
            }
            case 1151: {
                return "TKKW_SUBTYPE";
            }
            case 1152: {
                return "TKKW_SUCCESSFUL";
            }
            case 1153: {
                return "TKKW_SUM";
            }
            case 1154: {
                return "TKKW_SYNONYM";
            }
            case 1155: {
                return "TKKW_SYSDATE";
            }
            case 1156: {
                return "TKKW_TABLE";
            }
            case 1157: {
                return "TKKW_THEN";
            }
            case 1158: {
                return "TKKW_TIME";
            }
            case 1159: {
                return "TKKW_TIMESTAMP";
            }
            case 1160: {
                return "TKKW_TO";
            }
            case 1161: {
                return "TKKW_TRIGGER";
            }
            case 1162: {
                return "TKKW_TRUE";
            }
            case 1163: {
                return "TKKW_TYPE";
            }
            case 1164: {
                return "TKKW_UID";
            }
            case 1165: {
                return "TKKW_UNION";
            }
            case 1166: {
                return "TKKW_UNIQUE";
            }
            case 1167: {
                return "TKKW_UPDATE";
            }
            case 1168: {
                return "TKKW_USE";
            }
            case 1169: {
                return "TKKW_USER";
            }
            case 1170: {
                return "TKKW_VALIDATE";
            }
            case 1171: {
                return "TKKW_VALUES";
            }
            case 1172: {
                return "TKKW_VARCHAR";
            }
            case 1173: {
                return "TKKW_VARCHAR2";
            }
            case 1174: {
                return "TKKW_VARIANCE";
            }
            case 1175: {
                return "TKKW_VIEW";
            }
            case 1176: {
                return "TKKW_WHEN";
            }
            case 1177: {
                return "TKKW_WHENEVER";
            }
            case 1178: {
                return "TKKW_WHERE";
            }
            case 1179: {
                return "TKKW_WHILE";
            }
            case 1180: {
                return "TKKW_WITH";
            }
            case 1181: {
                return "TKKW_WORK";
            }
            case 1182: {
                return "TKKW_WRITE";
            }
            case 1183: {
                return "TKKW_YEAR";
            }
            case 1184: {
                return "TKKW_ZONE";
            }
            case 1204: {
                return "TKKW_NCHAR";
            }
            case 1202: {
                return "TKKW_CLOB";
            }
            case 1205: {
                return "TKKW_NCLOB";
            }
            case 1201: {
                return "TKKW_BLOB";
            }
            case 1200: {
                return "TKKW_BFILE";
            }
            case 1206: {
                return "TKKW_NUMERIC";
            }
            case 1203: {
                return "TKKW_DEC";
            }
            case 1207: {
                return "TKKW_NVARCHAR2";
            }
            case 1300: {
                return "TKKW_CASE";
            }
            case 1301: {
                return "TKKW_COALESCE";
            }
            case 1302: {
                return "TKKW_NULLIF";
            }
            case 1303: {
                return "TKKW_TIMEZONE_ABBR";
            }
            case 1304: {
                return "TKKW_TIMEZONE_HOUR";
            }
            case 1305: {
                return "TKKW_TIMEZONE_MINUTE";
            }
            case 1306: {
                return "TKKW_TIMEZONE_REGION";
            }
            case 1350: {
                return "TKKW_EXTRACT";
            }
        }
        return "**UNKNOWN (" + token + ")**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 11: {
                return "identifier";
            }
            case 12: {
                return "quoted_identifier";
            }
            case 51: {
                return "int_literal";
            }
            case 52: {
                return "float_literal";
            }
            case 53: {
                return "boolean_literal";
            }
            case 54: {
                return "char_literal";
            }
            case 81: {
                return "single_comment";
            }
            case 82: {
                return "multi_comment";
            }
            case 100: {
                return "+";
            }
            case 101: {
                return "%";
            }
            case 102: {
                return ".";
            }
            case 103: {
                return "/";
            }
            case 104: {
                return "(";
            }
            case 105: {
                return ")";
            }
            case 106: {
                return ":";
            }
            case 107: {
                return ",";
            }
            case 108: {
                return "*";
            }
            case 109: {
                return "@";
            }
            case 110: {
                return ";";
            }
            case 111: {
                return "-";
            }
            case 112: {
                return ":=";
            }
            case 113: {
                return "=>";
            }
            case 114: {
                return "||";
            }
            case 115: {
                return "**";
            }
            case 116: {
                return "<<";
            }
            case 117: {
                return ">>";
            }
            case 118: {
                return "..";
            }
            case 119: {
                return "=";
            }
            case 120: {
                return "<";
            }
            case 121: {
                return ">";
            }
            case 122: {
                return "!=";
            }
            case 123: {
                return "<=";
            }
            case 124: {
                return ">=";
            }
            case 125: {
                return "(+)";
            }
            case 1000: {
                return "all";
            }
            case 1001: {
                return "alter";
            }
            case 1002: {
                return "and";
            }
            case 1003: {
                return "any";
            }
            case 1004: {
                return "array";
            }
            case 1005: {
                return "as";
            }
            case 1006: {
                return "asc";
            }
            case 1007: {
                return "at";
            }
            case 1008: {
                return "authid";
            }
            case 1009: {
                return "avg";
            }
            case 1010: {
                return "begin";
            }
            case 1011: {
                return "between";
            }
            case 1012: {
                return "binary_integer";
            }
            case 1013: {
                return "body";
            }
            case 1014: {
                return "boolean";
            }
            case 1015: {
                return "bulk";
            }
            case 1016: {
                return "by";
            }
            case 1017: {
                return "char";
            }
            case 1018: {
                return "char_base";
            }
            case 1019: {
                return "check";
            }
            case 1020: {
                return "close";
            }
            case 1021: {
                return "cluster";
            }
            case 1022: {
                return "collect";
            }
            case 1023: {
                return "comment";
            }
            case 1024: {
                return "commit";
            }
            case 1025: {
                return "compress";
            }
            case 1026: {
                return "connect";
            }
            case 1027: {
                return "constant";
            }
            case 1028: {
                return "create";
            }
            case 1029: {
                return "current";
            }
            case 1030: {
                return "currval";
            }
            case 1031: {
                return "cursor";
            }
            case 1032: {
                return "date";
            }
            case 1033: {
                return "day";
            }
            case 1034: {
                return "declare";
            }
            case 1035: {
                return "decimal";
            }
            case 1036: {
                return "default";
            }
            case 1037: {
                return "delete";
            }
            case 1038: {
                return "desc";
            }
            case 1039: {
                return "distinct";
            }
            case 1040: {
                return "do";
            }
            case 1041: {
                return "drop";
            }
            case 1042: {
                return "else";
            }
            case 1043: {
                return "elsif";
            }
            case 1044: {
                return "end";
            }
            case 1045: {
                return "exception";
            }
            case 1046: {
                return "exclusive";
            }
            case 1047: {
                return "execute";
            }
            case 1048: {
                return "exists";
            }
            case 1049: {
                return "exit";
            }
            case 1050: {
                return "extends";
            }
            case 1051: {
                return "false";
            }
            case 1052: {
                return "fetch";
            }
            case 1053: {
                return "float";
            }
            case 1054: {
                return "for";
            }
            case 1055: {
                return "forall";
            }
            case 1056: {
                return "from";
            }
            case 1057: {
                return "function";
            }
            case 1058: {
                return "goto";
            }
            case 1059: {
                return "group";
            }
            case 1060: {
                return "having";
            }
            case 1061: {
                return "heap";
            }
            case 1062: {
                return "hour";
            }
            case 1063: {
                return "if";
            }
            case 1064: {
                return "immediate";
            }
            case 1065: {
                return "in";
            }
            case 1066: {
                return "index";
            }
            case 1067: {
                return "indicator";
            }
            case 1068: {
                return "insert";
            }
            case 1069: {
                return "integer";
            }
            case 1070: {
                return "interface";
            }
            case 1071: {
                return "intersect";
            }
            case 1072: {
                return "interval";
            }
            case 1073: {
                return "into";
            }
            case 1074: {
                return "is";
            }
            case 1075: {
                return "isolation";
            }
            case 1076: {
                return "java";
            }
            case 1077: {
                return "level";
            }
            case 1078: {
                return "like";
            }
            case 1079: {
                return "limited";
            }
            case 1080: {
                return "lock";
            }
            case 1081: {
                return "long";
            }
            case 1082: {
                return "loop";
            }
            case 1083: {
                return "max";
            }
            case 1084: {
                return "min";
            }
            case 1085: {
                return "minus";
            }
            case 1086: {
                return "minute";
            }
            case 1087: {
                return "mlslabel";
            }
            case 1088: {
                return "mod";
            }
            case 1089: {
                return "mode";
            }
            case 1090: {
                return "month";
            }
            case 1091: {
                return "natural";
            }
            case 1092: {
                return "naturaln";
            }
            case 1093: {
                return "new";
            }
            case 1094: {
                return "nextval";
            }
            case 1095: {
                return "nocopy";
            }
            case 1096: {
                return "not";
            }
            case 1097: {
                return "nowait";
            }
            case 55: {
                return "null";
            }
            case 1099: {
                return "number";
            }
            case 1100: {
                return "number_base";
            }
            case 1101: {
                return "ocirowid";
            }
            case 1102: {
                return "of";
            }
            case 1103: {
                return "on";
            }
            case 1104: {
                return "opaque";
            }
            case 1105: {
                return "open";
            }
            case 1106: {
                return "operator";
            }
            case 1107: {
                return "option";
            }
            case 1108: {
                return "or";
            }
            case 1109: {
                return "order";
            }
            case 1110: {
                return "organization";
            }
            case 1111: {
                return "others";
            }
            case 1112: {
                return "out";
            }
            case 1113: {
                return "package";
            }
            case 1114: {
                return "partition";
            }
            case 1115: {
                return "pctfree";
            }
            case 1116: {
                return "pls_INTEGER";
            }
            case 1117: {
                return "positive";
            }
            case 1118: {
                return "positiven";
            }
            case 1119: {
                return "pragma";
            }
            case 1120: {
                return "prior";
            }
            case 1121: {
                return "private";
            }
            case 1122: {
                return "procedure";
            }
            case 1123: {
                return "public";
            }
            case 1124: {
                return "raise";
            }
            case 1125: {
                return "range";
            }
            case 1126: {
                return "raw";
            }
            case 1127: {
                return "real";
            }
            case 1128: {
                return "record";
            }
            case 1129: {
                return "ref";
            }
            case 1130: {
                return "release";
            }
            case 1131: {
                return "return";
            }
            case 1132: {
                return "reverse";
            }
            case 1133: {
                return "rollback";
            }
            case 1134: {
                return "row";
            }
            case 1135: {
                return "rowid";
            }
            case 1136: {
                return "rownum";
            }
            case 1137: {
                return "rowtype";
            }
            case 1138: {
                return "savepoint";
            }
            case 1139: {
                return "second";
            }
            case 1140: {
                return "select";
            }
            case 1141: {
                return "separate";
            }
            case 1142: {
                return "set";
            }
            case 1143: {
                return "share";
            }
            case 1144: {
                return "smallint";
            }
            case 1145: {
                return "space";
            }
            case 1146: {
                return "sql";
            }
            case 1147: {
                return "sqlcode";
            }
            case 1148: {
                return "sqlerrm";
            }
            case 1149: {
                return "start";
            }
            case 1150: {
                return "stddev";
            }
            case 1151: {
                return "subtype";
            }
            case 1152: {
                return "successful";
            }
            case 1153: {
                return "sum";
            }
            case 1154: {
                return "synonym";
            }
            case 1155: {
                return "sysdate";
            }
            case 1156: {
                return "table";
            }
            case 1157: {
                return "then";
            }
            case 1158: {
                return "time";
            }
            case 1159: {
                return "timestamp";
            }
            case 1160: {
                return "to";
            }
            case 1161: {
                return "trigger";
            }
            case 1162: {
                return "true";
            }
            case 1163: {
                return "type";
            }
            case 1164: {
                return "uid";
            }
            case 1165: {
                return "union";
            }
            case 1166: {
                return "unique";
            }
            case 1167: {
                return "update";
            }
            case 1168: {
                return "use";
            }
            case 1169: {
                return "user";
            }
            case 1170: {
                return "validate";
            }
            case 1171: {
                return "values";
            }
            case 1172: {
                return "varchar";
            }
            case 1173: {
                return "varchar2";
            }
            case 1174: {
                return "variance";
            }
            case 1175: {
                return "view";
            }
            case 1176: {
                return "when";
            }
            case 1177: {
                return "whenever";
            }
            case 1178: {
                return "where";
            }
            case 1179: {
                return "while";
            }
            case 1180: {
                return "with";
            }
            case 1181: {
                return "work";
            }
            case 1182: {
                return "write";
            }
            case 1183: {
                return "year";
            }
            case 1184: {
                return "zone";
            }
            case 1204: {
                return "nchar";
            }
            case 1202: {
                return "clob";
            }
            case 1205: {
                return "nclob";
            }
            case 1201: {
                return "blob";
            }
            case 1200: {
                return "bfile";
            }
            case 1206: {
                return "numeric";
            }
            case 1203: {
                return "dec";
            }
            case 1207: {
                return "nvarchar2";
            }
            case 1300: {
                return "case";
            }
            case 1301: {
                return "coalesce";
            }
            case 1302: {
                return "nullif";
            }
            case 1303: {
                return "timezone_abbr";
            }
            case 1304: {
                return "timezone_hour";
            }
            case 1305: {
                return "timezone_minute";
            }
            case 1306: {
                return "timezone_region";
            }
            case 1350: {
                return "extract";
            }
        }
        return "**UNKNOWN**";
    }

    private boolean isIdentifierStart(char c) {
        return Character.isLetter(c);
    }
}

