/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

public class OffsetPair {
    private int selectionStartOffset;
    private int selectionLength;

    public static OffsetPair createFromStartAndLength(int start, int length) {
        return new OffsetPair(start, length);
    }

    public static OffsetPair createFromStartAndEnd(int start, int end) {
        return OffsetPair.createFromStartAndLength(start, end - start);
    }

    protected OffsetPair(int start, int length) {
        if (start < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        this.selectionStartOffset = start;
        this.selectionLength = length;
    }

    public final int getStartOffset() {
        return this.selectionStartOffset;
    }

    public final int getEndOffset() {
        return this.selectionStartOffset + this.selectionLength;
    }

    public final int getLength() {
        return this.selectionLength;
    }

    public final void setStartAndLength(int start, int length) {
        if (start < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        this.selectionStartOffset = start;
        this.selectionLength = length;
    }

    public final void setStartAndEnd(int start, int end) {
        this.setStartAndLength(start, end - start);
    }
}

