/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModifierSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceModifier;
import oracle.javatools.parser.java.v2.model.SourceModuleRequires;

public class ModuleRequiresSym
extends TreeSym
implements SourceModuleRequires {
    public boolean equals(Object o) {
        if (o instanceof ModuleRequiresSym) {
            ModuleRequiresSym other = (ModuleRequiresSym)o;
            return this.getModifiers() == other.getModifiers() && this.getName().equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getModifiers() * 31 + this.getName().hashCode();
    }

    @Override
    public int getElementKind() {
        return 14;
    }

    @Override
    public boolean isTransitive() {
        return (this.getModifiers() & 0x20) != 0;
    }

    @Override
    public boolean isStaticPhase() {
        return (this.getModifiers() & 0x40) != 0;
    }

    @Override
    public String getModuleName() {
        return this.getName();
    }

    @Override
    public void setTransitive(boolean isTransitive) {
        int modifiers = this.getModifiers();
        if (isTransitive) {
            modifiers |= 0x20;
            this.addModifier(' ');
        } else {
            modifiers &= 0xFFFFFFDF;
            this.removeModifier(' ');
        }
        this.setModifiers(modifiers);
    }

    @Override
    public void setStaticPhase(boolean isStaticPhase) {
        int modifiers = this.getModifiers();
        if (isStaticPhase) {
            modifiers |= 0x40;
            this.addModifier('@');
        } else {
            modifiers &= 0xFFFFFFBF;
            this.removeModifier('@');
        }
        this.setModifiers(modifiers);
    }

    private void addModifier(char access) {
        SourceFactory factory = this.getOwningSourceFile().getFactory();
        SourceModifier modifier = factory.createModifier(access);
        modifier.addSelf(this);
    }

    private void removeModifier(char access) {
        List modifiers = this.getChildrenList(43);
        Iterator iter = modifiers.iterator();
        while (iter.hasNext()) {
            SourceModifier modifier = (SourceModifier)iter.next();
            if (modifier.getModifier() != access) continue;
            iter.remove();
            break;
        }
    }

    @Override
    protected boolean isValidAccess(char access) {
        int allowed = 96;
        return super.isValidAccess((char)(access & 0xFFFFFF9F));
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 20: 
            case 42: 
            case 43: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        switch (added.symKind) {
            case 43: {
                this.setModifiers(this.getModifiers() | ((ModifierSym)added).getModifier());
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        super.unlinkChildTrigger(removed, filter);
        switch (removed.symKind) {
            case 43: {
                int modifiers = this.getModifiers();
                this.setModifiers(modifiers &= ~((ModifierSym)removed).getModifier());
                break;
            }
        }
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 43: {
                int lastModifier = this.lastIndexOf((byte)43);
                if (lastModifier != -1) {
                    return lastModifier + 1;
                }
                return 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        ModuleRequiresSym sym = (ModuleRequiresSym)super.cloneSelf(targetFile);
        return sym;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(' ');
        if (this.isPublic()) {
            buffer.append("public ");
        }
        buffer.append(this.getModuleName());
    }
}

