/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeBinding;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;

public class CatchParameterSym
extends FormalParameterSym
implements SourceCatchParameter {
    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 27: {
                Sym lastType = this.getLastChild((byte)27);
                if (lastType != null) {
                    return this.indexOf(lastType) + 1;
                }
                Sym nameType = this.getChild((byte)20);
                if (nameType != null) {
                    return this.indexOf(nameType) + 1;
                }
                return this.getChildren().size();
            }
            case 20: {
                return this.getChildren().size();
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    public List<SourceTypeReference> getSourceTypes() {
        return this.getChildrenList(27);
    }

    @Override
    public void setSourceTypes(List<SourceTypeReference> sourceTypes) {
        List<SourceElement> currentTypes = this.getChildren(27);
        for (Sym sym : currentTypes) {
            this.remove(sym);
        }
        if (sourceTypes != null) {
            for (SourceTypeReference newType : sourceTypes) {
                this.add((Sym)((Object)newType));
            }
        }
    }

    @Override
    protected synchronized JavaElement resolveImpl(CompilerDriver compiler) {
        JavaType currentLubType = this.getLubType();
        if (currentLubType == null) {
            super.resolveImpl(compiler);
            currentLubType = compiler.resolve(this);
            this.setLubType(currentLubType);
        }
        return currentLubType;
    }

    @Override
    public JavaType getResolvedType() {
        JavaType currentLubType = this.getLubType();
        if (currentLubType == null) {
            currentLubType = (JavaType)this.resolve();
            this.setLubType(currentLubType);
        }
        return currentLubType;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    private JavaType getLubType() {
        TypeBinding binding = (TypeBinding)this.getInternalBinding(12);
        if (binding != null) {
            return binding.getResolvedType();
        }
        return null;
    }

    private void setLubType(JavaType lubType) {
        TypeBinding binding = new TypeBinding(lubType);
        this.setInternalBinding(binding);
    }
}

