/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import oracle.javatools.parser.java.v2.classfile.Convert;
import oracle.javatools.parser.java.v2.classfile.Name;

public final class NamePool {
    public static boolean equals(Name one, Name other) {
        if (one == null || other == null) {
            return false;
        }
        return one.equals(other);
    }

    public static Name fromUTF(byte[] cs, int offset, int len) {
        byte[] copy = new byte[len];
        System.arraycopy(cs, offset, copy, 0, len);
        return new Name(copy);
    }

    public static Name fromUTF(byte[] cs) {
        return new Name(cs);
    }

    public static Name fromSource(byte[] cs, int offset, int len) {
        byte[] bytes = Convert.source2ascii(cs, offset, len);
        return NamePool.fromUTF(bytes, 0, bytes.length);
    }

    public static Name fromString(String s) {
        byte[] source = Convert.string2source(s);
        Name n = NamePool.fromSource(source, 0, source.length);
        n.setString(s);
        return n;
    }

    byte[] toUTF(Name n) {
        return n.toUTF();
    }

    byte[] toSource(Name n) {
        return n.toSource();
    }

    String toString(Name n) {
        return n.toString();
    }
}

