/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.classfile.ClFile;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaModule;
import oracle.javatools.parser.java.v2.model.JavaModuleExports;
import oracle.javatools.parser.java.v2.model.JavaModuleOpens;
import oracle.javatools.parser.java.v2.model.JavaModuleProvides;
import oracle.javatools.parser.java.v2.model.JavaModuleRequires;
import oracle.javatools.parser.java.v2.model.JavaModuleUses;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceModule;

public class ModuleClass
implements JavaModule {
    private ClassFile classFile;
    private JavaProvider provider;
    private JavaFile javaFile;

    public ModuleClass(ClassFile classFile, JavaProvider provider) {
        if (classFile == null) {
            throw new IllegalArgumentException("Null classFile");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Null provider");
        }
        this.classFile = classFile;
        this.provider = provider;
        this.javaFile = new ClFile(this, classFile.getURL());
    }

    @Override
    public int getElementKind() {
        return 13;
    }

    @Override
    public SourceModule getSourceElement() {
        return null;
    }

    @Override
    public String getName() {
        return this.classFile.getModule().getName();
    }

    @Override
    public String getVersion() {
        return this.classFile.getModule().getVersion();
    }

    @Override
    public boolean isOpen() {
        return this.classFile.getModule().isOpen();
    }

    @Override
    public boolean isSynthetic() {
        return this.classFile.getModule().isSynthetic();
    }

    @Override
    public boolean isMandated() {
        return this.classFile.getModule().isMandated();
    }

    @Override
    public Collection<JavaModuleRequires> getRequires() {
        ClassFile.ModuleRequires[] moduleRequires = this.classFile.getModule().getRequires();
        ArrayList<JavaModuleRequires> requiresList = new ArrayList<JavaModuleRequires>(moduleRequires.length);
        for (ClassFile.ModuleRequires requires : moduleRequires) {
            requiresList.add(new RequiresImpl(requires));
        }
        return requiresList;
    }

    @Override
    public Collection<JavaModuleExports> getExports() {
        ClassFile.ModuleExports[] moduleExports = this.classFile.getModule().getExports();
        ArrayList<JavaModuleExports> exportsList = new ArrayList<JavaModuleExports>(moduleExports.length);
        for (ClassFile.ModuleExports exports : moduleExports) {
            exportsList.add(new ExportsImpl(exports));
        }
        return exportsList;
    }

    @Override
    public Collection<JavaModuleOpens> getOpens() {
        ClassFile.ModuleOpens[] moduleOpens = this.classFile.getModule().getOpens();
        ArrayList<JavaModuleOpens> opensList = new ArrayList<JavaModuleOpens>(moduleOpens.length);
        for (ClassFile.ModuleOpens opens : moduleOpens) {
            opensList.add(new OpensImpl(opens));
        }
        return opensList;
    }

    @Override
    public Collection<JavaModuleUses> getUses() {
        String[] usesNames = this.classFile.getModule().getUses();
        ArrayList<JavaModuleUses> usesList = new ArrayList<JavaModuleUses>(usesNames.length);
        for (int i = 0; i < usesNames.length; ++i) {
            usesList.add(new UsesImpl(usesNames[i]));
        }
        return usesList;
    }

    @Override
    public Collection<JavaModuleProvides> getProvides() {
        ClassFile.ModuleProvides[] moduleProvides = this.classFile.getModule().getProvides();
        ArrayList<JavaModuleProvides> providesList = new ArrayList<JavaModuleProvides>(moduleProvides.length);
        for (int i = 0; i < moduleProvides.length; ++i) {
            providesList.add(new ProvidesImpl(moduleProvides[i]));
        }
        return providesList;
    }

    @Override
    public void clearCompiledInfo() {
    }

    @Override
    public JavaProvider getProvider() {
        return this.provider;
    }

    @Override
    public URL getURL() {
        return this.classFile.getURL();
    }

    @Override
    public JavaFile getFile() {
        return this.javaFile;
    }

    @Override
    public JavaElement getOwner() {
        return this.javaFile;
    }

    @Override
    public boolean isSourceElement() {
        return false;
    }

    @Override
    public int getModifiers() {
        ClassFile.Module module = this.classFile.getModule();
        int modifiers = 0;
        if (module.isSynthetic()) {
            modifiers |= 0x1000;
        }
        if (module.isMandated()) {
            modifiers |= 0x8000;
        }
        if (module.isOpen()) {
            modifiers |= 0x20;
        }
        return modifiers;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public String printCompiledInfo() {
        return "";
    }

    private class ProvidesImpl
    implements JavaModuleProvides {
        private ClassFile.ModuleProvides moduleProvides;

        private ProvidesImpl(ClassFile.ModuleProvides moduleProvides) {
            this.moduleProvides = moduleProvides;
        }

        @Override
        public String getServiceInterface() {
            return this.moduleProvides.getServiceInterface();
        }

        @Override
        public Collection<String> getServiceImplementations() {
            return this.moduleProvides.getServiceImplementations();
        }

        @Override
        public int getElementKind() {
            return 17;
        }

        @Override
        public JavaElement getOwner() {
            return ModuleClass.this;
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        @Override
        public JavaFile getFile() {
            return ModuleClass.this.getFile();
        }

        @Override
        public boolean isSourceElement() {
            return false;
        }

        @Override
        public SourceElement getSourceElement() {
            return null;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        public String printCompiledInfo() {
            return "";
        }
    }

    private class UsesImpl
    implements JavaModuleUses {
        private String serviceInterface;

        private UsesImpl(String serviceInterface) {
            this.serviceInterface = serviceInterface;
        }

        @Override
        public String getServiceInterface() {
            return this.serviceInterface;
        }

        @Override
        public int getElementKind() {
            return 16;
        }

        @Override
        public JavaElement getOwner() {
            return ModuleClass.this;
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        @Override
        public JavaFile getFile() {
            return ModuleClass.this.getFile();
        }

        @Override
        public boolean isSourceElement() {
            return false;
        }

        @Override
        public SourceElement getSourceElement() {
            return null;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        public String printCompiledInfo() {
            return "";
        }
    }

    private class OpensImpl
    implements JavaModuleOpens {
        private ClassFile.ModuleOpens moduleOpens;

        private OpensImpl(ClassFile.ModuleOpens moduleOpens) {
            this.moduleOpens = moduleOpens;
        }

        @Override
        public String getPackageName() {
            return this.moduleOpens.getPackageName();
        }

        @Override
        public boolean isSynthetic() {
            return this.moduleOpens.isSynthetic();
        }

        @Override
        public boolean isMandated() {
            return this.moduleOpens.isMandated();
        }

        @Override
        public Collection<String> getModuleNames() {
            return Arrays.asList(this.moduleOpens.getModulesNames());
        }

        @Override
        public int getElementKind() {
            return 18;
        }

        @Override
        public JavaFile getFile() {
            return ModuleClass.this.getFile();
        }

        @Override
        public JavaElement getOwner() {
            return ModuleClass.this;
        }

        @Override
        public boolean isSourceElement() {
            return false;
        }

        @Override
        public SourceElement getSourceElement() {
            return null;
        }

        @Override
        public int getModifiers() {
            int modifiers = 0;
            if (this.moduleOpens.isSynthetic()) {
                modifiers |= 0x1000;
            }
            if (this.moduleOpens.isMandated()) {
                modifiers |= 0x8000;
            }
            return modifiers;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        public String printCompiledInfo() {
            return "";
        }
    }

    private class ExportsImpl
    implements JavaModuleExports {
        private ClassFile.ModuleExports moduleExports;

        private ExportsImpl(ClassFile.ModuleExports moduleExports) {
            this.moduleExports = moduleExports;
        }

        @Override
        public String getPackageName() {
            return this.moduleExports.getPackageName();
        }

        @Override
        public Collection<String> getModuleNames() {
            return Arrays.asList(this.moduleExports.getModulesNames());
        }

        @Override
        public int getElementKind() {
            return 15;
        }

        @Override
        public JavaElement getOwner() {
            return ModuleClass.this;
        }

        @Override
        public int getModifiers() {
            int modifiers = 0;
            if (this.moduleExports.isSynthetic()) {
                modifiers |= 0x1000;
            }
            if (this.moduleExports.isMandated()) {
                modifiers |= 0x8000;
            }
            return modifiers;
        }

        @Override
        public JavaFile getFile() {
            return ModuleClass.this.getFile();
        }

        @Override
        public boolean isSourceElement() {
            return false;
        }

        @Override
        public SourceElement getSourceElement() {
            return null;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isSynthetic() {
            return this.moduleExports.isSynthetic();
        }

        @Override
        public boolean isMandated() {
            return this.moduleExports.isMandated();
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        public String printCompiledInfo() {
            return "";
        }
    }

    private class RequiresImpl
    implements JavaModuleRequires {
        private ClassFile.ModuleRequires moduleRequires;

        private RequiresImpl(ClassFile.ModuleRequires moduleRequires) {
            this.moduleRequires = moduleRequires;
        }

        @Override
        public boolean isTransitive() {
            return this.moduleRequires.isTransitive();
        }

        @Override
        public boolean isStaticPhase() {
            return this.moduleRequires.isStaticPhase();
        }

        @Override
        public boolean isSynthetic() {
            return this.moduleRequires.isSynthetic();
        }

        @Override
        public boolean isMandated() {
            return this.moduleRequires.isMandated();
        }

        @Override
        public String getModuleName() {
            return this.moduleRequires.getModuleName();
        }

        @Override
        public String getName() {
            return this.getModuleName();
        }

        @Override
        public String getVersion() {
            return this.moduleRequires.getVersion();
        }

        @Override
        public int getElementKind() {
            return 14;
        }

        @Override
        public JavaElement getOwner() {
            return ModuleClass.this;
        }

        @Override
        public int getModifiers() {
            int modifiers = 0;
            if (this.moduleRequires.isSynthetic()) {
                modifiers |= 0x1000;
            }
            if (this.moduleRequires.isMandated()) {
                modifiers |= 0x8000;
            }
            if (this.moduleRequires.isStaticPhase()) {
                modifiers |= 0x40;
            }
            if (this.moduleRequires.isTransitive()) {
                modifiers |= 0x20;
            }
            return modifiers;
        }

        @Override
        public JavaFile getFile() {
            return ModuleClass.this.getFile();
        }

        @Override
        public boolean isSourceElement() {
            return false;
        }

        @Override
        public SourceElement getSourceElement() {
            return null;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        public String printCompiledInfo() {
            return "";
        }
    }
}

