/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.parser.java.v2.classfile.ClClass;
import oracle.javatools.parser.java.v2.classfile.ModuleClass;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceModule;

public class ClFile
extends AbstractElement
implements JavaFile {
    private ClClass clClass;
    private ModuleClass moduleClass;
    private URL url;

    public ClFile(ClClass clClass, URL url) {
        if (clClass == null) {
            throw new IllegalArgumentException();
        }
        this.clClass = clClass;
        this.url = url;
    }

    public ClFile(ModuleClass moduleClass, URL url) {
        if (moduleClass == null) {
            throw new IllegalArgumentException();
        }
        this.moduleClass = moduleClass;
        this.url = url;
    }

    @Override
    public JavaFile getFile() {
        return this;
    }

    @Override
    public int getElementKind() {
        return 6;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public JavaElement getOwner() {
        return this.getPackage();
    }

    @Override
    public JavaPackage getPackage() {
        return this.moduleClass != null ? null : this.clClass.getPackage();
    }

    @Override
    public String getPackageName() {
        return this.moduleClass != null ? "" : this.clClass.getPackageName();
    }

    @Override
    public Collection<JavaClass> getClasses() {
        if (this.moduleClass != null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.clClass);
    }

    @Override
    public JavaClass getClass(String name) {
        if (this.clClass != null && name.equals(this.clClass.getName())) {
            return this.clClass;
        }
        return null;
    }

    @Override
    public JavaClass getPrimaryClass() {
        return this.clClass;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public void clearCompiledInfo() {
        if (this.moduleClass != null) {
            this.moduleClass.clearCompiledInfo();
        } else {
            this.clClass.clearCompiledInfo();
        }
    }

    @Override
    public SourceFile getSourceElement() {
        if (this.moduleClass != null) {
            SourceModule sourceModule = this.moduleClass.getSourceElement();
            if (sourceModule != null) {
                return sourceModule.getOwningSourceFile();
            }
        } else {
            SourceClass cls = this.clClass.getSourceElement();
            if (cls != null) {
                return cls.getOwningSourceFile();
            }
        }
        return null;
    }

    public String toString() {
        URL url = this.getURL();
        return url != null ? url.getPath() : super.toString();
    }

    @Override
    public ModuleClass getModule() {
        return this.moduleClass;
    }
}

