/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.formatter.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.formatter.java.JavaFormatterBundle;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.parser.java.v2.write.SourceTransaction;

public class JavaFormatter {
    private SourcePreferences sourcePreferences = null;
    private List<File> inputFiles = new ArrayList<File>();
    private List<File> filesToFormat = new ArrayList<File>();
    private boolean recursive = false;
    private JdkVersion jdkVersion = null;
    private String encoding = null;
    private String[] options;
    private String usage;
    private boolean quiet;
    private int errorCode;

    private JavaFormatter(String[] options, String usage) {
        this.options = options;
        this.usage = usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCodeStyleOptionsFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            JavaFormatter.message("formatter.code.style.option.file.exists", path);
            int ch = 0;
            try {
                ch = System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (ch != 121) {
                return;
            }
        }
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(file);
                ((OutputStream)outputStream).write("<?xml version = '1.0' encoding = 'UTF-8'?>\n".getBytes());
                ((OutputStream)outputStream).write("<profile xmlns=\"http://xmlns.oracle.com/jdeveloper/110000coding-style-profile\">\n\n".getBytes());
                HashMap<String, Integer> options = new HashMap<String, Integer>();
                for (int x = 0; x < 115; ++x) {
                    if (x == 107 || x == 108 || x == 88 || x == 89 || x == 90 || x == 92) continue;
                    options.put(JavaPreferences.PREFERENCES_keys[x - 0], x);
                }
                Set optionSet = options.entrySet();
                Map.Entry[] optionArray = optionSet.toArray(new Map.Entry[options.size()]);
                Arrays.sort(optionArray, new Comparator<Map.Entry<String, Integer>>(){

                    @Override
                    public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                boolean emitWrapExplanation = true;
                boolean emitImportNarrow = true;
                for (int x = 0; x < optionArray.length; ++x) {
                    int baseRelativeIndex = (Integer)optionArray[x].getValue();
                    int zeroRelativeIndex = baseRelativeIndex - 0;
                    if (emitWrapExplanation && JavaPreferences.PREFERENCES_keys[zeroRelativeIndex].indexOf("wrap") >= 0) {
                        emitWrapExplanation = false;
                        ((OutputStream)outputStream).write("\n    <!--\n".getBytes());
                        ((OutputStream)outputStream).write("      For wrap related settings that determine if wrapping\n".getBytes());
                        ((OutputStream)outputStream).write("      should occur \"never\", \"if long\", or \"always\",\n".getBytes());
                        ((OutputStream)outputStream).write("      use 0 for never, 1 for if long, and 2 for always.\n".getBytes());
                        ((OutputStream)outputStream).write("    -->\n\n".getBytes());
                    } else if (emitImportNarrow && JavaPreferences.PREFERENCES_keys[zeroRelativeIndex].indexOf("import.narrow") >= 0) {
                        emitImportNarrow = false;
                        ((OutputStream)outputStream).write("\n    <!--\n".getBytes());
                        ((OutputStream)outputStream).write("      For narrow import related settings that determine if an\n".getBytes());
                        ((OutputStream)outputStream).write("      import should be narrow or wide, use -1 for always use narrow imports,\n".getBytes());
                        ((OutputStream)outputStream).write("      or specifiy the maximum number of packages in an import before that\n".getBytes());
                        ((OutputStream)outputStream).write("      import is turned into a wide import.\n".getBytes());
                        ((OutputStream)outputStream).write("    -->\n\n".getBytes());
                    }
                    ((OutputStream)outputStream).write("    <!-- ".getBytes());
                    ((OutputStream)outputStream).write(JavaPreferences.PREFERENCES_explanations[zeroRelativeIndex].getBytes());
                    ((OutputStream)outputStream).write(" -->\n".getBytes());
                    ((OutputStream)outputStream).write("    <value n=\"".getBytes());
                    ((OutputStream)outputStream).write(((String)optionArray[x].getKey()).getBytes());
                    ((OutputStream)outputStream).write("\" v=\"".getBytes());
                    Object value = JavaPreferences.PREFERENCES_defaults[zeroRelativeIndex];
                    if (value instanceof Integer && (Integer)value < -1) {
                        value = JavaPreferences.PREFERENCES_defaults[-((Integer)value).intValue() - 0];
                    }
                    ((OutputStream)outputStream).write(value.toString().getBytes());
                    ((OutputStream)outputStream).write("\"/>\n\n".getBytes());
                }
                ((OutputStream)outputStream).write("</profile>\n".getBytes());
                if (!this.quiet) {
                    JavaFormatter.message("formatter.code.style.option.file.created", file.getPath());
                }
            }
            finally {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                    outputStream = null;
                }
            }
            this.errorCode = 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            JavaFormatter.message("formatter.error.writing.code.style.option.file", e.getMessage());
        }
    }

    private static void message(String key, String argument) {
        JavaFormatter.message(key, argument, 0);
    }

    private static void message(String key, String argument, int indent) {
        for (int x = 0; x < indent; ++x) {
            System.out.print(' ');
        }
        if (argument == null) {
            System.out.println(JavaFormatterBundle.get(key));
        } else {
            System.out.println(JavaFormatterBundle.format(key, argument));
        }
    }

    private void usage() {
        System.out.println(this.usage);
    }

    private static int stringKeyToIntKey(String key) {
        for (int x = 0; x < 115; ++x) {
            if (!JavaPreferences.PREFERENCES_keys[x - 0].equals(key)) continue;
            return x;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SourcePreferences getSourcePreferences(String path) {
        File file = new File(path);
        if (!file.exists()) {
            JavaFormatter.message("formatter.error.file.not.found", path);
            return null;
        }
        FileReader reader = null;
        BufferedReader buffer = null;
        try {
            SourcePreferences sourcePreferences;
            reader = new FileReader(file);
            buffer = new BufferedReader(reader);
            SourcePreferences sourcePreferences2 = new SourcePreferences();
            String line = null;
            while ((line = buffer.readLine()) != null) {
                String stringKey;
                int intKey;
                if (!(line = line.trim()).startsWith("<value n")) continue;
                String[] pieces = line.split("\"");
                if (pieces.length < 4 || (intKey = JavaFormatter.stringKeyToIntKey(stringKey = pieces[1])) < 0) break;
                String value = pieces[3].toLowerCase();
                if ("true".equals(value) || "false".equals(value)) {
                    sourcePreferences2.setBoolean(intKey, Boolean.valueOf(value));
                    continue;
                }
                try {
                    sourcePreferences2.setInt(intKey, Integer.valueOf(value));
                }
                catch (NumberFormatException ex) {
                    break;
                }
            }
            if (line != null) {
                JavaFormatter.message("formatter.error.invalid.code.style.option.entry", line);
                sourcePreferences = null;
                return sourcePreferences;
            }
            sourcePreferences = sourcePreferences2;
            return sourcePreferences;
        }
        catch (IOException ex) {
            JavaFormatter.message("formatter.error.reading.code.style.option.file", ex.getMessage());
        }
        finally {
            try {
                if (buffer != null) {
                    buffer.close();
                } else if (reader != null) {
                    reader.close();
                }
                buffer = null;
                reader = null;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void addFile(File file, List<File> files, boolean recursive) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                if (child.isFile()) {
                    if (!child.getPath().endsWith(".java")) continue;
                    files.add(child);
                    continue;
                }
                if (!recursive) continue;
                JavaFormatter.addFile(child, files, recursive);
            }
        } else {
            files.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean formatFile(File file, JdkVersion jdkVersion, SourcePreferences sourcePreferences, String encoding, boolean quiet, int indent) {
        String fileName = file.getPath();
        FileInputStream input = null;
        InputStreamReader reader = null;
        FileOutputStream output = null;
        OutputStreamWriter writer = null;
        try {
            SourceFile sourceFile;
            if (!quiet) {
                JavaFormatter.message("formatter.formatting.file", fileName, indent);
            }
            if (!file.canRead() || !file.canWrite()) {
                if (quiet) {
                    JavaFormatter.message("formatter.formatting.file", fileName, indent);
                }
                JavaFormatter.message("formatter.error.file.no.read.write.access", null, indent);
                return false;
            }
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
            try {
                input = new FileInputStream(file);
                reader = encoding == null ? new InputStreamReader(input) : new InputStreamReader((InputStream)input, encoding);
                textBuffer.read(reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                } else if (input != null) {
                    input.close();
                }
                reader = null;
                input = null;
            }
            if (jdkVersion == null) {
                jdkVersion = JavaParser.getJdkVersion();
            }
            if ((sourceFile = JavaParser.parse((ReadTextBuffer)textBuffer, jdkVersion)) == null) {
                if (quiet) {
                    JavaFormatter.message("formatter.formatting.file", fileName, indent);
                }
                JavaFormatter.message("formatter.error.unable.to.get.source.file", null, indent);
                return false;
            }
            List<SourceError> errors = sourceFile.getParseErrors();
            boolean hasErrors = false;
            for (int x = 0; x < errors.size(); ++x) {
                SourceError error = errors.get(x);
                if (error.getErrorSeverity() < 4) continue;
                hasErrors = true;
                break;
            }
            if (hasErrors) {
                if (quiet) {
                    JavaFormatter.message("formatter.formatting.file", fileName, indent);
                }
                JavaFormatter.message("formatter.error.source.has.errors", null, indent);
                return false;
            }
            sourceFile.setTextBuffer(textBuffer);
            sourceFile.setPreferences(sourcePreferences);
            SourceTransaction transaction = null;
            try {
                transaction = sourceFile.beginTransaction();
                if (!sourceFile.reformatSelf(0)) {
                    boolean bl = false;
                    return bl;
                }
                transaction.commit();
                transaction = null;
            }
            finally {
                if (transaction != null) {
                    transaction.abort();
                    if (quiet) {
                        JavaFormatter.message("formatter.formatting.file", fileName, indent);
                    }
                    JavaFormatter.message("formatter.error.format.failed", null, indent);
                }
            }
            try {
                output = new FileOutputStream(file);
                writer = encoding == null ? new OutputStreamWriter(output) : new OutputStreamWriter((OutputStream)output, encoding);
                textBuffer.write(writer);
                return true;
            }
            finally {
                if (writer != null) {
                    writer.close();
                } else if (output != null) {
                    output.close();
                }
                writer = null;
                output = null;
            }
        }
        catch (Exception ex) {
            if (quiet) {
                JavaFormatter.message("formatter.formatting.file", fileName, indent);
            }
            JavaFormatter.message("formatter.error.formatting.file", ex.getMessage(), indent);
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatAllFiles(List<File> files, JdkVersion jdkVersion, SourcePreferences sourcePreferences, String encoding) {
        long seconds;
        long minutes;
        long elapsedTime = System.currentTimeMillis();
        int count = 0;
        int failures = 0;
        try {
            for (File file : files) {
                if (!JavaFormatter.formatFile(file, jdkVersion, sourcePreferences, encoding, this.quiet, 0)) {
                    ++failures;
                }
                ++count;
            }
            this.errorCode = failures > 0 ? 1 : 0;
        }
        catch (Throwable throwable) {
            long seconds2;
            long minutes2;
            System.out.println(JavaFormatterBundle.format("formatter.format.done", "" + count, "" + failures));
            long msecTime = elapsedTime = System.currentTimeMillis() - elapsedTime;
            long hours = elapsedTime / 3600000L;
            if (hours > 0L) {
                elapsedTime -= hours * 3600000L;
            }
            if ((minutes2 = elapsedTime / 60000L) > 0L) {
                elapsedTime -= minutes2 * 60000L;
            }
            if ((seconds2 = elapsedTime / 1000L) > 0L) {
                elapsedTime -= seconds2 * 1000L;
            }
            String msg = JavaFormatterBundle.format("formatter.total.time", msecTime, hours, minutes2, seconds2, elapsedTime);
            System.out.println(msg);
            System.out.println();
            System.out.println();
            throw throwable;
        }
        System.out.println(JavaFormatterBundle.format("formatter.format.done", "" + count, "" + failures));
        long msecTime = elapsedTime = System.currentTimeMillis() - elapsedTime;
        long hours = elapsedTime / 3600000L;
        if (hours > 0L) {
            elapsedTime -= hours * 3600000L;
        }
        if ((minutes = elapsedTime / 60000L) > 0L) {
            elapsedTime -= minutes * 60000L;
        }
        if ((seconds = elapsedTime / 1000L) > 0L) {
            elapsedTime -= seconds * 1000L;
        }
        String msg = JavaFormatterBundle.format("formatter.total.time", msecTime, hours, minutes, seconds, elapsedTime);
        System.out.println(msg);
        System.out.println();
        System.out.println();
    }

    public static JdkVersion checkSourceOption(String source) {
        String number = source;
        if (number.equals("1.3")) {
            return JdkVersion.JDK_1_3;
        }
        if (number.equals("1.4")) {
            return JdkVersion.JDK_1_4;
        }
        if (number.equals("1.5")) {
            return JdkVersion.JDK_1_5;
        }
        if (number.equals("1.6")) {
            return JdkVersion.JDK_1_6;
        }
        if (number.equals("1.7")) {
            return JdkVersion.JDK_1_7;
        }
        JavaFormatter.message("formatter.error.invalid.source.number", null);
        return null;
    }

    public static String checkEncoding(String encoding) {
        try {
            if (!Charset.isSupported(encoding)) {
                JavaFormatter.message("formatter.error.unsupported.encoding", encoding);
                return null;
            }
        }
        catch (Exception ex) {
            JavaFormatter.message("formatter.error.unknown.encoding", encoding);
            return null;
        }
        return encoding;
    }

    private boolean checkOptions() {
        if (this.options.length == 0) {
            this.usage();
            return false;
        }
        System.out.println();
        this.errorCode = 1;
        for (int x = 0; x < this.options.length; ++x) {
            String option = this.options[x];
            if (option.equals("-help") || option.equals("--help")) {
                this.usage();
                this.errorCode = 0;
                return false;
            }
            if (option.equals("-codestyle")) {
                if (x + 1 < this.options.length) {
                    this.sourcePreferences = JavaFormatter.getSourcePreferences(this.options[++x]);
                    if (this.sourcePreferences != null) continue;
                    return false;
                }
                JavaFormatter.message("formatter.error.no.code.style.file", null);
                System.out.println();
                this.usage();
                return false;
            }
            if (option.equals("-create")) {
                if (this.options.length > 2) {
                    JavaFormatter.message("formatter.error.create.only.option", null);
                    System.out.println();
                    this.usage();
                    return false;
                }
                if (x + 1 < this.options.length) {
                    this.createCodeStyleOptionsFile(this.options[++x]);
                    return false;
                }
                JavaFormatter.message("formatter.error.no.code.style.file", null);
                System.out.println();
                this.usage();
                return false;
            }
            if (option.equals("-recursive")) {
                this.recursive = true;
                continue;
            }
            if (option.equals("-source")) {
                if (x + 1 < this.options.length) {
                    this.jdkVersion = JavaFormatter.checkSourceOption(this.options[++x]);
                    if (this.jdkVersion != null) continue;
                    return false;
                }
                JavaFormatter.message("formatter.error.no.source.number", null);
                System.out.println();
                this.usage();
                return false;
            }
            if (option.equals("-encoding")) {
                if (x + 1 < this.options.length) {
                    this.encoding = JavaFormatter.checkEncoding(this.options[++x]);
                    if (this.encoding != null) continue;
                    return false;
                }
                JavaFormatter.message("formatter.error.no.encoding", null);
                System.out.println();
                this.usage();
                return false;
            }
            if (option.equals("-quiet")) {
                this.quiet = true;
                continue;
            }
            if (!option.startsWith("-")) {
                File file = new File(option);
                if (!file.exists()) {
                    JavaFormatter.message("formatter.error.file.not.found", option);
                    return false;
                }
                if (file.isFile() && !file.getPath().endsWith(".java")) {
                    JavaFormatter.message("formatter.error.no.java.file", option);
                    return false;
                }
                this.inputFiles.add(file);
                continue;
            }
            JavaFormatter.message("formatter.error.unknown.option", option);
            System.out.println();
            this.usage();
            return false;
        }
        if (this.sourcePreferences == null) {
            JavaFormatter.message("formatter.error.no.code.style.option", null);
            System.out.println();
            this.usage();
            return false;
        }
        if (this.inputFiles.isEmpty()) {
            JavaFormatter.message("formatter.error.no.files.or.directories", null);
            System.out.println();
            this.usage();
            return false;
        }
        for (File inputFile : this.inputFiles) {
            JavaFormatter.addFile(inputFile, this.filesToFormat, this.recursive);
        }
        this.errorCode = 0;
        return true;
    }

    private void format() {
        if (!this.quiet) {
            JavaFormatter.message("formatter.arguments", null);
            for (String argument : this.options) {
                System.out.println(argument);
            }
            System.out.println();
        }
        this.formatAllFiles(this.filesToFormat, this.jdkVersion, this.sourcePreferences, this.encoding);
    }

    public static void main(String[] args) {
        JavaFormatter javaFormatter = new JavaFormatter(args, JavaFormatterBundle.get("formatter.usage.message"));
        if (javaFormatter.checkOptions()) {
            javaFormatter.format();
        }
        if (javaFormatter.errorCode > 0) {
            System.exit(1);
        }
    }
}

