/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.sequence;

import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;

public class SequenceCompareDifference
extends BaseCompareDifference {
    public static final int TYPE_NOCHANGE = 0;
    public static final int TYPE_CHANGE = 2;
    protected int _firstStart;
    protected int _firstLength;
    protected int _secondStart;
    protected int _secondLength;
    protected int _ancestorStart;
    protected int _ancestorLength;

    public SequenceCompareDifference(int kind) {
        super(kind);
    }

    protected SequenceCompareDifference(SequenceCompareDifference differenceBlock) {
        super(differenceBlock);
        this.setFirstStart(differenceBlock._firstStart);
        this.setFirstLength(differenceBlock._firstLength);
        this.setSecondStart(differenceBlock._secondStart);
        this.setSecondLength(differenceBlock._secondLength);
        this.setAncestorStart(differenceBlock._ancestorStart);
        this.setAncestorLength(differenceBlock._ancestorLength);
    }

    @Override
    public boolean hasContribution(ContributorKind contributorKind) {
        return this.getLength(contributorKind) > 0;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Kind=");
        str.append(this.getKind() == 2 ? "TYPE_CHANGE" : "TYPE_NOCHANGE");
        str.append("; Id=");
        str.append(this.getId());
        str.append("; 1 Start=");
        str.append(String.valueOf(this.getStart(ContributorKind.FIRST)));
        str.append("; 1 Length=");
        str.append(String.valueOf(this.getLength(ContributorKind.FIRST)));
        str.append("; 2 Start=");
        str.append(String.valueOf(this.getStart(ContributorKind.SECOND)));
        str.append("; 2 Length=");
        str.append(String.valueOf(this.getLength(ContributorKind.SECOND)));
        str.append("; A Start=");
        str.append(String.valueOf(this.getStart(ContributorKind.ANCESTOR)));
        str.append("; A Length=");
        str.append(String.valueOf(this.getLength(ContributorKind.ANCESTOR)));
        str.append(";");
        return str.toString();
    }

    public int getMaxLength() {
        return Math.max(Math.max(this._firstLength, this._secondLength), this._ancestorLength);
    }

    public void setFirstStart(int firstStart) {
        this._firstStart = firstStart;
    }

    public int getFirstStart() {
        return this._firstStart;
    }

    public void setFirstLength(int firstLength) {
        this._firstLength = firstLength;
    }

    public int getFirstLength() {
        return this._firstLength;
    }

    public void setSecondStart(int secondStart) {
        this._secondStart = secondStart;
    }

    public int getSecondStart() {
        return this._secondStart;
    }

    public void setSecondLength(int secondLength) {
        this._secondLength = secondLength;
    }

    public int getSecondLength() {
        return this._secondLength;
    }

    public void setAncestorStart(int ancestorStart) {
        this._ancestorStart = ancestorStart;
    }

    public int getAncestorStart() {
        return this._ancestorStart;
    }

    public void setAncestorLength(int ancestorLength) {
        this._ancestorLength = ancestorLength;
    }

    public int getAncestorLength() {
        return this._ancestorLength;
    }

    public void setStart(ContributorKind contributor, int start) {
        if (contributor == ContributorKind.ANCESTOR) {
            this.setAncestorStart(start);
            return;
        }
        if (contributor == ContributorKind.FIRST) {
            this.setFirstStart(start);
            return;
        }
        if (contributor == ContributorKind.SECOND) {
            this.setSecondStart(start);
            return;
        }
        assert (false);
    }

    public void setLength(ContributorKind contributor, int length) {
        if (contributor == ContributorKind.ANCESTOR) {
            this.setAncestorLength(length);
            return;
        }
        if (contributor == ContributorKind.FIRST) {
            this.setFirstLength(length);
            return;
        }
        if (contributor == ContributorKind.SECOND) {
            this.setSecondLength(length);
            return;
        }
        assert (false);
    }

    public int getStart(ContributorKind contributor) {
        if (contributor == ContributorKind.ANCESTOR) {
            return this.getAncestorStart();
        }
        if (contributor == ContributorKind.FIRST) {
            return this.getFirstStart();
        }
        if (contributor == ContributorKind.SECOND) {
            return this.getSecondStart();
        }
        assert (false);
        return -1;
    }

    public int getLength(ContributorKind contributor) {
        if (contributor == ContributorKind.ANCESTOR) {
            return this.getAncestorLength();
        }
        if (contributor == ContributorKind.FIRST) {
            return this.getFirstLength();
        }
        if (contributor == ContributorKind.SECOND) {
            return this.getSecondLength();
        }
        assert (false);
        return -1;
    }

    @Override
    public Object clone() {
        return new SequenceCompareDifference(this);
    }
}

