/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Map;
import java.util.TreeMap;
import oracle.ide.util.JDevUncaughtExceptionHandler;

public final class ChainingUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static Map<Integer, JDevUncaughtExceptionHandler> registeredHandlers;

    public static void registerHandler(JDevUncaughtExceptionHandler handler, int priority) {
        if (registeredHandlers == null) {
            registeredHandlers = new TreeMap<Integer, JDevUncaughtExceptionHandler>();
        }
        registeredHandlers.put(priority, handler);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        for (JDevUncaughtExceptionHandler handler : registeredHandlers.values()) {
            if (!handler.uncaughtException(t, e)) continue;
            return;
        }
    }
}

